/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.mechanism;

import com.denfop.IUItem;
import com.denfop.api.Recipes;
import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.container.CustomWorldContainer;
import com.denfop.api.crafting.BaseRecipe;
import com.denfop.api.recipe.BaseMachineRecipe;
import com.denfop.api.recipe.IHasRecipe;
import com.denfop.api.recipe.IUpdateTick;
import com.denfop.api.recipe.Input;
import com.denfop.api.recipe.InventoryRecipes;
import com.denfop.api.recipe.MachineRecipe;
import com.denfop.api.recipe.RecipeOutput;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.blockentity.base.BlockEntityElectricMachine;
import com.denfop.blockentity.base.BlockEntityInventory;
import com.denfop.blockentity.mechanism.BlockEntityGenerationMicrochip;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine3Entity;
import com.denfop.componets.AirPollutionComponent;
import com.denfop.componets.ComponentProcess;
import com.denfop.componets.ComponentProgress;
import com.denfop.componets.ComponentUpgrade;
import com.denfop.componets.ComponentUpgradeSlots;
import com.denfop.componets.SoilPollutionComponent;
import com.denfop.componets.TypeUpgrade;
import com.denfop.containermenu.ContainerMenuBase;
import com.denfop.containermenu.ContainerMenuUpgradeMachineFactory;
import com.denfop.inventory.InventoryUpgrade;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.recipe.IInputItemStack;
import com.denfop.recipe.InputItemStack;
import com.denfop.recipes.BasicRecipeTwo;
import com.denfop.recipes.ItemStackHelper;
import com.denfop.screen.ScreenIndustrialUpgrade;
import com.denfop.screen.ScreenUpgradeMachineFactory;
import com.denfop.utils.Keyboard;
import com.denfop.utils.Localization;
import com.denfop.utils.ModUtils;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockEntityUpgradeMachineFactory
extends BlockEntityElectricMachine
implements IUpgradableBlock,
IUpdateTick,
IUpdatableTileEvent,
IHasRecipe {
    public final InventoryUpgrade upgradeSlot;
    public final ComponentUpgradeSlots componentUpgrade;
    public final ComponentProgress componentProgress;
    public final ComponentProcess componentProcess;
    public final InventoryRecipes inputSlotA;
    public final ComponentUpgrade componentUpgrades;
    public MachineRecipe output;

    public BlockEntityUpgradeMachineFactory(BlockPos pos, BlockState state) {
        super(400.0, 1, 1, BlockBaseMachine3Entity.upgrade_machine, pos, state);
        Recipes.recipes.addInitRecipes(this);
        this.upgradeSlot = new InventoryUpgrade(this, 4);
        this.componentUpgrade = this.addComponent(new ComponentUpgradeSlots(this, this.upgradeSlot));
        this.componentProgress = this.addComponent(new ComponentProgress((BlockEntityInventory)this, 1, 200));
        this.inputSlotA = new InventoryRecipes((BlockEntityInventory)this, "upgrade_machine", (IUpdateTick)this);
        this.inputSlotA.setStackSizeLimit(1);
        this.componentProcess = this.addComponent(new ComponentProcess(this, 200, 1.0));
        this.componentProcess.setHasAudio(false);
        this.componentProcess.setSlotOutput(this.outputSlot);
        this.componentProcess.setInvSlotRecipes(this.inputSlotA);
        this.componentUpgrades = this.addComponent(new ComponentUpgrade(this, TypeUpgrade.INSTANT));
        this.pollutionSoil = this.addComponent(new SoilPollutionComponent(this, 0.1));
        this.pollutionAir = this.addComponent(new AirPollutionComponent(this, 0.1));
    }

    public static void addRecipe(BaseRecipe baseRecipe, int upgrade) {
        try {
            NonNullList<IInputItemStack> ingredients = baseRecipe.getListInput();
            ItemStack outputStack = baseRecipe.getOutput();
            ItemStack input_mechanism = ((IInputItemStack)ingredients.get(4)).getInputs().get(0);
            ArrayList<IInputItemStack> inputs = new ArrayList<IInputItemStack>();
            ItemStack upgradeStack = new ItemStack((ItemLike)IUItem.machinekit.getStack(upgrade), 1);
            for (IInputItemStack ingredient : ingredients) {
                if (ingredient == InputItemStack.EMPTY) {
                    inputs.add(InputItemStack.EMPTY);
                    continue;
                }
                ItemStack input = ingredient.getInputs().get(0);
                if (input.m_150930_(input_mechanism.m_41720_())) {
                    inputs.add(new InputItemStack(upgradeStack.m_41777_()));
                    continue;
                }
                inputs.add(ingredient);
            }
            CompoundTag tagCompound = new CompoundTag();
            outputStack.m_41739_(tagCompound);
            CompoundTag tagCompound2 = new CompoundTag();
            input_mechanism.m_41739_(tagCompound2);
            CompoundTag tagCompound1 = ModUtils.nbt(upgradeStack);
            tagCompound1.m_128365_("output", (Tag)tagCompound);
            tagCompound1.m_128365_("input", (Tag)tagCompound2);
            Recipes.recipes.addRecipe("upgrade_machine", new BaseMachineRecipe(new Input(inputs), new RecipeOutput(null, upgradeStack)));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void init() {
        BlockEntityUpgradeMachineFactory.addRecipe(Recipes.recipe.addRecipe(ItemStackHelper.fromData(IUItem.machines, 1, 1), "DED", "BCB", "AAA", Character.valueOf('E'), ItemStackHelper.fromData(IUItem.core, 1, 5), Character.valueOf('D'), "forge:doubleplate/Alumel", Character.valueOf('B'), BlockEntityGenerationMicrochip.getLevelCircuit(IUItem.cirsuitQuantum, 7), Character.valueOf('C'), ItemStackHelper.fromData(IUItem.simplemachine, 1, 6), Character.valueOf('A'), ItemStackHelper.fromData(IUItem.quantumtool)), 0);
        BlockEntityUpgradeMachineFactory.addRecipe(Recipes.recipe.addRecipe(ItemStackHelper.fromData(IUItem.machines, 1, 2), "DED", "BCB", "AAA", Character.valueOf('E'), ItemStackHelper.fromData(IUItem.core, 1, 7), Character.valueOf('D'), "forge:doubleplate/Vitalium", Character.valueOf('B'), BlockEntityGenerationMicrochip.getLevelCircuit(IUItem.cirsuitQuantum, 7), Character.valueOf('C'), ItemStackHelper.fromData(IUItem.machines, 1, 1), Character.valueOf('A'), ItemStackHelper.fromData(IUItem.advQuantumtool)), 1);
        BlockEntityUpgradeMachineFactory.addRecipe(Recipes.recipe.addRecipe(ItemStackHelper.fromData(IUItem.machines, 1, 3), "DED", "BCB", "AFA", Character.valueOf('F'), ItemStackHelper.fromData(IUItem.doublecompressIridiumplate), Character.valueOf('E'), ItemStackHelper.fromData(IUItem.core, 1, 8), Character.valueOf('D'), "forge:doubleplate/Duralumin", Character.valueOf('B'), BlockEntityGenerationMicrochip.getLevelCircuit(IUItem.circuitSpectral, 9), Character.valueOf('C'), ItemStackHelper.fromData(IUItem.machines, 1, 2), Character.valueOf('A'), ItemStackHelper.fromData(IUItem.advQuantumtool)), 2);
        BlockEntityUpgradeMachineFactory.addRecipe(Recipes.recipe.addRecipe(ItemStackHelper.fromData(IUItem.machines_base, 1, 0), "A A", "DBE", "ACA", Character.valueOf('A'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 138), Character.valueOf('C'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 20), Character.valueOf('D'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 47), Character.valueOf('E'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 2), Character.valueOf('B'), ItemStackHelper.fromData(IUItem.simplemachine, 1, 0)), 0);
        BlockEntityUpgradeMachineFactory.addRecipe(Recipes.recipe.addRecipe(ItemStackHelper.fromData(IUItem.machines_base, 1, 1), "A A", "DBE", "ACA", Character.valueOf('A'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 139), Character.valueOf('C'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 96), Character.valueOf('D'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 49), Character.valueOf('E'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 78), Character.valueOf('B'), ItemStackHelper.fromData(IUItem.machines_base, 1, 0)), 1);
        BlockEntityUpgradeMachineFactory.addRecipe(Recipes.recipe.addRecipe(ItemStackHelper.fromData(IUItem.machines_base, 1, 2), "A A", "DBE", "ACA", Character.valueOf('A'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 140), Character.valueOf('C'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 120), Character.valueOf('D'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 51), Character.valueOf('E'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 103), Character.valueOf('B'), ItemStackHelper.fromData(IUItem.machines_base, 1, 1)), 2);
        BlockEntityUpgradeMachineFactory.addRecipe(Recipes.recipe.addRecipe(ItemStackHelper.fromData(IUItem.machines_base, 1, 6), "A A", "DBE", "ACA", Character.valueOf('A'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 138), Character.valueOf('C'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 20), Character.valueOf('D'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 47), Character.valueOf('E'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 225), Character.valueOf('B'), ItemStackHelper.fromData(IUItem.simplemachine, 1, 2)), 0);
        BlockEntityUpgradeMachineFactory.addRecipe(Recipes.recipe.addRecipe(ItemStackHelper.fromData(IUItem.machines_base, 1, 7), "A A", "DBE", "ACA", Character.valueOf('A'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 139), Character.valueOf('C'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 96), Character.valueOf('D'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 49), Character.valueOf('E'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 221), Character.valueOf('B'), ItemStackHelper.fromData(IUItem.machines_base, 1, 6)), 1);
        BlockEntityUpgradeMachineFactory.addRecipe(Recipes.recipe.addRecipe(ItemStackHelper.fromData(IUItem.machines_base, 1, 8), "A A", "DBE", "ACA", Character.valueOf('A'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 140), Character.valueOf('C'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 120), Character.valueOf('D'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 51), Character.valueOf('E'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 223), Character.valueOf('B'), ItemStackHelper.fromData(IUItem.machines_base, 1, 7)), 2);
        BlockEntityUpgradeMachineFactory.addRecipe(Recipes.recipe.addRecipe(ItemStackHelper.fromData(IUItem.machines_base, 1, 9), "A A", "DBE", "ACA", Character.valueOf('A'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 138), Character.valueOf('C'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 20), Character.valueOf('D'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 47), Character.valueOf('E'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 160), Character.valueOf('B'), ItemStackHelper.fromData(IUItem.simplemachine, 1, 3)), 0);
        BlockEntityUpgradeMachineFactory.addRecipe(Recipes.recipe.addRecipe(ItemStackHelper.fromData(IUItem.machines_base, 1, 10), "A A", "DBE", "ACA", Character.valueOf('A'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 139), Character.valueOf('C'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 96), Character.valueOf('D'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 49), Character.valueOf('E'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 161), Character.valueOf('B'), ItemStackHelper.fromData(IUItem.machines_base, 1, 9)), 1);
        BlockEntityUpgradeMachineFactory.addRecipe(Recipes.recipe.addRecipe(ItemStackHelper.fromData(IUItem.machines_base, 1, 11), "A A", "DBE", "ACA", Character.valueOf('A'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 140), Character.valueOf('C'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 120), Character.valueOf('D'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 51), Character.valueOf('E'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 162), Character.valueOf('B'), ItemStackHelper.fromData(IUItem.machines_base, 1, 10)), 2);
        BlockEntityUpgradeMachineFactory.addRecipe(Recipes.recipe.addRecipe(ItemStackHelper.fromData(IUItem.machines_base, 1, 3), "A A", "DBE", "ACA", Character.valueOf('A'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 138), Character.valueOf('C'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 20), Character.valueOf('D'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 47), Character.valueOf('E'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 1), Character.valueOf('B'), ItemStackHelper.fromData(IUItem.simplemachine, 1, 1)), 0);
        BlockEntityUpgradeMachineFactory.addRecipe(Recipes.recipe.addRecipe(ItemStackHelper.fromData(IUItem.machines_base, 1, 4), "A A", "DBE", "ACA", Character.valueOf('A'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 139), Character.valueOf('C'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 96), Character.valueOf('D'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 49), Character.valueOf('E'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 77), Character.valueOf('B'), ItemStackHelper.fromData(IUItem.machines_base, 1, 3)), 1);
        BlockEntityUpgradeMachineFactory.addRecipe(Recipes.recipe.addRecipe(ItemStackHelper.fromData(IUItem.machines_base, 1, 5), "A A", "DBE", "ACA", Character.valueOf('A'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 140), Character.valueOf('C'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 120), Character.valueOf('D'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 51), Character.valueOf('E'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 102), Character.valueOf('B'), ItemStackHelper.fromData(IUItem.machines_base, 1, 4)), 2);
        BlockEntityUpgradeMachineFactory.addRecipe(Recipes.recipe.addRecipe(ItemStackHelper.fromData(IUItem.machines_base1, 1, 0), "A A", "DBE", "ACA", Character.valueOf('A'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 138), Character.valueOf('C'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 20), Character.valueOf('D'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 47), Character.valueOf('E'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 9), Character.valueOf('B'), ItemStackHelper.fromData(IUItem.simplemachine, 1, 5)), 0);
        BlockEntityUpgradeMachineFactory.addRecipe(Recipes.recipe.addRecipe(ItemStackHelper.fromData(IUItem.machines_base1, 1, 1), "A A", "DBE", "ACA", Character.valueOf('A'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 139), Character.valueOf('C'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 96), Character.valueOf('D'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 49), Character.valueOf('E'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 86), Character.valueOf('B'), ItemStackHelper.fromData(IUItem.machines_base1, 1, 0)), 1);
        BlockEntityUpgradeMachineFactory.addRecipe(Recipes.recipe.addRecipe(ItemStackHelper.fromData(IUItem.machines_base1, 1, 2), "A A", "DBE", "ACA", Character.valueOf('A'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 140), Character.valueOf('C'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 120), Character.valueOf('D'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 51), Character.valueOf('E'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 110), Character.valueOf('B'), ItemStackHelper.fromData(IUItem.machines_base1, 1, 1)), 2);
        BlockEntityUpgradeMachineFactory.addRecipe(Recipes.recipe.addRecipe(ItemStackHelper.fromData(IUItem.machines_base2, 1, 1), "A A", "DBE", "ACA", Character.valueOf('A'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 138), Character.valueOf('C'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 20), Character.valueOf('D'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 47), Character.valueOf('E'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 166), Character.valueOf('B'), ItemStackHelper.fromData(IUItem.machines_base2, 1, 0)), 0);
        BlockEntityUpgradeMachineFactory.addRecipe(Recipes.recipe.addRecipe(ItemStackHelper.fromData(IUItem.machines_base2, 1, 2), "A A", "DBE", "ACA", Character.valueOf('A'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 139), Character.valueOf('C'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 96), Character.valueOf('D'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 49), Character.valueOf('E'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 167), Character.valueOf('B'), ItemStackHelper.fromData(IUItem.machines_base2, 1, 1)), 1);
        BlockEntityUpgradeMachineFactory.addRecipe(Recipes.recipe.addRecipe(ItemStackHelper.fromData(IUItem.machines_base2, 1, 3), "A A", "DBE", "ACA", Character.valueOf('A'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 140), Character.valueOf('C'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 120), Character.valueOf('D'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 51), Character.valueOf('E'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 168), Character.valueOf('B'), ItemStackHelper.fromData(IUItem.machines_base2, 1, 2)), 2);
        BlockEntityUpgradeMachineFactory.addRecipe(Recipes.recipe.addRecipe(ItemStackHelper.fromData(IUItem.machines_base2, 1, 5), "A A", "DBE", "ACA", Character.valueOf('A'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 138), Character.valueOf('C'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 20), Character.valueOf('D'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 47), Character.valueOf('E'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 125), Character.valueOf('B'), ItemStackHelper.fromData(IUItem.machines_base2, 1, 4)), 0);
        BlockEntityUpgradeMachineFactory.addRecipe(Recipes.recipe.addRecipe(ItemStackHelper.fromData(IUItem.machines_base2, 1, 6), "A A", "DBE", "ACA", Character.valueOf('A'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 139), Character.valueOf('C'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 96), Character.valueOf('D'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 49), Character.valueOf('E'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 126), Character.valueOf('B'), ItemStackHelper.fromData(IUItem.machines_base2, 1, 5)), 1);
        BlockEntityUpgradeMachineFactory.addRecipe(Recipes.recipe.addRecipe(ItemStackHelper.fromData(IUItem.machines_base2, 1, 7), "A A", "DBE", "ACA", Character.valueOf('A'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 140), Character.valueOf('C'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 120), Character.valueOf('D'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 51), Character.valueOf('E'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 127), Character.valueOf('B'), ItemStackHelper.fromData(IUItem.machines_base2, 1, 6)), 2);
        BlockEntityUpgradeMachineFactory.addRecipe(Recipes.recipe.addRecipe(ItemStackHelper.fromData(IUItem.machines_base2, 1, 9), "A A", "DBE", "ACA", Character.valueOf('A'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 138), Character.valueOf('C'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 20), Character.valueOf('D'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 47), Character.valueOf('E'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 133), Character.valueOf('B'), ItemStackHelper.fromData(IUItem.machines_base2, 1, 8)), 0);
        BlockEntityUpgradeMachineFactory.addRecipe(Recipes.recipe.addRecipe(ItemStackHelper.fromData(IUItem.machines_base2, 1, 10), "A A", "DBE", "ACA", Character.valueOf('A'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 139), Character.valueOf('C'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 96), Character.valueOf('D'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 49), Character.valueOf('E'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 134), Character.valueOf('B'), ItemStackHelper.fromData(IUItem.machines_base2, 1, 9)), 1);
        BlockEntityUpgradeMachineFactory.addRecipe(Recipes.recipe.addRecipe(ItemStackHelper.fromData(IUItem.machines_base2, 1, 11), "A A", "DBE", "ACA", Character.valueOf('A'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 140), Character.valueOf('C'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 120), Character.valueOf('D'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 51), Character.valueOf('E'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 136), Character.valueOf('B'), ItemStackHelper.fromData(IUItem.machines_base2, 1, 10)), 2);
        BlockEntityUpgradeMachineFactory.addRecipe(Recipes.recipe.addRecipe(ItemStackHelper.fromData(IUItem.machines_base3, 1, 17), "A A", "DBE", "ACA", Character.valueOf('A'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 138), Character.valueOf('C'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 20), Character.valueOf('D'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 47), Character.valueOf('E'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 224), Character.valueOf('B'), ItemStackHelper.fromData(IUItem.machines_base3, 1, 16)), 0);
        BlockEntityUpgradeMachineFactory.addRecipe(Recipes.recipe.addRecipe(ItemStackHelper.fromData(IUItem.machines_base3, 1, 18), "A A", "DBE", "ACA", Character.valueOf('A'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 139), Character.valueOf('C'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 96), Character.valueOf('D'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 49), Character.valueOf('E'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 220), Character.valueOf('B'), ItemStackHelper.fromData(IUItem.machines_base3, 1, 17)), 1);
        BlockEntityUpgradeMachineFactory.addRecipe(Recipes.recipe.addRecipe(ItemStackHelper.fromData(IUItem.machines_base3, 1, 19), "A A", "DBE", "ACA", Character.valueOf('A'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 140), Character.valueOf('C'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 120), Character.valueOf('D'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 51), Character.valueOf('E'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 222), Character.valueOf('B'), ItemStackHelper.fromData(IUItem.machines_base3, 1, 18)), 2);
        BlockEntityUpgradeMachineFactory.addRecipe(Recipes.recipe.addRecipe(ItemStackHelper.fromData(IUItem.machines_base3, 1, 1), "AGA", "DBE", "ACA", Character.valueOf('A'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 138), Character.valueOf('C'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 20), Character.valueOf('D'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 47), Character.valueOf('E'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 19), Character.valueOf('B'), ItemStackHelper.fromData(IUItem.machines_base3, 1, 0), Character.valueOf('G'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 18)), 0);
        BlockEntityUpgradeMachineFactory.addRecipe(Recipes.recipe.addRecipe(ItemStackHelper.fromData(IUItem.machines_base3, 1, 2), "AGA", "DBE", "ACA", Character.valueOf('A'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 139), Character.valueOf('C'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 96), Character.valueOf('D'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 49), Character.valueOf('E'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 95), Character.valueOf('B'), ItemStackHelper.fromData(IUItem.machines_base3, 1, 1), Character.valueOf('G'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 94)), 1);
        BlockEntityUpgradeMachineFactory.addRecipe(Recipes.recipe.addRecipe(ItemStackHelper.fromData(IUItem.machines_base3, 1, 3), "AGA", "DBE", "ACA", Character.valueOf('A'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 140), Character.valueOf('C'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 120), Character.valueOf('D'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 51), Character.valueOf('E'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 119), Character.valueOf('B'), ItemStackHelper.fromData(IUItem.machines_base3, 1, 2), Character.valueOf('G'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 118)), 2);
        BlockEntityUpgradeMachineFactory.addRecipe(Recipes.recipe.addRecipe(ItemStackHelper.fromData(IUItem.machines_base3, 1, 5), "AGA", "DBE", "ACA", Character.valueOf('A'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 138), Character.valueOf('C'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 20), Character.valueOf('D'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 47), Character.valueOf('E'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 9), Character.valueOf('B'), ItemStackHelper.fromData(IUItem.machines_base3, 1, 4), Character.valueOf('G'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 129)), 0);
        BlockEntityUpgradeMachineFactory.addRecipe(Recipes.recipe.addRecipe(ItemStackHelper.fromData(IUItem.machines_base3, 1, 6), "AGA", "DBE", "ACA", Character.valueOf('A'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 139), Character.valueOf('C'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 96), Character.valueOf('D'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 49), Character.valueOf('E'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 86), Character.valueOf('B'), ItemStackHelper.fromData(IUItem.machines_base3, 1, 5), Character.valueOf('G'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 130)), 1);
        BlockEntityUpgradeMachineFactory.addRecipe(Recipes.recipe.addRecipe(ItemStackHelper.fromData(IUItem.machines_base3, 1, 7), "AGA", "DBE", "ACA", Character.valueOf('A'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 140), Character.valueOf('C'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 120), Character.valueOf('D'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 51), Character.valueOf('E'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 110), Character.valueOf('B'), ItemStackHelper.fromData(IUItem.machines_base3, 1, 6), Character.valueOf('G'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 131)), 2);
        BlockEntityUpgradeMachineFactory.addRecipe(Recipes.recipe.addRecipe(ItemStackHelper.fromData(IUItem.machines_base3, 1, 13), "A A", "DBE", "ACA", Character.valueOf('A'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 138), Character.valueOf('C'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 20), Character.valueOf('D'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 47), Character.valueOf('E'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 15), Character.valueOf('B'), ItemStackHelper.fromData(IUItem.machines_base3, 1, 12)), 0);
        BlockEntityUpgradeMachineFactory.addRecipe(Recipes.recipe.addRecipe(ItemStackHelper.fromData(IUItem.machines_base3, 1, 14), "A A", "DBE", "ACA", Character.valueOf('A'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 139), Character.valueOf('C'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 96), Character.valueOf('D'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 49), Character.valueOf('E'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 91), Character.valueOf('B'), ItemStackHelper.fromData(IUItem.machines_base3, 1, 13)), 1);
        BlockEntityUpgradeMachineFactory.addRecipe(Recipes.recipe.addRecipe(ItemStackHelper.fromData(IUItem.machines_base3, 1, 15), "A A", "DBE", "ACA", Character.valueOf('A'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 140), Character.valueOf('C'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 120), Character.valueOf('D'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 51), Character.valueOf('E'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 115), Character.valueOf('B'), ItemStackHelper.fromData(IUItem.machines_base3, 1, 14)), 2);
        BlockEntityUpgradeMachineFactory.addRecipe(Recipes.recipe.addRecipe(ItemStackHelper.fromData(IUItem.machines_base3, 1, 9), "AGA", "DBE", "ACA", Character.valueOf('A'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 138), Character.valueOf('C'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 20), Character.valueOf('D'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 47), Character.valueOf('E'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 12), Character.valueOf('B'), ItemStackHelper.fromData(IUItem.machines_base3, 1, 8), Character.valueOf('G'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 6)), 0);
        BlockEntityUpgradeMachineFactory.addRecipe(Recipes.recipe.addRecipe(ItemStackHelper.fromData(IUItem.machines_base3, 1, 10), "AGA", "DBE", "ACA", Character.valueOf('A'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 139), Character.valueOf('C'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 96), Character.valueOf('D'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 49), Character.valueOf('E'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 87), Character.valueOf('B'), ItemStackHelper.fromData(IUItem.machines_base3, 1, 9), Character.valueOf('G'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 83)), 1);
        BlockEntityUpgradeMachineFactory.addRecipe(Recipes.recipe.addRecipe(ItemStackHelper.fromData(IUItem.machines_base3, 1, 11), "AGA", "DBE", "ACA", Character.valueOf('A'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 140), Character.valueOf('C'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 120), Character.valueOf('D'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 51), Character.valueOf('E'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 111), Character.valueOf('B'), ItemStackHelper.fromData(IUItem.machines_base3, 1, 10), Character.valueOf('G'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 107)), 2);
        BlockEntityUpgradeMachineFactory.addRecipe(Recipes.recipe.addRecipe(ItemStackHelper.fromData(IUItem.machines_base1, 1, 3), "A A", "DBE", "ACA", Character.valueOf('A'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 138), Character.valueOf('C'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 20), Character.valueOf('D'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 47), Character.valueOf('E'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 135), Character.valueOf('B'), ItemStackHelper.fromData(IUItem.machines_base1, 1, 2)), 0);
        BlockEntityUpgradeMachineFactory.addRecipe(Recipes.recipe.addRecipe(ItemStackHelper.fromData(IUItem.machines_base1, 1, 4), "A A", "DBE", "ACA", Character.valueOf('A'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 139), Character.valueOf('C'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 96), Character.valueOf('D'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 49), Character.valueOf('E'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 146), Character.valueOf('B'), ItemStackHelper.fromData(IUItem.machines_base1, 1, 3)), 1);
        BlockEntityUpgradeMachineFactory.addRecipe(Recipes.recipe.addRecipe(ItemStackHelper.fromData(IUItem.machines_base1, 1, 5), "A A", "DBE", "ACA", Character.valueOf('A'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 140), Character.valueOf('C'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 120), Character.valueOf('D'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 51), Character.valueOf('E'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 157), Character.valueOf('B'), ItemStackHelper.fromData(IUItem.machines_base1, 1, 4)), 2);
        BlockEntityUpgradeMachineFactory.addRecipe(Recipes.recipe.addRecipe(ItemStackHelper.fromData(IUItem.machines_base1, 1, 7), "A A", "DBE", "ACA", Character.valueOf('A'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 138), Character.valueOf('C'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 20), Character.valueOf('D'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 47), Character.valueOf('E'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 135), Character.valueOf('B'), ItemStackHelper.fromData(IUItem.machines_base1, 1, 6)), 0);
        BlockEntityUpgradeMachineFactory.addRecipe(Recipes.recipe.addRecipe(ItemStackHelper.fromData(IUItem.machines_base1, 1, 8), "A A", "DBE", "ACA", Character.valueOf('A'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 139), Character.valueOf('C'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 96), Character.valueOf('D'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 49), Character.valueOf('E'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 146), Character.valueOf('B'), ItemStackHelper.fromData(IUItem.machines_base1, 1, 7)), 1);
        BlockEntityUpgradeMachineFactory.addRecipe(Recipes.recipe.addRecipe(ItemStackHelper.fromData(IUItem.machines_base1, 1, 9), "A A", "DBE", "ACA", Character.valueOf('A'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 140), Character.valueOf('C'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 120), Character.valueOf('D'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 51), Character.valueOf('E'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 157), Character.valueOf('B'), ItemStackHelper.fromData(IUItem.machines_base1, 1, 8)), 2);
        BlockEntityUpgradeMachineFactory.addRecipe(Recipes.recipe.addRecipe(ItemStackHelper.fromData(IUItem.basemachine1, 1, 6), "F F", "CAE", "FBF", Character.valueOf('A'), BasicRecipeTwo.getBlockStack(BlockBaseMachine3Entity.pump_iu), Character.valueOf('B'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 20), Character.valueOf('C'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 6), Character.valueOf('E'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 248), Character.valueOf('F'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 138)), 0);
        BlockEntityUpgradeMachineFactory.addRecipe(Recipes.recipe.addRecipe(ItemStackHelper.fromData(IUItem.oiladvrefiner), " A ", " B ", " C ", Character.valueOf('A'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 9), Character.valueOf('B'), IUItem.oilrefiner, Character.valueOf('C'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 20)), 0);
        BlockEntityUpgradeMachineFactory.addRecipe(Recipes.recipe.addRecipe(ItemStackHelper.fromData(IUItem.machines, 1, 10), "BAB", " D ", "B B", Character.valueOf('D'), BasicRecipeTwo.getBlockStack(BlockBaseMachine3Entity.generator_iu), Character.valueOf('A'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 234), Character.valueOf('B'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 138)), 0);
        BlockEntityUpgradeMachineFactory.addRecipe(Recipes.recipe.addRecipe(ItemStackHelper.fromData(IUItem.machines, 1, 11), "BAB", " D ", "B B", Character.valueOf('D'), ItemStackHelper.fromData(IUItem.machines, 1, 10), Character.valueOf('A'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 232), Character.valueOf('B'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 139)), 1);
        BlockEntityUpgradeMachineFactory.addRecipe(Recipes.recipe.addRecipe(ItemStackHelper.fromData(IUItem.machines, 1, 12), "BAB", " D ", "B B", Character.valueOf('D'), ItemStackHelper.fromData(IUItem.machines, 1, 11), Character.valueOf('A'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 233), Character.valueOf('B'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 140)), 2);
        BlockEntityUpgradeMachineFactory.addRecipe(Recipes.recipe.addRecipe(ItemStackHelper.fromData(IUItem.basemachine, 1, 4), "B B", "ADC", "B B", Character.valueOf('D'), BasicRecipeTwo.getBlockStack(BlockBaseMachine3Entity.geogenerator_iu), Character.valueOf('A'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 234), Character.valueOf('C'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 5), Character.valueOf('B'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 138)), 0);
        BlockEntityUpgradeMachineFactory.addRecipe(Recipes.recipe.addRecipe(ItemStackHelper.fromData(IUItem.basemachine, 1, 5), "B B", "ADC", "B B", Character.valueOf('D'), ItemStackHelper.fromData(IUItem.basemachine, 1, 4), Character.valueOf('A'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 232), Character.valueOf('C'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 82), Character.valueOf('B'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 139)), 1);
        BlockEntityUpgradeMachineFactory.addRecipe(Recipes.recipe.addRecipe(ItemStackHelper.fromData(IUItem.basemachine, 1, 6), "B B", "ADC", "B B", Character.valueOf('D'), ItemStackHelper.fromData(IUItem.basemachine, 1, 5), Character.valueOf('A'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 233), Character.valueOf('C'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 106), Character.valueOf('B'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 140)), 2);
        BlockEntityUpgradeMachineFactory.addRecipe(Recipes.recipe.addRecipe(ItemStackHelper.fromData(IUItem.machines, 1, 13), "C C", " B ", "CAC", Character.valueOf('A'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 257), Character.valueOf('B'), ItemStackHelper.fromData(IUItem.machines, 1, 8), Character.valueOf('C'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 138)), 0);
        BlockEntityUpgradeMachineFactory.addRecipe(Recipes.recipe.addRecipe(ItemStackHelper.fromData(IUItem.machines, 1, 14), "C C", " B ", "CAC", Character.valueOf('A'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 253), Character.valueOf('B'), ItemStackHelper.fromData(IUItem.machines, 1, 13), Character.valueOf('C'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 139)), 1);
        BlockEntityUpgradeMachineFactory.addRecipe(Recipes.recipe.addRecipe(ItemStackHelper.fromData(IUItem.machines, 1, 15), "C C", " B ", "CAC", Character.valueOf('A'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 255), Character.valueOf('B'), ItemStackHelper.fromData(IUItem.machines, 1, 14), Character.valueOf('C'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 140)), 2);
        BlockEntityUpgradeMachineFactory.addRecipe(Recipes.recipe.addRecipe(ItemStackHelper.fromData(IUItem.basemachine1, 1, 7), "F F", "CAE", "FBF", Character.valueOf('A'), ItemStackHelper.fromData(IUItem.basemachine1, 1, 6), Character.valueOf('B'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 96), Character.valueOf('C'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 83), Character.valueOf('E'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 245), Character.valueOf('F'), ItemStackHelper.fromData(IUItem.crafting_elements, 1, 139)), 1);
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        if (!Keyboard.isKeyDown(340)) {
            tooltip.add(Localization.translate("press.lshift"));
        }
        if (Keyboard.isKeyDown(340)) {
            tooltip.add(Localization.translate("iu.machines_work_energy") + this.componentProcess.getEnergyConsume() + Localization.translate("iu.machines_work_energy_type_eu"));
            tooltip.add(Localization.translate("iu.machines_work_length") + this.componentProcess.getOperationsPerTick());
        }
        super.addInformation(stack, tooltip);
    }

    public ContainerMenuUpgradeMachineFactory getGuiContainer(Player var1) {
        return new ContainerMenuUpgradeMachineFactory(this, var1);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ScreenIndustrialUpgrade<ContainerMenuBase<? extends CustomWorldContainer>> getGui(Player var1, ContainerMenuBase<? extends CustomWorldContainer> menu) {
        return new ScreenUpgradeMachineFactory((ContainerMenuUpgradeMachineFactory)menu);
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2.getBlock(this.getTeBlock());
    }

    @Override
    public MultiBlockEntity getTeBlock() {
        return BlockBaseMachine3Entity.upgrade_machine;
    }

    @Override
    public void onUpdate() {
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.f_58857_.f_46443_) {
            this.inputSlotA.load();
            this.getOutput();
        }
    }

    @Override
    public MachineRecipe getRecipeOutput() {
        return this.output;
    }

    @Override
    public void setRecipeOutput(MachineRecipe output) {
        this.output = output;
    }

    public MachineRecipe getOutput() {
        this.output = this.inputSlotA.process();
        return this.output;
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.Processing, UpgradableProperty.Transformer, UpgradableProperty.EnergyStorage, UpgradableProperty.ItemExtract, UpgradableProperty.ItemInput);
    }
}

