/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.mechanism.energy;

import com.denfop.IUItem;
import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.container.CustomWorldContainer;
import com.denfop.api.energy.event.load.EventLoadController;
import com.denfop.api.energy.event.unload.EventUnloadController;
import com.denfop.api.energy.interfaces.EnergyConductor;
import com.denfop.api.energy.interfaces.EnergyController;
import com.denfop.api.energy.interfaces.EnergyTile;
import com.denfop.api.energy.networking.EnergyNetGlobal;
import com.denfop.api.otherenergies.common.InfoTile;
import com.denfop.blockentity.base.BlockEntityBase;
import com.denfop.blockentity.base.BlockEntityInventory;
import com.denfop.blockentity.base.FakePlayerSpawner;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine3Entity;
import com.denfop.componets.Energy;
import com.denfop.componets.energy.EnergyNetDelegate;
import com.denfop.containermenu.ContainerMenuBase;
import com.denfop.containermenu.ContainerMenuRemover;
import com.denfop.inventory.Inventory;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.screen.ScreenEnergyRemover;
import com.denfop.screen.ScreenIndustrialUpgrade;
import com.denfop.world.WorldBaseGen;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class BlockEntityEnergyRemover
extends BlockEntityInventory
implements IUpdatableTileEvent,
EnergyController {
    public final Inventory slot;
    public Set<EnergyConductor> conductorList = new HashSet<EnergyConductor>();
    FakePlayerSpawner fakePlayer;
    Map<Direction, EnergyTile> energyConductorMap = new HashMap<Direction, EnergyTile>();
    int hashCodeSource;
    List<InfoTile<EnergyTile>> validReceivers = new LinkedList<InfoTile<EnergyTile>>();
    private boolean work;
    private long id;

    public BlockEntityEnergyRemover(BlockPos pos, BlockState state) {
        super(BlockBaseMachine3Entity.energy_remover, pos, state);
        this.slot = new Inventory(this, Inventory.TypeItemSlot.OUTPUT, 16);
        this.addComponent(Energy.asBasicSink((BlockEntityInventory)this, 0.0, 14));
    }

    @Override
    public void RemoveTile(EnergyTile tile, Direction facing1) {
        if (!this.getWorld().f_46443_) {
            this.energyConductorMap.remove(facing1);
            Iterator<InfoTile<EnergyTile>> iter = this.validReceivers.iterator();
            while (iter.hasNext()) {
                InfoTile<EnergyTile> tileInfoTile = iter.next();
                if (tileInfoTile.tileEntity != tile) continue;
                iter.remove();
                break;
            }
        }
    }

    @Override
    public void AddTile(EnergyTile tile, Direction facing1) {
        if (!this.getWorld().f_46443_) {
            this.energyConductorMap.put(facing1, tile);
            this.validReceivers.add(new InfoTile<EnergyTile>(tile, facing1.m_122424_()));
        }
    }

    @Override
    public Map<Direction, EnergyTile> getTiles() {
        return this.energyConductorMap;
    }

    @Override
    public MultiBlockEntity getTeBlock() {
        return BlockBaseMachine3Entity.energy_remover;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2.getBlock(this.getTeBlock());
    }

    @Override
    public long getIdNetwork() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public int getHashCodeSource() {
        return this.hashCodeSource;
    }

    @Override
    public void setHashCodeSource(int hashCode) {
        this.hashCodeSource = hashCode;
    }

    @Override
    public List<InfoTile<EnergyTile>> getValidReceivers() {
        return this.validReceivers;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.getWorld().f_46443_) {
            this.energyConductorMap.clear();
            this.validReceivers.clear();
            MinecraftForge.EVENT_BUS.post((Event)new EventLoadController(this, this.f_58857_));
            this.fakePlayer = new FakePlayerSpawner(this.getWorld());
        }
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        return packet;
    }

    @Override
    public void onUnloaded() {
        if (!this.getWorld().f_46443_) {
            MinecraftForge.EVENT_BUS.post((Event)new EventUnloadController(this, this.f_58857_));
        }
        super.onUnloaded();
    }

    public ContainerMenuRemover getGuiContainer(Player entityPlayer) {
        return new ContainerMenuRemover(this, entityPlayer);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ScreenIndustrialUpgrade<ContainerMenuBase<? extends CustomWorldContainer>> getGui(Player var1, ContainerMenuBase<? extends CustomWorldContainer> menu) {
        return new ScreenEnergyRemover((ContainerMenuRemover)menu);
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbt) {
        nbt.m_128379_("work", this.work);
        return super.writeToNBT(nbt);
    }

    @Override
    public void readFromNBT(CompoundTag nbtTagCompound) {
        super.readFromNBT(nbtTagCompound);
        this.work = nbtTagCompound.m_128471_("work");
    }

    public void discover() {
        this.conductorList.clear();
        LinkedList<EnergyTile> tileEntitiesToCheck = new LinkedList<EnergyTile>();
        LinkedList<EnergyConductor> reachedTileEntities = new LinkedList<EnergyConductor>();
        EnergyNetDelegate tile = this.getComp(Energy.class).delegate;
        tileEntitiesToCheck.add(tile);
        long id = WorldBaseGen.random.nextLong();
        while (!tileEntitiesToCheck.isEmpty()) {
            EnergyTile currentTileEntity = (EnergyTile)tileEntitiesToCheck.pop();
            List<InfoTile<EnergyTile>> validReceivers = currentTileEntity.getValidReceivers();
            for (InfoTile<EnergyTile> validReceiver : validReceivers) {
                if (validReceiver.tileEntity == tile || ((EnergyTile)validReceiver.tileEntity).getIdNetwork() == id || !(validReceiver.tileEntity instanceof EnergyConductor)) continue;
                ((EnergyTile)validReceiver.tileEntity).setId(id);
                if (!(validReceiver.tileEntity instanceof EnergyConductor)) continue;
                tileEntitiesToCheck.push((EnergyTile)validReceiver.tileEntity);
                reachedTileEntities.add((EnergyConductor)validReceiver.tileEntity);
            }
        }
        this.conductorList.addAll(reachedTileEntities);
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.work) {
            for (EnergyConductor conductor : this.conductorList) {
                BlockEntityBase tile = (BlockEntityBase)EnergyNetGlobal.instance.getBlockPosFromEnergyTile(conductor, this.f_58857_);
                List<ItemStack> drops = tile.getBlock().getDrops(this.f_58857_, tile.getPos(), tile.m_58900_(), null);
                if (!this.slot.add(drops.get(0))) continue;
                tile.onUnloaded();
                this.getWorld().m_7471_(tile.getPos(), false);
            }
            this.work = false;
            this.discover();
        }
    }

    @Override
    public void updateTileServer(Player entityPlayer, double i) {
        if (this.f_58857_.f_46443_) {
            return;
        }
        if (i == 0.0) {
            this.discover();
        } else if (i == 1.0) {
            this.work = true;
        }
    }

    @Override
    public boolean getWork() {
        return this.work;
    }

    @Override
    public void work() {
        if (this.getWork()) {
            this.discover();
        }
    }

    @Override
    public void unload() {
        this.conductorList.clear();
    }
}

