/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.mechanism.steam;

import com.denfop.IUItem;
import com.denfop.api.Recipes;
import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.container.CustomWorldContainer;
import com.denfop.api.recipe.BaseMachineRecipe;
import com.denfop.api.recipe.IHasRecipe;
import com.denfop.api.recipe.IUpdateTick;
import com.denfop.api.recipe.Input;
import com.denfop.api.recipe.InventoryRecipes;
import com.denfop.api.recipe.MachineRecipe;
import com.denfop.api.recipe.RecipeOutput;
import com.denfop.blockentity.base.BlockEntityElectricMachine;
import com.denfop.blockentity.base.BlockEntityInventory;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.FluidName;
import com.denfop.blocks.mechanism.BlockBaseMachine3Entity;
import com.denfop.componets.ComponentSteamEnergy;
import com.denfop.componets.Fluids;
import com.denfop.componets.PressureComponent;
import com.denfop.containermenu.ContainerMenuBase;
import com.denfop.containermenu.ContainerMenuSteamSharpener;
import com.denfop.inventory.Inventory;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.recipe.IInputHandler;
import com.denfop.screen.ScreenIndustrialUpgrade;
import com.denfop.screen.ScreenSteamSharpener;
import com.denfop.sound.EnumSound;
import com.denfop.utils.Keyboard;
import com.denfop.utils.Localization;
import java.io.IOException;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockEntitySteamSharpener
extends BlockEntityElectricMachine
implements IUpdateTick,
IUpdatableTileEvent,
IHasRecipe {
    public final InventoryRecipes inputSlotA;
    public final PressureComponent pressure;
    public final ComponentSteamEnergy steam;
    public final double defaultEnergyConsume;
    public final int defaultOperationLength;
    public final int defaultTier;
    public final double defaultEnergyStorage;
    private final Fluids fluids;
    private final Fluids.InternalFluidTank fluidTank;
    public MachineRecipe output;
    public double energyConsume;
    public int operationLength;
    public int operationsPerTick;
    public double guiProgress;
    protected short progress;

    public BlockEntitySteamSharpener(BlockPos pos, BlockState state) {
        super(0.0, 1, 1, BlockBaseMachine3Entity.steam_sharpener, pos, state);
        Recipes.recipes.addInitRecipes(this);
        this.progress = 0;
        this.energyConsume = 1.0;
        this.defaultEnergyConsume = 1.0;
        this.operationLength = 200;
        this.defaultOperationLength = 200;
        this.defaultTier = 1;
        this.defaultEnergyStorage = 100.0;
        this.fluids = this.addComponent(new Fluids(this));
        this.inputSlotA = new InventoryRecipes((BlockEntityInventory)this, "sharpener", (IUpdateTick)this);
        this.pressure = this.addComponent(PressureComponent.asBasicSink(this, 1.0));
        this.fluidTank = this.fluids.addTank("fluidTank6", 4000, Inventory.TypeItemSlot.NONE, Fluids.fluidPredicate((Fluid)FluidName.fluidsteam.getInstance().get()));
        this.steam = this.addComponent(ComponentSteamEnergy.asBasicSink(this, 4000.0));
        this.steam.setFluidTank(this.fluidTank);
    }

    public static void addRecipe(ItemStack container, ItemStack output) {
        IInputHandler input = Recipes.inputFactory;
        Recipes.recipes.addRecipe("sharpener", new BaseMachineRecipe(new Input(input.getInput(container)), new RecipeOutput(null, output)));
    }

    @Override
    public SoundEvent getSound() {
        return EnumSound.steam.getSoundEvent();
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        if (!Keyboard.isKeyDown(340)) {
            tooltip.add(Localization.translate("press.lshift"));
        }
        if (Keyboard.isKeyDown(340)) {
            // empty if block
        }
        super.addInformation(stack, tooltip);
    }

    public ContainerMenuSteamSharpener getGuiContainer(Player var1) {
        return new ContainerMenuSteamSharpener(var1, this);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ScreenIndustrialUpgrade<ContainerMenuBase<? extends CustomWorldContainer>> getGui(Player var1, ContainerMenuBase<? extends CustomWorldContainer> menu) {
        return new ScreenSteamSharpener((ContainerMenuSteamSharpener)menu);
    }

    @Override
    public void init() {
        BlockEntitySteamSharpener.addRecipe(new ItemStack((ItemLike)IUItem.crafting_elements.getStack(502)), new ItemStack((ItemLike)IUItem.iuingot.getStack(23)));
        BlockEntitySteamSharpener.addRecipe(new ItemStack((ItemLike)IUItem.crafting_elements.getStack(503)), new ItemStack((ItemLike)IUItem.crafting_elements.getStack(504)));
        BlockEntitySteamSharpener.addRecipe(IUItem.sulfurDust, new ItemStack((ItemLike)IUItem.crafting_elements.getStack(476)));
        IInputHandler input = Recipes.inputFactory;
        Recipes.recipes.addRecipe("sharpener", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((ItemLike)IUItem.rawIngot.getStack(0)))), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.iuingot.getStack(0)))));
        Recipes.recipes.addRecipe("sharpener", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((ItemLike)IUItem.rawIngot.getStack(1)))), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.iuingot.getStack(1)))));
        Recipes.recipes.addRecipe("sharpener", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((ItemLike)IUItem.rawIngot.getStack(2)))), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.iuingot.getStack(2)))));
        Recipes.recipes.addRecipe("sharpener", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((ItemLike)IUItem.rawIngot.getStack(3)))), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.iuingot.getStack(3)))));
        Recipes.recipes.addRecipe("sharpener", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((ItemLike)IUItem.rawIngot.getStack(4)))), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.iuingot.getStack(6)))));
        Recipes.recipes.addRecipe("sharpener", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((ItemLike)IUItem.rawIngot.getStack(5)))), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.iuingot.getStack(7)))));
        Recipes.recipes.addRecipe("sharpener", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((ItemLike)IUItem.rawIngot.getStack(6)))), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.iuingot.getStack(8)))));
        Recipes.recipes.addRecipe("sharpener", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((ItemLike)IUItem.rawIngot.getStack(7)))), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.iuingot.getStack(9)))));
        Recipes.recipes.addRecipe("sharpener", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((ItemLike)IUItem.rawIngot.getStack(8)))), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.iuingot.getStack(10)))));
        Recipes.recipes.addRecipe("sharpener", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((ItemLike)IUItem.rawIngot.getStack(9)))), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.iuingot.getStack(11)))));
        Recipes.recipes.addRecipe("sharpener", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((ItemLike)IUItem.rawIngot.getStack(10)))), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.iuingot.getStack(12)))));
        Recipes.recipes.addRecipe("sharpener", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((ItemLike)IUItem.rawIngot.getStack(10)))), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.iuingot.getStack(12)))));
        Recipes.recipes.addRecipe("sharpener", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((ItemLike)IUItem.rawIngot.getStack(11)))), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.iuingot.getStack(14)))));
        Recipes.recipes.addRecipe("sharpener", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((ItemLike)IUItem.rawIngot.getStack(12)))), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.iuingot.getStack(15)))));
        Recipes.recipes.addRecipe("sharpener", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((ItemLike)IUItem.rawIngot.getStack(13)))), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.iuingot.getStack(16)))));
        Recipes.recipes.addRecipe("sharpener", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((ItemLike)IUItem.rawIngot.getStack(14)))), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.iuingot.getStack(17)))));
        Recipes.recipes.addRecipe("sharpener", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((ItemLike)IUItem.rawIngot.getStack(15)))), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.iuingot.getStack(18)))));
        Recipes.recipes.addRecipe("sharpener", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((ItemLike)IUItem.rawIngot.getStack(16)))), new RecipeOutput(null, new ItemStack((ItemLike)Items.f_151052_))));
        Recipes.recipes.addRecipe("sharpener", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((ItemLike)IUItem.rawIngot.getStack(17)))), new RecipeOutput(null, new ItemStack((ItemLike)Items.f_42417_, 1))));
        Recipes.recipes.addRecipe("sharpener", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((ItemLike)IUItem.rawIngot.getStack(18)))), new RecipeOutput(null, new ItemStack((ItemLike)Items.f_42416_, 1))));
        Recipes.recipes.addRecipe("sharpener", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((ItemLike)IUItem.rawIngot.getStack(19)))), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.iuingot.getStack(22)))));
        Recipes.recipes.addRecipe("sharpener", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((ItemLike)IUItem.rawIngot.getStack(20)))), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.iuingot.getStack(24)))));
        Recipes.recipes.addRecipe("sharpener", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((ItemLike)IUItem.rawIngot.getStack(22)))), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.iuingot.getStack(25)))));
        Recipes.recipes.addRecipe("sharpener", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((ItemLike)IUItem.rawIngot.getStack(23)))), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.iuingot.getStack(26)))));
        Recipes.recipes.addRecipe("sharpener", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((ItemLike)IUItem.rawIngot.getStack(24)))), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.iuingot.getStack(27)))));
        for (int i = 25; i < 40; ++i) {
            Recipes.recipes.addRecipe("sharpener", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((ItemLike)IUItem.rawIngot.getStack(i)))), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.iuingot.getStack(i + 3)))));
        }
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2.getBlock(this.getTeBlock());
    }

    @Override
    public MultiBlockEntity getTeBlock() {
        return BlockBaseMachine3Entity.steam_sharpener;
    }

    @Override
    public void onUpdate() {
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.f_58857_.f_46443_) {
            this.inputSlotA.load();
            this.getOutput();
        }
    }

    @Override
    public void readFromNBT(CompoundTag nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.progress = nbttagcompound.m_128448_("progress");
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.m_128376_("progress", this.progress);
        return nbttagcompound;
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.guiProgress = (Double)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.guiProgress);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public MachineRecipe getRecipeOutput() {
        return this.output;
    }

    @Override
    public void setRecipeOutput(MachineRecipe output) {
        this.output = output;
    }

    public MachineRecipe getOutput() {
        this.output = this.inputSlotA.process();
        return this.output;
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.output != null && !this.inputSlotA.m_7983_() && this.outputSlot.canAdd(this.output.getRecipe().getOutput().items) && this.inputSlotA.continue_process(this.output) && this.steam.canUseEnergy(this.energyConsume) && this.pressure.getEnergy() == 1.0) {
            if (!this.getActive()) {
                this.setActive(true);
            }
            if (this.progress == 0) {
                this.initiate(0);
            }
            this.progress = (short)(this.progress + 1);
            this.steam.useEnergy(this.energyConsume);
            double k = this.progress;
            this.guiProgress = k / (double)this.operationLength;
            if (this.progress >= this.operationLength) {
                this.guiProgress = 0.0;
                this.operate();
                this.progress = 0;
                this.initiate(2);
            }
        } else {
            if (this.progress != 0 && this.getActive()) {
                this.initiate(0);
            }
            if (this.output == null) {
                this.progress = 0;
                this.guiProgress = 0.0;
            }
            if (this.getActive()) {
                this.setActive(false);
            }
        }
    }

    public void operate() {
        for (int i = 0; i < 1; ++i) {
            this.operateOnce();
            this.getOutput();
            if (this.output == null) break;
        }
    }

    public void operateOnce() {
        this.inputSlotA.consume();
        this.outputSlot.addAll(this.output.getRecipe().getOutput().items);
    }

    public double getProgress() {
        return this.guiProgress;
    }
}

