/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.mechanism.steamboiler;

import com.denfop.IUItem;
import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.blockentity.mechanism.multiblocks.base.BlockEntityMultiBlockElement;
import com.denfop.blockentity.mechanism.steamboiler.IHeater;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockSteamBoilerEntity;
import com.denfop.componets.HeatComponent;
import com.denfop.utils.Localization;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;

public class BlockEntitySteamHeaterBoiler
extends BlockEntityMultiBlockElement
implements IHeater {
    private final HeatComponent heat = this.addComponent(HeatComponent.asBasicSink(this, 1000.0));

    public BlockEntitySteamHeaterBoiler(BlockPos pos, BlockState state) {
        super(BlockSteamBoilerEntity.steam_boiler_heater, pos, state);
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.getWorld().m_46467_() % 40L == 0L && this.heat.getEnergy() > 0.0) {
            this.heat.useEnergy(1.0);
        }
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        super.addInformation(stack, tooltip);
        tooltip.add(Localization.translate("iu.heatmachine.info"));
    }

    @Override
    public boolean isWork() {
        return this.heat.getEnergy() > 500.0;
    }

    @Override
    public MultiBlockEntity getTeBlock() {
        return BlockSteamBoilerEntity.steam_boiler_heater;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.steam_boiler.getBlock(this.getTeBlock());
    }
}

