/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.mechanism.steamturbine;

import com.denfop.IUItem;
import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.container.CustomWorldContainer;
import com.denfop.api.steam.ISteamBlade;
import com.denfop.blockentity.mechanism.multiblocks.base.BlockEntityMultiBlockElement;
import com.denfop.blockentity.mechanism.steamturbine.IRod;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockSteamTurbineEntity;
import com.denfop.containermenu.ContainerMenuBase;
import com.denfop.containermenu.ContainerMenuSteamTurbineRod;
import com.denfop.inventory.Inventory;
import com.denfop.items.reactors.ItemDamage;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.screen.ScreenIndustrialUpgrade;
import com.denfop.screen.ScreenSteamTurbineRod;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockEntitySteamTurbineRod
extends BlockEntityMultiBlockElement
implements IRod {
    private final Inventory slot;
    List<ISteamBlade> list = new ArrayList<ISteamBlade>();

    public BlockEntitySteamTurbineRod(BlockPos pos, BlockState state) {
        super(BlockSteamTurbineEntity.steam_turbine_rod, pos, state);
        this.slot = new Inventory(this, Inventory.TypeItemSlot.INPUT, 4){

            @Override
            public boolean m_7013_(int index, ItemStack stack) {
                return stack.m_41720_() instanceof ISteamBlade && ((ISteamBlade)stack.m_41720_()).getLevel() <= BlockEntitySteamTurbineRod.this.getMain().getBlockLevel();
            }

            @Override
            public ItemStack set(int index, ItemStack content) {
                super.set(index, content);
                this.update();
                return content;
            }

            @Override
            public void update() {
                super.update();
                BlockEntitySteamTurbineRod.this.list.clear();
                for (int i = 0; i < this.size(); ++i) {
                    ItemStack stack = this.get(i);
                    if (stack.m_41619_()) continue;
                    ItemDamage damage = (ItemDamage)stack.m_41720_();
                    if (damage.getMaxCustomDamage(stack) - damage.getCustomDamage(stack) == 0) {
                        this.set(i, ItemStack.f_41583_);
                        continue;
                    }
                    BlockEntitySteamTurbineRod.this.list.add((ISteamBlade)stack.m_41720_());
                }
            }
        };
    }

    @Override
    public boolean needUpdate() {
        return true;
    }

    @Override
    public void readUpdatePacket(CustomPacketBuffer packetBuffer) {
        super.readUpdatePacket(packetBuffer);
    }

    @Override
    public CustomPacketBuffer writeUpdatePacket() {
        CustomPacketBuffer customPacketBuffer = super.writeUpdatePacket();
        return customPacketBuffer;
    }

    @Override
    public MultiBlockEntity getTeBlock() {
        return BlockSteamTurbineEntity.steam_turbine_rod;
    }

    public ContainerMenuSteamTurbineRod getGuiContainer(Player entityPlayer) {
        return new ContainerMenuSteamTurbineRod(this, entityPlayer);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ScreenIndustrialUpgrade<ContainerMenuBase<? extends CustomWorldContainer>> getGui(Player var1, ContainerMenuBase<? extends CustomWorldContainer> menu) {
        return new ScreenSteamTurbineRod((ContainerMenuSteamTurbineRod)menu);
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.steam_turbine.getBlock(this.getTeBlock());
    }

    @Override
    public Inventory getSlot() {
        return this.slot;
    }

    @Override
    public int getBlockLevel() {
        return -1;
    }

    @Override
    public boolean hasOwnInventory() {
        return this.getMain() != null;
    }

    @Override
    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer customPacketBuffer = super.writePacket();
        try {
            EncoderHandler.encode(customPacketBuffer, this.slot.writeToNbt(new CompoundTag()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return customPacketBuffer;
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer) {
        super.readPacket(customPacketBuffer);
        try {
            CompoundTag tagCompound = (CompoundTag)DecoderHandler.decode(customPacketBuffer);
            this.slot.readFromNbt(tagCompound);
            this.slot.update();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        this.slot.update();
    }

    @Override
    public List<ISteamBlade> getRods() {
        return this.list;
    }

    @Override
    public void updateBlades() {
        this.slot.update();
    }
}

