/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.mechanism.steamturbine.exchanger;

import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.container.CustomWorldContainer;
import com.denfop.api.widget.EnumTypeSlot;
import com.denfop.blockentity.mechanism.multiblocks.base.BlockEntityMultiBlockElement;
import com.denfop.blockentity.mechanism.steamturbine.IController;
import com.denfop.blockentity.mechanism.steamturbine.IExchanger;
import com.denfop.blockentity.reactors.graphite.IExchangerItem;
import com.denfop.containermenu.ContainerMenuBase;
import com.denfop.containermenu.ContainerMenuBaseSteamTurbineExchanger;
import com.denfop.inventory.Inventory;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.screen.ScreenBaseSteamTurbineExchanger;
import com.denfop.screen.ScreenIndustrialUpgrade;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockEntityBaseSteamTurbineExchanger
extends BlockEntityMultiBlockElement
implements IExchanger {
    private final int levelBlock;
    private final Inventory slot;
    public double percent = 1.0;
    private IExchangerItem item;

    public BlockEntityBaseSteamTurbineExchanger(int levelBlock, MultiBlockEntity block, BlockPos pos, BlockState state) {
        super(block, pos, state);
        this.levelBlock = levelBlock;
        this.slot = new Inventory(this, Inventory.TypeItemSlot.INPUT, 1){

            @Override
            public EnumTypeSlot getTypeSlot() {
                return EnumTypeSlot.EXCHANGE;
            }

            @Override
            public boolean m_7013_(int index, ItemStack stack) {
                return stack.m_41720_() instanceof IExchangerItem && ((IExchangerItem)stack.m_41720_()).getLevelExchanger() <= ((IController)BlockEntityBaseSteamTurbineExchanger.this.getMain()).getBlockLevel();
            }

            @Override
            public ItemStack set(int index, ItemStack content) {
                super.set(index, content);
                if (!((BlockEntityBaseSteamTurbineExchanger)BlockEntityBaseSteamTurbineExchanger.this).f_58857_.f_46443_) {
                    if (content.m_41619_()) {
                        ((BlockEntityBaseSteamTurbineExchanger)this.base).percent = 0.0;
                    } else {
                        ((BlockEntityBaseSteamTurbineExchanger)this.base).percent = ((IExchangerItem)content.m_41720_()).getPercent();
                        BlockEntityBaseSteamTurbineExchanger.this.item = (IExchangerItem)content.m_41720_();
                    }
                }
                return content;
            }
        };
        this.slot.setStackSizeLimit(1);
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.getWorld().f_46443_) {
            if (this.getSlot().get(0).m_41619_()) {
                this.percent = 0.0;
                this.item = null;
            } else {
                this.percent = ((IExchangerItem)this.getSlot().get(0).m_41720_()).getPercent();
                this.item = (IExchangerItem)this.getSlot().get(0).m_41720_();
            }
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer customPacketBuffer = super.writeContainerPacket();
        customPacketBuffer.writeDouble(this.percent);
        return customPacketBuffer;
    }

    public ContainerMenuBaseSteamTurbineExchanger getGuiContainer(Player var1) {
        return new ContainerMenuBaseSteamTurbineExchanger(this, var1);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ScreenIndustrialUpgrade<ContainerMenuBase<? extends CustomWorldContainer>> getGui(Player var1, ContainerMenuBase<? extends CustomWorldContainer> menu) {
        return new ScreenBaseSteamTurbineExchanger((ContainerMenuBaseSteamTurbineExchanger)menu);
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        this.percent = customPacketBuffer.readDouble();
    }

    @Override
    public boolean hasOwnInventory() {
        return this.getMain() != null;
    }

    @Override
    public int getBlockLevel() {
        return -1;
    }

    @Override
    public Inventory getSlot() {
        return this.slot;
    }

    @Override
    public double getPower() {
        if (this.getMain() == null || this.getSlot().m_7983_()) {
            return 1.0;
        }
        return this.percent * 2.0;
    }

    @Override
    public IExchangerItem getExchanger() {
        return this.item;
    }
}

