/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.reactors.graphite.capacitor;

import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.container.CustomWorldContainer;
import com.denfop.api.reactors.IGraphiteReactor;
import com.denfop.api.widget.EnumTypeSlot;
import com.denfop.blockentity.mechanism.multiblocks.base.BlockEntityMultiBlockElement;
import com.denfop.blockentity.reactors.graphite.ICapacitor;
import com.denfop.blockentity.reactors.graphite.ICapacitorItem;
import com.denfop.blockentity.reactors.graphite.controller.BlockEntityMainController;
import com.denfop.containermenu.ContainerMenuBase;
import com.denfop.containermenu.ContainerMenuCapacitor;
import com.denfop.inventory.Inventory;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.screen.ScreenCapacitor;
import com.denfop.screen.ScreenIndustrialUpgrade;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockEntityCapacitor
extends BlockEntityMultiBlockElement
implements ICapacitor,
IUpdatableTileEvent {
    private final int levelBlock;
    private final Inventory slot;
    public double percent = 1.0;
    private int x = 0;
    private ICapacitorItem item;

    public BlockEntityCapacitor(int levelBlock, MultiBlockEntity block, BlockPos pos, BlockState state) {
        super(block, pos, state);
        this.levelBlock = levelBlock;
        this.slot = new Inventory(this, Inventory.TypeItemSlot.INPUT, 1){

            @Override
            public EnumTypeSlot getTypeSlot() {
                return EnumTypeSlot.CAPACITOR;
            }

            @Override
            public boolean m_7013_(int index, ItemStack stack) {
                return stack.m_41720_() instanceof ICapacitorItem && ((ICapacitorItem)stack.m_41720_()).getLevelCapacitor() <= ((BlockEntityCapacitor)this.base).getBlockLevel();
            }

            @Override
            public ItemStack set(int index, ItemStack content) {
                super.set(index, content);
                if (!((BlockEntityCapacitor)BlockEntityCapacitor.this).f_58857_.f_46443_) {
                    if (content.m_41619_()) {
                        ((BlockEntityCapacitor)this.base).percent = 1.0;
                    } else {
                        ((BlockEntityCapacitor)this.base).percent = 1.0 - ((ICapacitorItem)content.m_41720_()).getPercent();
                        BlockEntityCapacitor.this.item = (ICapacitorItem)content.m_41720_();
                    }
                }
                return content;
            }
        };
        this.slot.setStackSizeLimit(1);
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer customPacketBuffer = super.writeContainerPacket();
        customPacketBuffer.writeInt(this.x);
        customPacketBuffer.writeDouble(this.percent);
        return customPacketBuffer;
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        this.x = customPacketBuffer.readInt();
        this.percent = customPacketBuffer.readDouble();
    }

    @Override
    public boolean hasOwnInventory() {
        return true;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.getWorld().f_46443_) {
            this.percent = this.getSlot().get(0).m_41619_() ? 1.0 : 1.0 - ((ICapacitorItem)this.getSlot().get(0).m_41720_()).getPercent();
        }
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.getMain() != null) {
            BlockEntityMainController controller = (BlockEntityMainController)this.getMain();
            if (controller.work && !this.slot.m_7983_() && this.f_58857_.m_46467_() % 20L == 0L) {
                if (this.item == null) {
                    this.item = (ICapacitorItem)this.slot.get(0).m_41720_();
                }
                this.item.damageItem(this.slot.get(0), 1);
            }
        }
    }

    @Override
    public void readFromNBT(CompoundTag nbtTagCompound) {
        super.readFromNBT(nbtTagCompound);
        this.x = nbtTagCompound.m_128451_("capacitor_x");
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbt) {
        CompoundTag nbtTagCompound = super.writeToNBT(nbt);
        nbtTagCompound.m_128405_("capacitor_x", this.x);
        return nbtTagCompound;
    }

    @Override
    public int getBlockLevel() {
        return this.levelBlock;
    }

    public Inventory getSlot() {
        return this.slot;
    }

    @Override
    public double getPercent(int x) {
        if (this.getMain() == null || x != this.x || this.getSlot().m_7983_()) {
            return 1.0;
        }
        return this.percent;
    }

    public ContainerMenuCapacitor getGuiContainer(Player var1) {
        return new ContainerMenuCapacitor(this, var1);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ScreenIndustrialUpgrade<ContainerMenuBase<? extends CustomWorldContainer>> getGui(Player var1, ContainerMenuBase<? extends CustomWorldContainer> menu) {
        return new ScreenCapacitor((ContainerMenuCapacitor)menu);
    }

    public int getX() {
        return this.x;
    }

    @Override
    public void updateTileServer(Player var1, double var2) {
        if (this.getMain() == null) {
            return;
        }
        IGraphiteReactor reactor = (IGraphiteReactor)this.getMain();
        if (var2 == 0.0) {
            this.x = Math.min(this.x + 1, reactor.getWidth() - 1);
            reactor.updateDataReactor();
        } else {
            this.x = Math.max(0, this.x - 1);
            reactor.updateDataReactor();
        }
    }
}

