/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.reactors.water.inputfluid;

import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.blockentity.mechanism.multiblocks.base.BlockEntityMultiBlockElement;
import com.denfop.blockentity.reactors.water.IInput;
import com.denfop.blockentity.reactors.water.inputfluid.FluidHandlerReactor;
import com.denfop.componets.Fluids;
import com.denfop.utils.FluidHandlerFix;
import com.denfop.utils.ModUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockEntityInputFluid
extends BlockEntityMultiBlockElement
implements IInput {
    public List<Fluids> internalFluidTankList = new ArrayList<Fluids>();

    public BlockEntityInputFluid(MultiBlockEntity block, BlockPos pos, BlockState state) {
        super(block, pos, state);
    }

    @Override
    public boolean onActivated(Player player, InteractionHand hand, Direction side, Vec3 vec3) {
        if (!this.getWorld().f_46443_ && FluidHandlerFix.getFluidHandler(player.m_21120_(hand)) != null) {
            for (Fluids fluids : this.internalFluidTankList) {
                if (!ModUtils.interactWithFluidHandler(player, hand, (IFluidHandler)fluids.getCapability(ForgeCapabilities.FLUID_HANDLER, side))) continue;
                return true;
            }
            return false;
        }
        return super.onActivated(player, hand, side, vec3);
    }

    @Override
    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction facing) {
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return LazyOptional.of(() -> new FluidHandlerReactor(this.internalFluidTankList)).cast();
        }
        return super.getCapability(cap, facing);
    }

    @Override
    public void addFluids(Fluids fluids) {
        this.internalFluidTankList.add(fluids);
    }

    @Override
    public void clearList() {
        this.internalFluidTankList.clear();
    }
}

