/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.transport.tiles;

import com.denfop.IUItem;
import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.energy.InfoCable;
import com.denfop.api.energy.event.load.EnergyTileLoadEvent;
import com.denfop.api.energy.event.unload.EnergyTileUnLoadEvent;
import com.denfop.api.energy.interfaces.EnergyAcceptor;
import com.denfop.api.energy.interfaces.EnergyConductor;
import com.denfop.api.energy.interfaces.EnergyEmitter;
import com.denfop.api.energy.interfaces.EnergyTile;
import com.denfop.api.energy.networking.ConductorInfo;
import com.denfop.api.otherenergies.common.EnergyEvent;
import com.denfop.api.otherenergies.common.EnergyType;
import com.denfop.api.otherenergies.common.EnumTypeEvent;
import com.denfop.api.otherenergies.common.IAcceptor;
import com.denfop.api.otherenergies.common.IConductor;
import com.denfop.api.otherenergies.common.IEmitter;
import com.denfop.api.otherenergies.common.ITile;
import com.denfop.api.otherenergies.common.InfoTile;
import com.denfop.api.otherenergies.cool.ICoolAcceptor;
import com.denfop.api.otherenergies.cool.ICoolConductor;
import com.denfop.api.otherenergies.cool.ICoolEmitter;
import com.denfop.api.otherenergies.cool.ICoolTile;
import com.denfop.api.otherenergies.cool.event.CoolTileLoadEvent;
import com.denfop.api.otherenergies.cool.event.CoolTileUnloadEvent;
import com.denfop.api.otherenergies.heat.IHeatAcceptor;
import com.denfop.api.otherenergies.heat.IHeatConductor;
import com.denfop.api.otherenergies.heat.IHeatEmitter;
import com.denfop.api.otherenergies.heat.IHeatTile;
import com.denfop.api.otherenergies.heat.event.HeatTileLoadEvent;
import com.denfop.api.otherenergies.heat.event.HeatTileUnloadEvent;
import com.denfop.blockentity.transport.tiles.BlockEntityMultiCable;
import com.denfop.blockentity.transport.tiles.EnumTypeOperation;
import com.denfop.blockentity.transport.types.ICableItem;
import com.denfop.blockentity.transport.types.UniversalType;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.utils.Localization;
import com.denfop.utils.ModUtils;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class BlockEntityUniversalCable
extends BlockEntityMultiCable
implements EnergyConductor,
IHeatConductor,
ICoolConductor,
IConductor {
    private final ConductorInfo conductor;
    private final ConductorInfo conductorHeat;
    private final ConductorInfo conductorCool;
    public boolean addedToEnergyNet;
    protected UniversalType cableType;
    EnumTypeOperation enumTypeOperation = null;
    Map<Direction, EnergyTile> energyConductorMap = new HashMap<Direction, EnergyTile>();
    Map<Direction, IHeatTile> energyHeatConductorMap = new HashMap<Direction, IHeatTile>();
    boolean updateConnect = false;
    List<InfoTile<IHeatTile>> validHeatReceivers = new LinkedList<InfoTile<IHeatTile>>();
    List<InfoTile<EnergyTile>> validReceivers = new LinkedList<InfoTile<EnergyTile>>();
    Map<EnergyType, Map<Direction, ITile>> energyTypeConductorMap = new HashMap<EnergyType, Map<Direction, ITile>>();
    Map<EnergyType, List<InfoTile<ITile>>> validTypeReceivers = new HashMap<EnergyType, List<InfoTile<ITile>>>();
    int hashCodeSource;
    Map<Direction, ICoolTile> energyCoolConductorMap = new HashMap<Direction, ICoolTile>();
    List<InfoTile<ICoolTile>> validColdReceivers = new LinkedList<InfoTile<ICoolTile>>();
    List<EnergyType> energies = Arrays.asList(EnergyType.QUANTUM, EnergyType.SOLARIUM, EnergyType.EXPERIENCE, EnergyType.RADIATION);
    Map<EnergyType, ConductorInfo> conductorInfoMap = new HashMap<EnergyType, ConductorInfo>();
    private boolean needUpdate;
    private ChunkPos chunkPos;
    private boolean heat;
    private boolean quantum;
    private boolean experience;
    private boolean solarium;
    private boolean radiation;
    private boolean cold;
    private InfoCable cable;
    private com.denfop.api.otherenergies.heat.InfoCable typeHeatCable;
    private long id;
    private com.denfop.api.otherenergies.common.InfoCable typeCable;
    private com.denfop.api.otherenergies.cool.InfoCable typeColdCable;

    public BlockEntityUniversalCable(UniversalType cableType, MultiBlockEntity block, BlockPos pos, BlockState state) {
        super(cableType, block, pos, state);
        this.cableType = cableType;
        this.conductor = new ConductorInfo(pos, this);
        this.conductorCool = new ConductorInfo(pos, this);
        this.conductorHeat = new ConductorInfo(pos, this);
    }

    @Override
    public ConductorInfo getHeatConductor() {
        return this.conductorHeat;
    }

    @Override
    public ConductorInfo getCoolConductor() {
        return this.conductorCool;
    }

    @Override
    public ConductorInfo getInfo(EnergyType energyType) {
        if (this.conductorInfoMap.isEmpty()) {
            if (this.getEnergies() == null || this.getEnergies().isEmpty()) {
                this.conductorInfoMap.put(this.getEnergyType(), new ConductorInfo(this.pos, this, this.getEnergyType()));
            } else {
                for (EnergyType e : this.getEnergies()) {
                    this.conductorInfoMap.put(e, new ConductorInfo(this.pos, this, e));
                }
            }
        }
        return this.conductorInfoMap.get((Object)energyType);
    }

    @Override
    public void addInformation(ItemStack stack, List<String> info) {
        UniversalType type = this.cableType;
        double capacity = type.capacity;
        double loss = type.loss;
        info.add(Localization.translate("iu.universal_cable.info"));
        info.add(ModUtils.getString(capacity) + " " + Localization.translate("iu.generic.text.EUt"));
        info.add(Localization.translate("cable.tooltip.loss", lossFormat.format(loss)));
        info.add(Localization.translate("iu.transport.cold") + "-" + ModUtils.getString(64.0f) + " \u00b0C");
        info.add(Localization.translate("iu.transport.heat") + ModUtils.getString(16000.0f) + " \u00b0C");
    }

    @Override
    public ConductorInfo getInfo() {
        return this.conductor;
    }

    @Override
    public boolean onActivated(Player player, InteractionHand hand, Direction side, Vec3 vec3) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41720_() == IUItem.qcable.getItem(0) && !this.quantum) {
            stack.m_41774_(1);
            this.enumTypeOperation = EnumTypeOperation.QUANTUM;
            return true;
        }
        if (stack.m_41720_() == IUItem.scable.getItem(0) && !this.solarium) {
            stack.m_41774_(1);
            this.enumTypeOperation = EnumTypeOperation.SOLARIUM;
            return true;
        }
        if (stack.m_41720_() == IUItem.radcable_item.getItem(0) && !this.radiation) {
            stack.m_41774_(1);
            this.enumTypeOperation = EnumTypeOperation.RADIATION;
            return true;
        }
        if (stack.m_41720_() == IUItem.expcable.getItem(0) && !this.experience) {
            stack.m_41774_(1);
            this.enumTypeOperation = EnumTypeOperation.EXPERIENCE;
            return true;
        }
        if (stack.m_41720_() == IUItem.coolpipes.getItem(4) && !this.cold) {
            stack.m_41774_(1);
            this.enumTypeOperation = EnumTypeOperation.COLD;
            return true;
        }
        if (stack.m_41720_() == IUItem.pipes.getItem(4) && !this.heat) {
            stack.m_41774_(1);
            this.enumTypeOperation = EnumTypeOperation.HEAT;
            return true;
        }
        return super.onActivated(player, hand, side, vec3);
    }

    @Override
    public ICableItem getCableItem() {
        return this.cableType;
    }

    @Override
    public InfoCable getCable() {
        return this.cable;
    }

    @Override
    public void setCable(InfoCable cable) {
        this.cable = cable;
    }

    public BlockPos m_58899_() {
        return this.pos;
    }

    @Override
    public List<ItemStack> getSelfDrops(int fortune, boolean wrench) {
        LinkedList<ItemStack> stacks = new LinkedList<ItemStack>(super.getSelfDrops(fortune, wrench));
        if (this.quantum) {
            stacks.add(new ItemStack(IUItem.qcable.getItem(0)));
        }
        if (this.solarium) {
            stacks.add(new ItemStack(IUItem.scable.getItem()));
        }
        if (this.radiation) {
            stacks.add(new ItemStack(IUItem.radcable_item.getItem()));
        }
        if (this.experience) {
            stacks.add(new ItemStack(IUItem.expcable.getItem()));
        }
        if (this.heat) {
            stacks.add(new ItemStack(IUItem.pipes.getItem(4), 1));
        }
        if (this.cold) {
            stacks.add(new ItemStack(IUItem.coolpipes.getItem(4), 1));
        }
        return stacks;
    }

    @Override
    public void readFromNBT(CompoundTag nbt) {
        super.readFromNBT(nbt);
        this.cableType = UniversalType.values[nbt.m_128445_("cableType") & 0xFF];
        this.heat = nbt.m_128471_("Heat");
        this.quantum = nbt.m_128471_("Quantum");
        this.experience = nbt.m_128471_("Experience");
        this.solarium = nbt.m_128471_("Solarium");
        this.radiation = nbt.m_128471_("Radiation");
        this.cold = nbt.m_128471_("Cold");
    }

    @Override
    public void RemoveTile(EnergyTile tile, Direction facing1) {
        if (!this.getWorld().f_46443_) {
            this.energyConductorMap.remove(facing1);
            Iterator<InfoTile<EnergyTile>> iter = this.validReceivers.iterator();
            while (iter.hasNext()) {
                InfoTile<EnergyTile> tileInfoTile = iter.next();
                if (tileInfoTile.tileEntity != tile) continue;
                iter.remove();
                break;
            }
            this.updateConnect = true;
        }
    }

    @Override
    public void AddTile(EnergyTile tile, Direction facing1) {
        if (!this.getWorld().f_46443_) {
            if (!this.energyConductorMap.containsKey(facing1)) {
                this.energyConductorMap.put(facing1, tile);
                this.validReceivers.add(new InfoTile<EnergyTile>(tile, facing1.m_122424_()));
            }
            this.updateConnect = true;
        }
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbt) {
        super.writeToNBT(nbt);
        nbt.m_128344_("cableType", (byte)this.cableType.ordinal());
        nbt.m_128379_("Heat", this.heat);
        nbt.m_128379_("Quantum", this.quantum);
        nbt.m_128379_("Experience", this.experience);
        nbt.m_128379_("Solarium", this.solarium);
        nbt.m_128379_("Radiation", this.radiation);
        nbt.m_128379_("Cold", this.cold);
        return nbt;
    }

    @Override
    public void updateTileServer(Player var1, double var2) {
        super.updateTileServer(var1, var2);
        MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnLoadEvent(this.getWorld(), this));
        if (this.heat) {
            MinecraftForge.EVENT_BUS.post((Event)new HeatTileUnloadEvent(this, this.getWorld()));
        }
        if (this.cold) {
            MinecraftForge.EVENT_BUS.post((Event)new CoolTileUnloadEvent(this, this.getWorld()));
        }
        if (this.quantum) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyEvent(this.getWorld(), EnumTypeEvent.UNLOAD, EnergyType.QUANTUM, this));
        }
        if (this.experience) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyEvent(this.getWorld(), EnumTypeEvent.UNLOAD, EnergyType.EXPERIENCE, this));
        }
        if (this.solarium) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyEvent(this.getWorld(), EnumTypeEvent.UNLOAD, EnergyType.SOLARIUM, this));
        }
        if (this.radiation) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyEvent(this.getWorld(), EnumTypeEvent.UNLOAD, EnergyType.RADIATION, this));
        }
        this.needUpdate = true;
    }

    @Override
    public void AddHeatTile(IHeatTile tile, Direction dir) {
        if (!this.getWorld().f_46443_) {
            if (!this.energyHeatConductorMap.containsKey(dir)) {
                this.energyHeatConductorMap.put(dir, tile);
                this.validHeatReceivers.add(new InfoTile<IHeatTile>(tile, dir.m_122424_()));
            }
            this.updateConnect = true;
        }
    }

    @Override
    public com.denfop.api.otherenergies.heat.InfoCable getHeatCable() {
        return this.typeHeatCable;
    }

    @Override
    public void setHeatCable(com.denfop.api.otherenergies.heat.InfoCable cable) {
        this.typeHeatCable = cable;
    }

    @Override
    public void RemoveHeatTile(IHeatTile tile, Direction dir) {
        if (!this.getWorld().f_46443_) {
            this.energyHeatConductorMap.remove(dir);
            Iterator<InfoTile<IHeatTile>> iter = this.validHeatReceivers.iterator();
            while (iter.hasNext()) {
                InfoTile<IHeatTile> tileInfoTile = iter.next();
                if (tileInfoTile.tileEntity != tile) continue;
                iter.remove();
                break;
            }
            this.updateConnect = true;
        }
    }

    @Override
    public Map<Direction, IHeatTile> getHeatTiles() {
        return this.energyHeatConductorMap;
    }

    @Override
    public List<InfoTile<IHeatTile>> getHeatValidReceivers() {
        return this.validHeatReceivers;
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.needUpdate) {
            this.energyConductorMap.clear();
            this.validReceivers.clear();
            this.energyTypeConductorMap.clear();
            this.validTypeReceivers.clear();
            this.energyCoolConductorMap.clear();
            this.validColdReceivers.clear();
            this.validHeatReceivers.clear();
            this.energyHeatConductorMap.clear();
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this.getWorld(), this));
            if (this.heat) {
                MinecraftForge.EVENT_BUS.post((Event)new HeatTileLoadEvent(this, this.getWorld()));
            }
            if (this.cold) {
                MinecraftForge.EVENT_BUS.post((Event)new CoolTileLoadEvent(this, this.getWorld()));
            }
            if (this.quantum) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyEvent(this.getWorld(), EnumTypeEvent.LOAD, EnergyType.QUANTUM, this));
            }
            if (this.experience) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyEvent(this.getWorld(), EnumTypeEvent.LOAD, EnergyType.EXPERIENCE, this));
            }
            if (this.solarium) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyEvent(this.getWorld(), EnumTypeEvent.LOAD, EnergyType.SOLARIUM, this));
            }
            if (this.radiation) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyEvent(this.getWorld(), EnumTypeEvent.LOAD, EnergyType.RADIATION, this));
            }
            this.needUpdate = false;
            this.updateConnectivity();
        }
        if (this.enumTypeOperation != null) {
            switch (this.enumTypeOperation) {
                case HEAT: {
                    this.heat = true;
                    MinecraftForge.EVENT_BUS.post((Event)new HeatTileLoadEvent(this, this.getWorld()));
                    break;
                }
                case COLD: {
                    this.cold = true;
                    MinecraftForge.EVENT_BUS.post((Event)new CoolTileLoadEvent(this, this.getWorld()));
                    break;
                }
                case QUANTUM: {
                    this.quantum = true;
                    MinecraftForge.EVENT_BUS.post((Event)new EnergyEvent(this.getWorld(), EnumTypeEvent.LOAD, EnergyType.QUANTUM, this));
                    break;
                }
                case EXPERIENCE: {
                    this.experience = true;
                    MinecraftForge.EVENT_BUS.post((Event)new EnergyEvent(this.getWorld(), EnumTypeEvent.LOAD, EnergyType.EXPERIENCE, this));
                    break;
                }
                case SOLARIUM: {
                    this.solarium = true;
                    MinecraftForge.EVENT_BUS.post((Event)new EnergyEvent(this.getWorld(), EnumTypeEvent.LOAD, EnergyType.SOLARIUM, this));
                    break;
                }
                case RADIATION: {
                    this.radiation = true;
                }
            }
            this.enumTypeOperation = null;
        }
        if (this.updateConnect) {
            this.updateConnect = false;
            this.updateConnectivity();
        }
    }

    @Override
    public List<InfoTile<EnergyTile>> getValidReceivers() {
        return this.validReceivers;
    }

    @Override
    public Map<Direction, EnergyTile> getTiles() {
        return this.energyConductorMap;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.getWorld().f_46443_ && !this.addedToEnergyNet) {
            this.energyConductorMap.clear();
            this.validReceivers.clear();
            this.energyTypeConductorMap.clear();
            this.validTypeReceivers.clear();
            this.energyCoolConductorMap.clear();
            this.validColdReceivers.clear();
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this.getWorld(), this));
            if (this.heat) {
                MinecraftForge.EVENT_BUS.post((Event)new HeatTileLoadEvent(this, this.getWorld()));
            }
            if (this.cold) {
                MinecraftForge.EVENT_BUS.post((Event)new CoolTileLoadEvent(this, this.getWorld()));
            }
            if (this.quantum) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyEvent(this.getWorld(), EnumTypeEvent.LOAD, EnergyType.QUANTUM, this));
            }
            if (this.experience) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyEvent(this.getWorld(), EnumTypeEvent.LOAD, EnergyType.EXPERIENCE, this));
            }
            if (this.solarium) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyEvent(this.getWorld(), EnumTypeEvent.LOAD, EnergyType.SOLARIUM, this));
            }
            if (this.radiation) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyEvent(this.getWorld(), EnumTypeEvent.LOAD, EnergyType.RADIATION, this));
            }
            this.addedToEnergyNet = true;
            this.updateConnectivity();
        }
    }

    @Override
    public void onUnloaded() {
        if (!this.getWorld().f_46443_ && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnLoadEvent(this.getWorld(), this));
            if (this.heat) {
                MinecraftForge.EVENT_BUS.post((Event)new HeatTileUnloadEvent(this, this.getWorld()));
            }
            if (this.cold) {
                MinecraftForge.EVENT_BUS.post((Event)new CoolTileUnloadEvent(this, this.getWorld()));
            }
            if (this.quantum) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyEvent(this.getWorld(), EnumTypeEvent.UNLOAD, EnergyType.QUANTUM, this));
            }
            if (this.experience) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyEvent(this.getWorld(), EnumTypeEvent.UNLOAD, EnergyType.EXPERIENCE, this));
            }
            if (this.solarium) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyEvent(this.getWorld(), EnumTypeEvent.UNLOAD, EnergyType.SOLARIUM, this));
            }
            if (this.radiation) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyEvent(this.getWorld(), EnumTypeEvent.UNLOAD, EnergyType.RADIATION, this));
            }
            this.addedToEnergyNet = false;
        }
        super.onUnloaded();
    }

    @Override
    public void updateConnectivity() {
        Direction[] var4;
        Level world = this.getWorld();
        byte newConnectivity = 0;
        for (Direction dir : var4 = Direction.values()) {
            newConnectivity = (byte)(newConnectivity << 1);
            if (this.getBlackList().contains(dir)) continue;
            Object tile = this.energyConductorMap.get(dir);
            if (tile != null) {
                newConnectivity = (byte)(newConnectivity + 1);
                continue;
            }
            Map map = this.energyTypeConductorMap.computeIfAbsent(EnergyType.SOLARIUM, k -> new HashMap());
            tile = map.get(dir);
            if (tile != null) {
                newConnectivity = (byte)(newConnectivity + 1);
                continue;
            }
            tile = this.energyHeatConductorMap.get(dir);
            if (tile != null) {
                newConnectivity = (byte)(newConnectivity + 1);
                continue;
            }
            tile = this.energyCoolConductorMap.get(dir);
            if (tile != null) {
                newConnectivity = (byte)(newConnectivity + 1);
                continue;
            }
            map = this.energyTypeConductorMap.computeIfAbsent(EnergyType.QUANTUM, k -> new HashMap());
            tile = map.get(dir);
            if (tile != null) {
                newConnectivity = (byte)(newConnectivity + 1);
                continue;
            }
            map = this.energyTypeConductorMap.computeIfAbsent(EnergyType.RADIATION, k -> new HashMap());
            tile = map.get(dir);
            if (tile != null) {
                newConnectivity = (byte)(newConnectivity + 1);
                continue;
            }
            map = this.energyTypeConductorMap.computeIfAbsent(EnergyType.EXPERIENCE, k -> new HashMap());
            tile = map.get(dir);
            if (tile == null) continue;
            newConnectivity = (byte)(newConnectivity + 1);
        }
        this.setConnectivity(newConnectivity);
        this.cableItem = this.cableType;
    }

    @Override
    public boolean wrenchCanRemove(Player player) {
        return false;
    }

    @Override
    public boolean acceptsEnergyFrom(EnergyEmitter emitter, Direction direction) {
        return !this.getBlackList().contains(direction);
    }

    @Override
    public boolean emitsEnergyTo(EnergyAcceptor receiver, Direction direction) {
        return !this.getBlackList().contains(direction);
    }

    public boolean canInteractWith() {
        return true;
    }

    @Override
    public double getConductionLoss() {
        return this.cableType.loss;
    }

    @Override
    public double getConductorBreakdownEnergy() {
        return this.cableType.capacity + 1.0;
    }

    @Override
    public double getConductorBreakdownEnergy(EnergyType energyType) {
        return 2.147483647E9;
    }

    @Override
    public long getIdNetwork() {
        return this.id;
    }

    @Override
    public int getHashCodeSource() {
        return this.hashCodeSource;
    }

    @Override
    public void setHashCodeSource(int hashCode) {
        this.hashCodeSource = hashCode;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public void AddCoolTile(ICoolTile tile, Direction dir) {
        if (!this.getWorld().f_46443_) {
            if (!this.energyCoolConductorMap.containsKey(dir)) {
                this.energyCoolConductorMap.put(dir, tile);
                this.validColdReceivers.add(new InfoTile<ICoolTile>(tile, dir.m_122424_()));
            }
            this.updateConnect = true;
        }
    }

    @Override
    public void RemoveCoolTile(ICoolTile tile, Direction dir) {
        if (!this.getWorld().f_46443_) {
            this.energyCoolConductorMap.remove(dir);
            Iterator<InfoTile<ICoolTile>> iter = this.validColdReceivers.iterator();
            while (iter.hasNext()) {
                InfoTile<ICoolTile> tileInfoTile = iter.next();
                if (tileInfoTile.tileEntity != tile) continue;
                iter.remove();
                break;
            }
            this.updateConnect = true;
        }
    }

    @Override
    public Map<Direction, ICoolTile> getCoolTiles() {
        return this.energyCoolConductorMap;
    }

    @Override
    public List<InfoTile<ICoolTile>> getCoolValidReceivers() {
        return this.validColdReceivers;
    }

    @Override
    public List<InfoTile<ITile>> getValidReceivers(EnergyType type) {
        return this.validTypeReceivers.computeIfAbsent(type, k -> new LinkedList());
    }

    @Override
    public Map<Direction, ITile> getTiles(EnergyType type) {
        return this.energyTypeConductorMap.computeIfAbsent(type, k -> new HashMap());
    }

    @Override
    public com.denfop.api.otherenergies.common.InfoCable getCable(EnergyType type) {
        return this.typeCable;
    }

    @Override
    public void setCable(EnergyType type, com.denfop.api.otherenergies.common.InfoCable cable) {
        this.typeCable = cable;
    }

    @Override
    public void RemoveTile(EnergyType type, ITile tile, Direction facing1) {
        if (!this.getWorld().f_46443_) {
            this.energyTypeConductorMap.computeIfAbsent(type, k -> new HashMap()).remove(facing1);
            Iterator iter = this.validTypeReceivers.computeIfAbsent(type, k -> new LinkedList()).iterator();
            while (iter.hasNext()) {
                InfoTile tileInfoTile = (InfoTile)iter.next();
                if (tileInfoTile.tileEntity != tile) continue;
                iter.remove();
                break;
            }
            this.updateConnect = true;
        }
    }

    @Override
    public void AddTile(EnergyType type, ITile tile, Direction facing1) {
        if (!this.getWorld().f_46443_) {
            Map map = this.energyTypeConductorMap.computeIfAbsent(type, k -> new HashMap());
            if (!map.containsKey(facing1)) {
                map.put(facing1, tile);
                this.validTypeReceivers.computeIfAbsent(type, k -> new LinkedList()).add(new InfoTile<ITile>(tile, facing1.m_122424_()));
            }
            this.updateConnect = true;
        }
    }

    @Override
    public double getConductorBreakdownHeat() {
        return 16001.0;
    }

    @Override
    public double getConductorBreakdownCold() {
        return 65.0;
    }

    @Override
    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer packet = super.writePacket();
        try {
            EncoderHandler.encode(packet, this.cableType);
            EncoderHandler.encode(packet, this.connectivity);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer) {
        super.readPacket(customPacketBuffer);
        try {
            this.cableType = UniversalType.values[(Integer)DecoderHandler.decode(customPacketBuffer)];
            this.connectivity = (Byte)DecoderHandler.decode(customPacketBuffer);
            this.rerender();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void update_render() {
        if (!this.getWorld().f_46443_) {
            this.updateConnectivity();
        }
    }

    @Override
    public com.denfop.api.otherenergies.cool.InfoCable getCoolCable() {
        return this.typeColdCable;
    }

    @Override
    public void setCoolCable(com.denfop.api.otherenergies.cool.InfoCable cable) {
        this.typeColdCable = cable;
    }

    @Override
    public EnergyType getEnergyType() {
        return EnergyType.QUANTUM;
    }

    @Override
    public boolean hasEnergies() {
        return true;
    }

    @Override
    public List<EnergyType> getEnergies() {
        return this.energies;
    }

    @Override
    public boolean acceptsCoolFrom(ICoolEmitter var1, Direction var2) {
        return !this.getBlackList().contains(var2);
    }

    @Override
    public boolean emitsCoolTo(ICoolAcceptor var1, Direction var2) {
        return !this.getBlackList().contains(var2);
    }

    @Override
    public boolean acceptsHeatFrom(IHeatEmitter var1, Direction var2) {
        return !this.getBlackList().contains(var2);
    }

    @Override
    public boolean emitsHeatTo(IHeatAcceptor var1, Direction var2) {
        return !this.getBlackList().contains(var2);
    }

    @Override
    public boolean acceptsFrom(IEmitter var1, Direction var2) {
        return !this.getBlackList().contains(var2);
    }

    @Override
    public boolean emitsTo(IAcceptor var1, Direction var2) {
        return !this.getBlackList().contains(var2);
    }

    @Override
    public BlockEntity getTile() {
        return this;
    }
}

