/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.transport.tiles;

import com.denfop.api.energy.InfoCable;
import com.denfop.api.energy.interfaces.EnergyAcceptor;
import com.denfop.api.energy.interfaces.EnergyEmitter;
import com.denfop.api.energy.interfaces.EnergyTile;
import com.denfop.api.energy.networking.ConductorInfo;
import com.denfop.api.otherenergies.common.InfoTile;
import com.denfop.blockentity.transport.tiles.BlockEntityMultiCable;
import com.denfop.blockentity.transport.types.ICableItem;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;

public class EnergyConductor
implements com.denfop.api.energy.interfaces.EnergyConductor {
    public final ConductorInfo conductor;
    public int hashCodeSource;
    public boolean needUpdate;
    public InfoCable cable;
    public long id;
    public List<Direction> blackList = new LinkedList<Direction>();
    public Map<Direction, EnergyTile> energyConductorMap = new HashMap<Direction, EnergyTile>();
    public List<InfoTile<EnergyTile>> validReceivers = new LinkedList<InfoTile<EnergyTile>>();
    protected ICableItem cableType;
    BlockPos pos;

    public EnergyConductor(BlockEntityMultiCable tileEntityCable) {
        this.cableType = tileEntityCable.getCableItem();
        this.pos = tileEntityCable.getPos();
        this.conductor = new ConductorInfo(tileEntityCable.pos, this);
    }

    @Override
    public BlockPos getPos() {
        return this.pos;
    }

    public List<Direction> getBlackList() {
        return this.blackList;
    }

    @Override
    public Map<Direction, EnergyTile> getTiles() {
        return this.energyConductorMap;
    }

    @Override
    public List<InfoTile<EnergyTile>> getValidReceivers() {
        return this.validReceivers;
    }

    @Override
    public boolean acceptsEnergyFrom(EnergyEmitter emitter, Direction direction) {
        return !this.getBlackList().contains(direction);
    }

    @Override
    public boolean emitsEnergyTo(EnergyAcceptor receiver, Direction direction) {
        return !this.getBlackList().contains(direction);
    }

    @Override
    public void RemoveTile(EnergyTile tile, Direction facing1) {
        this.energyConductorMap.remove(facing1);
        Iterator<InfoTile<EnergyTile>> iter = this.validReceivers.iterator();
        while (iter.hasNext()) {
            InfoTile<EnergyTile> tileInfoTile = iter.next();
            if (tileInfoTile.tileEntity != tile) continue;
            iter.remove();
            break;
        }
    }

    @Override
    public void AddTile(EnergyTile tile, Direction facing1) {
        if (!this.energyConductorMap.containsKey(facing1)) {
            this.energyConductorMap.put(facing1, tile);
            this.validReceivers.add(new InfoTile<EnergyTile>(tile, facing1.m_122424_()));
        }
    }

    @Override
    public double getConductionLoss() {
        return this.cableType.getLoss();
    }

    @Override
    public double getConductorBreakdownEnergy() {
        return this.cableType.getCapacity() + 1.0;
    }

    @Override
    public void removeConductor() {
    }

    @Override
    public InfoCable getCable() {
        return this.cable;
    }

    @Override
    public void setCable(InfoCable cable) {
        this.cable = cable;
    }

    @Override
    public ConductorInfo getInfo() {
        return this.conductor;
    }

    @Override
    public long getIdNetwork() {
        return this.id;
    }

    @Override
    public int getHashCodeSource() {
        return this.hashCodeSource;
    }

    @Override
    public void setHashCodeSource(int hashCode) {
        this.hashCodeSource = hashCode;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }
}

