/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.transport.types;

import com.denfop.blockentity.transport.types.ICableItem;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;

public enum CableType implements StringRepresentable,
ICableItem
{
    glass(0.25f, 0.06, 4096.0),
    glass1(0.25f, 0.07, 8192.0),
    glass2(0.25f, 0.08, 32768.0),
    glass3(0.25f, 0.09, 131072.0),
    glass4(0.25f, 0.1, 524288.0),
    glass5(0.25f, 0.11, 2097152.0),
    glass6(0.25f, 0.12, 8388608.0),
    glass7(0.25f, 0.15, 3.3554432E7),
    glass8(0.25f, 0.18, 1.34217728E8),
    glass9(0.25f, 0.2, 5.36870912E8),
    glass10(0.25f, 0.25, 8.58993459E9),
    copper(0.25f, 0.015, 32.0),
    copper1(0.375f, 0.015, 128.0, 1),
    glass_1(0.25f, 0.05, 2048.0, 0),
    gold(0.25f, 0.02, 512.0),
    gold1(0.375f, 0.02, 1024.0, 1),
    iron(0.25f, 0.04, 256.0),
    iron1(0.375f, 0.04, 512.0, 1),
    tin(0.25f, 0.02, 32.0),
    tin1(0.375f, 0.02, 128.0, 1);

    public static final CableType[] values;
    private static final Map<String, CableType> nameMap;
    public final float thickness;
    public final double loss;
    public final double capacity;
    public final int insulation;
    private final ResourceLocation texture;

    private CableType(float thickness, double loss, double capacity) {
        this.thickness = thickness;
        this.loss = loss;
        this.capacity = capacity;
        this.insulation = 0;
        this.texture = new ResourceLocation("industrialupgrade", "blocks/wiring/" + this.getMainPath() + "/" + this.getNameCable());
    }

    private CableType(float thickness, double loss, double capacity, int insulation) {
        this.thickness = thickness;
        this.loss = loss;
        this.capacity = capacity;
        this.insulation = insulation;
        this.texture = new ResourceLocation("industrialupgrade", "blocks/wiring/" + this.getMainPath() + "/" + this.getNameCable());
    }

    public static CableType get(String name) {
        return nameMap.get(name);
    }

    public String getName() {
        return this.name() + "_cable";
    }

    @Override
    public float getThickness() {
        return this.thickness;
    }

    public int getId() {
        return this.ordinal();
    }

    @Override
    public String getNameCable() {
        return this.name() + "_cable";
    }

    @Override
    public String getMainPath() {
        return "cable";
    }

    @Override
    public ResourceLocation getRecourse() {
        return this.texture;
    }

    @Override
    public double getCapacity() {
        return this.capacity;
    }

    @Override
    public double getLoss() {
        return this.loss;
    }

    public String m_7912_() {
        return this.getName();
    }

    static {
        values = CableType.values();
        nameMap = new HashMap<String, CableType>();
        for (CableType type : values) {
            nameMap.put(type.getName(), type);
        }
    }
}

