/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blocks;

import com.denfop.blocks.BlockCore;
import com.denfop.blocks.ItemBlockCore;
import com.denfop.blocks.SubEnum;
import com.denfop.datagen.blocktags.BlockTagsProvider;
import com.denfop.datagen.blocktags.IBlockTag;
import com.denfop.dataregistry.DataMultiBlock;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import oshi.util.tuples.Pair;

public class BlockSwampStrippedRubberWood<T extends Enum<T>>
extends BlockCore<T>
implements IBlockTag {
    public static final EnumProperty<RubberWoodState> stateProperty = EnumProperty.m_61587_((String)"state", RubberWoodState.class);

    public BlockSwampStrippedRubberWood(T[] element, DataMultiBlock<T, ? extends BlockCore<T>, ? extends ItemBlockCore<T>> dataBlock) {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_155954_(1.0f).m_60977_().m_60918_(SoundType.f_56736_).m_60999_(), element, dataBlock);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(stateProperty, (Comparable)((Object)RubberWoodState.plain_y)));
        BlockTagsProvider.list.add(this);
    }

    public static void spawnAsEntity(Level worldIn, BlockPos pos, ItemStack stack) {
        if (!(worldIn.f_46443_ || stack.m_41619_() || worldIn.restoringBlockSnapshots)) {
            float f = 0.5f;
            double d0 = (double)(worldIn.f_46441_.m_188501_() * 0.5f) + 0.25;
            double d1 = (double)(worldIn.f_46441_.m_188501_() * 0.5f) + 0.25;
            double d2 = (double)(worldIn.f_46441_.m_188501_() * 0.5f) + 0.25;
            ItemEntity entityitem = new ItemEntity(worldIn, (double)pos.m_123341_() + d0, (double)pos.m_123342_() + d1, (double)pos.m_123343_() + d2, stack);
            entityitem.m_32060_();
            worldIn.m_7967_((Entity)entityitem);
        }
    }

    private static RubberWoodState getPlainAxisState(Direction.Axis axis) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> RubberWoodState.plain_x;
            case Direction.Axis.Y -> RubberWoodState.plain_y;
            case Direction.Axis.Z -> RubberWoodState.plain_z;
        };
    }

    public PushReaction getPistonPushReaction(BlockState state) {
        RubberWoodState rstate = (RubberWoodState)((Object)state.m_61143_(stateProperty));
        return rstate != RubberWoodState.plain_x && rstate != RubberWoodState.plain_y && rstate != RubberWoodState.plain_z ? PushReaction.BLOCK : PushReaction.NORMAL;
    }

    @Override
    public int getMetaFromState(BlockState state) {
        return ((RubberWoodState)((Object)state.m_61143_(stateProperty))).getId();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_49915_) {
        p_49915_.m_61104_(new Property[]{stateProperty});
    }

    @Override
    public <T extends Enum<T>> BlockState getStateForPlacement(T element, BlockPlaceContext context) {
        return (BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(stateProperty, (Comparable)((Object)BlockSwampStrippedRubberWood.getPlainAxisState(context.m_43719_().m_122434_())));
    }

    @Override
    public <T extends Enum<T>> void fillItemCategory(CreativeModeTab p40569, NonNullList<ItemStack> p40570, T element) {
        p40570.add((Object)new ItemStack((ItemLike)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(stateProperty, (Comparable)((Object)RubberWoodState.values()[((SubEnum)((Object)element)).getId()]))).m_60734_()));
    }

    @Override
    public List<ItemStack> m_49635_(BlockState p_60537_, LootParams.Builder p_60538_) {
        if (!p_60538_.m_287258_().f_46443_) {
            int count = 1;
            for (int j1 = 0; j1 < count; ++j1) {
                boolean chance = true;
                if (p_60538_.m_287258_().f_46441_.m_188501_() > (float)chance) continue;
                ItemBlockCore item = this.getMultiData().getItem(RubberWoodState.plain_y.getId());
                BlockSwampStrippedRubberWood.spawnAsEntity((Level)p_60538_.m_287258_(), new BlockPos((int)((Vec3)p_60538_.m_287261_((LootContextParam)LootContextParams.f_81460_)).f_82479_, (int)((Vec3)p_60538_.m_287261_((LootContextParam)LootContextParams.f_81460_)).f_82480_, (int)((Vec3)p_60538_.m_287261_((LootContextParam)LootContextParams.f_81460_)).f_82481_), new ItemStack(item, 1));
            }
        }
        return List.of();
    }

    @Override
    public Block getBlock() {
        return this;
    }

    @Override
    public Pair<String, Integer> getHarvestLevel() {
        return new Pair((Object)"axe", (Object)0);
    }

    public static enum RubberWoodState implements SubEnum
    {
        plain_y(Direction.Axis.Y, null, false),
        plain_x(Direction.Axis.X, null, false),
        plain_z(Direction.Axis.Z, null, false);

        private static final RubberWoodState[] values;
        public final Direction.Axis axis;
        public final Direction facing;
        public final boolean wet;

        private RubberWoodState(Direction.Axis axis, Direction facing, boolean wet) {
            this.axis = axis;
            this.facing = facing;
            this.wet = wet;
        }

        @Override
        public boolean registerOnlyBlock() {
            return true;
        }

        @Override
        public int getId() {
            return this.ordinal();
        }

        @Override
        public String getName() {
            return this.name();
        }

        @Override
        public String getMainPath() {
            return "swamp_stripped_rubber_wood";
        }

        static {
            values = RubberWoodState.values();
        }
    }
}

