/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.datagen;

import com.denfop.datagen.IUChestLoot;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.LootDataId;
import net.minecraft.world.level.storage.loot.LootDataResolver;
import net.minecraft.world.level.storage.loot.LootDataType;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import org.slf4j.Logger;

public class IULootTableProvider
implements DataProvider {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>> industrialSubProviders = ImmutableList.of((Object)Pair.of(IUChestLoot::new, (Object)LootContextParamSets.f_81411_));
    private final PackOutput.PathProvider pathProvider;
    public static final ResourceLocation VOLCANO_LOOT_TABLE = ResourceLocation.m_214293_((String)"industrialupgrade", (String)"chests/volcano");

    public IULootTableProvider(PackOutput pOutput) {
        this.pathProvider = pOutput.m_245269_(PackOutput.Target.DATA_PACK, "loot_tables");
    }

    public CompletableFuture<?> m_213708_(CachedOutput pOutput) {
        final HashMap map = Maps.newHashMap();
        this.industrialSubProviders.forEach(p_124458_ -> ((Consumer)((Supplier)p_124458_.getFirst()).get()).accept((p_176077_, p_176078_) -> {
            if (map.put(p_176077_, p_176078_.m_79165_((LootContextParamSet)p_124458_.getSecond()).m_79167_()) != null) {
                throw new IllegalStateException("Duplicate loot table " + String.valueOf(p_176077_));
            }
        }));
        ValidationContext validationcontext = new ValidationContext(LootContextParamSets.f_81420_, new LootDataResolver(){

            @Nullable
            public <T> T m_278667_(LootDataId<T> p_279283_) {
                return (T)(p_279283_.f_278383_() == LootDataType.f_278413_ ? (LootTable)map.get(p_279283_.f_278500_()) : null);
            }
        });
        Multimap multimap = validationcontext.m_79352_();
        if (!multimap.isEmpty()) {
            multimap.forEach((p_124446_, p_124447_) -> LOGGER.warn("Found validation problem in {}: {}", p_124446_, p_124447_));
            throw new IllegalStateException("Failed to validate loot tables, see logs");
        }
        return CompletableFuture.allOf((CompletableFuture[])map.entrySet().stream().map(p_278900_ -> {
            ResourceLocation resourcelocation1 = (ResourceLocation)p_278900_.getKey();
            LootTable loottable = (LootTable)p_278900_.getValue();
            Path path = this.pathProvider.m_245731_(resourcelocation1);
            return DataProvider.m_253162_((CachedOutput)pOutput, (JsonElement)LootDataType.f_278413_.m_278857_().toJsonTree((Object)loottable), (Path)path);
        }).toArray(CompletableFuture[]::new));
    }

    public String m_6055_() {
        return "Loot Tables";
    }
}

