/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.dataregistry;

import com.denfop.blocks.ItemBlockCore;
import com.denfop.blocks.SubEnum;
import com.denfop.dataregistry.DataBlock;
import com.denfop.mixin.access.DeferredRegisterAccessor;
import com.denfop.register.Register;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.RegistryObject;

public class DataMultiBlock<T extends Enum<T>, E extends Block, F extends ItemBlockCore> {
    private final RegistryObject<E> block;
    List<RegistryObject<F>> registryObjectList;

    public DataMultiBlock(Class<T> typeClass, Class<E> blockClass, Class<F> itemClass) {
        Enum[] collections = (Enum[])typeClass.getEnumConstants();
        try {
            Constructor<?> constructor = blockClass.getConstructors()[0];
            Supplier<Block> supplier = () -> {
                try {
                    return (Block)constructor.newInstance(collections, this);
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            };
            ResourceLocation key = new ResourceLocation("industrialupgrade", ((SubEnum)((Object)collections[0])).getMainPath());
            RegistryObject ret = RegistryObject.create((ResourceLocation)key, (ResourceKey)Register.BLOCKS.getRegistryKey(), (String)"industrialupgrade");
            Map entries = ((DeferredRegisterAccessor)Register.BLOCKS).getEntries();
            if (entries.putIfAbsent(ret, supplier) != null) {
                throw new IllegalArgumentException("Duplicate registration " + ((SubEnum)((Object)collections[0])).getMainPath());
            }
            this.block = ret;
            if (!((SubEnum)((Object)collections[0])).registerOnlyBlock()) {
                this.registerBlockItem((T)collections, (RegistryObject<E>)ret, itemClass);
            } else {
                this.registerBlockItem(collections[0], ret, itemClass);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void registerBlockItem(T[] collections, RegistryObject<E> block, Class<F> itemClass) {
        int indexMax = 0;
        HashMap<T, RegistryObject> map = new HashMap<T, RegistryObject>();
        for (T type : collections) {
            try {
                Constructor<?> constructor = itemClass.getConstructors()[0];
                Supplier<ItemBlockCore> supplier = () -> {
                    try {
                        return (ItemBlockCore)constructor.newInstance(block.get(), type);
                    }
                    catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                        throw new RuntimeException(e);
                    }
                };
                ResourceLocation key = new ResourceLocation("industrialupgrade", ((SubEnum)type).getMainPath() + "/" + ((SubEnum)type).m_7912_());
                if (indexMax < ((SubEnum)type).getId()) {
                    indexMax = ((SubEnum)type).getId();
                }
                if (!((SubEnum)type).register()) continue;
                RegistryObject ret = RegistryObject.create((ResourceLocation)key, (ResourceKey)Register.ITEMS.getRegistryKey(), (String)"industrialupgrade");
                Map entries = ((DeferredRegisterAccessor)Register.ITEMS).getEntries();
                DataBlock.objects.add(ret);
                if (entries.putIfAbsent(ret, supplier) != null) {
                    throw new IllegalArgumentException("Duplicate registration " + String.valueOf(type));
                }
                map.put(type, ret);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        this.registryObjectList = new ArrayList<Object>(Collections.nCopies(indexMax + 1, null));
        for (Map.Entry entry : map.entrySet()) {
            this.registryObjectList.set(((SubEnum)((Object)((Enum)entry.getKey()))).getId(), (RegistryObject)entry.getValue());
        }
    }

    public RegistryObject<E> getBlock() {
        return this.block;
    }

    private void registerBlockItem(T type, RegistryObject<E> block, Class<F> itemClass) {
        int indexMax = 0;
        HashMap<T, RegistryObject> map = new HashMap<T, RegistryObject>();
        try {
            Constructor<?> constructor = itemClass.getConstructors()[0];
            Supplier<ItemBlockCore> supplier = () -> {
                try {
                    return (ItemBlockCore)constructor.newInstance(block.get(), type);
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            };
            ResourceLocation key = new ResourceLocation("industrialupgrade", ((SubEnum)type).getMainPath() + "/" + ((SubEnum)type).m_7912_());
            if (indexMax < ((SubEnum)type).getId()) {
                indexMax = ((SubEnum)type).getId();
            }
            RegistryObject ret = RegistryObject.create((ResourceLocation)key, (ResourceKey)Register.ITEMS.getRegistryKey(), (String)"industrialupgrade");
            Map entries = ((DeferredRegisterAccessor)Register.ITEMS).getEntries();
            DataBlock.objects.add(ret);
            if (entries.putIfAbsent(ret, supplier) != null) {
                throw new IllegalArgumentException("Duplicate registration " + String.valueOf(type));
            }
            map.put(type, ret);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.registryObjectList = new ArrayList<Object>(Collections.nCopies(indexMax + 1, null));
        for (Map.Entry entry : map.entrySet()) {
            this.registryObjectList.set(((SubEnum)((Object)((Enum)entry.getKey()))).getId(), (RegistryObject)entry.getValue());
        }
    }

    public F getItem(int meta) {
        return (F)((ItemBlockCore)this.registryObjectList.get(meta % this.registryObjectList.size()).get());
    }

    public ItemStack getItemStack(int meta) {
        return new ItemStack((ItemLike)this.registryObjectList.get(meta).get());
    }

    public int getMeta(F item) {
        int i = 0;
        for (RegistryObject<F> registryObject : this.registryObjectList) {
            if (registryObject.get() == item) {
                return i;
            }
            ++i;
        }
        return 0;
    }
}

