/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.effects;

import com.denfop.blockentity.base.BlockEntityAnvil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.ModelData;

@OnlyIn(value=Dist.CLIENT)
public class BreakingItemParticle
extends TextureSheetParticle {
    private final float uo;
    private final float vo;

    BreakingItemParticle(ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed, ItemStack pStack) {
        this(pLevel, pX, pY, pZ, pStack);
        this.f_107215_ *= (double)0.1f;
        this.f_107216_ *= (double)0.1f;
        this.f_107217_ *= (double)0.1f;
        this.f_107215_ += pXSpeed;
        this.f_107216_ += pYSpeed;
        this.f_107217_ += pZSpeed;
    }

    protected BreakingItemParticle(ClientLevel pLevel, double pX, double pY, double pZ, ItemStack pStack) {
        super(pLevel, pX, pY, pZ, 0.0, 0.0, 0.0);
        BakedModel model = Minecraft.m_91087_().m_91291_().m_174264_(pStack, (Level)pLevel, (LivingEntity)null, 0);
        this.m_108337_(model.m_7343_().m_173464_(model, pStack, pLevel, null, 0).getParticleIcon(ModelData.EMPTY));
        this.f_107226_ = 1.0f;
        this.f_107663_ /= 1.0f;
        this.uo = this.f_107223_.m_188501_() * 3.0f;
        this.vo = this.f_107223_.m_188501_() * 3.0f;
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107429_;
    }

    protected float m_5970_() {
        return this.f_108321_.m_118367_((double)((this.uo + 1.0f) / 4.0f * 16.0f));
    }

    protected float m_5952_() {
        return this.f_108321_.m_118367_((double)(this.uo / 4.0f * 16.0f));
    }

    protected float m_5951_() {
        return this.f_108321_.m_118393_((double)(this.vo / 4.0f * 16.0f));
    }

    protected float m_5950_() {
        return this.f_108321_.m_118393_((double)((this.vo + 1.0f) / 4.0f * 16.0f));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class AnvilProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public AnvilProvider(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle createParticle(SimpleParticleType pType, ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed) {
            BlockEntity block = pLevel.m_7702_(new BlockPos((int)pX, (int)(pY - 1.0), (int)pZ));
            ItemStack stack = ItemStack.f_41583_;
            if (block instanceof BlockEntityAnvil) {
                stack = ((BlockEntityAnvil)block).inputSlotA.get(0);
            }
            return new BreakingItemParticle(pLevel, pX, pY, pZ, stack);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Provider
    implements ParticleProvider<ItemParticleOption> {
        public Particle createParticle(ItemParticleOption pType, ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed) {
            return new BreakingItemParticle(pLevel, pX, pY, pZ, pXSpeed, pYSpeed, pZSpeed, pType.m_123718_());
        }
    }
}

