/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.cyclotron;

import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseMachineRecipe;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.world.item.ItemStack;

public class CyclotronHandler {
    private static final List<CyclotronHandler> recipes = new ArrayList<CyclotronHandler>();
    private final int percent;
    private final ItemStack input;
    private final ItemStack output;

    public CyclotronHandler(ItemStack input, ItemStack output, int percent) {
        this.input = input;
        this.output = output;
        this.percent = percent;
    }

    public static List<CyclotronHandler> getRecipes() {
        if (recipes.isEmpty()) {
            CyclotronHandler.initRecipes();
        }
        return recipes;
    }

    public static CyclotronHandler addRecipe(ItemStack input, ItemStack output, int percent) {
        CyclotronHandler recipe = new CyclotronHandler(input, output, percent);
        if (recipes.contains(recipe)) {
            return null;
        }
        recipes.add(recipe);
        return recipe;
    }

    public static CyclotronHandler getRecipe(ItemStack is) {
        if (is == null || is.m_41619_()) {
            return null;
        }
        Iterator<CyclotronHandler> iterator = recipes.iterator();
        if (iterator.hasNext()) {
            CyclotronHandler recipe = iterator.next();
            return recipe;
        }
        return null;
    }

    public static void initRecipes() {
        for (BaseMachineRecipe container : Recipes.recipes.getRecipeList("cyclotron")) {
            CyclotronHandler.addRecipe(container.input.getInputs().get(0).getInputs().get(0), container.getOutput().items.get(0), container.getOutput().metadata.m_128451_("chance"));
        }
    }

    public ItemStack getInput() {
        return this.input;
    }

    public ItemStack getOutput() {
        return this.output.m_41777_();
    }

    public int getPercent() {
        return this.percent;
    }
}

