/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.earthquarry;

import com.denfop.blockentity.mechanism.BlockEntityElectricDryer;
import com.denfop.blocks.mechanism.BlockBaseMachine3Entity;
import com.denfop.integration.jei.IRecipeCategory;
import com.denfop.integration.jei.JeiInform;
import com.denfop.integration.jei.earthquarry.EarthQuarryHandler;
import com.denfop.screen.ScreenMain;
import com.denfop.utils.Localization;
import javax.annotation.Nonnull;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class EarthQuarryCategory
extends ScreenMain
implements IRecipeCategory<EarthQuarryHandler> {
    private final IDrawableStatic bg;
    private final JeiInform jeiInform;

    public EarthQuarryCategory(IGuiHelper guiHelper, JeiInform jeiInform) {
        super(((BlockEntityElectricDryer)BlockBaseMachine3Entity.electric_dryer.getDummyTe()).getGuiContainer((Player)Minecraft.m_91087_().f_91074_));
        this.bg = guiHelper.createDrawable(new ResourceLocation("industrialupgrade", "textures/gui/guivein.png"), 3, 3, 140, 140);
        this.jeiInform = jeiInform;
        this.f_96539_ = Component.m_237113_((String)this.getTitles());
    }

    @Override
    @Nonnull
    public String getTitles() {
        return Localization.translate("earth_quarry.jei");
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.bg;
    }

    public void draw(EarthQuarryHandler recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics stack, double mouseX, double mouseY) {
        int y = 20;
        int x = 25;
        this.drawSplitString(stack, Localization.translate("earth_quarry.jei1"), 5, 3, 135, 0x404040);
        this.drawSplitString(stack, " + " + recipe.chance + "% ->", 20, 30, 135, 0x404040);
    }

    public RecipeType<EarthQuarryHandler> getRecipeType() {
        return this.jeiInform.recipeType;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, EarthQuarryHandler recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 5, 25).addItemStack(recipe.getInput());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 60, 25).addItemStack(recipe.getOutput());
    }

    @Override
    protected ResourceLocation getTexture() {
        return new ResourceLocation("industrialupgrade", "textures/gui/guivein.png");
    }
}

