/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.painting;

import com.denfop.IUItem;
import com.denfop.blockentity.mechanism.multimechanism.simple.BlockEntityOreWashing;
import com.denfop.blocks.mechanism.BlockMoreMachine3Entity;
import com.denfop.containermenu.ContainerMenuMultiMachine;
import com.denfop.integration.jei.IRecipeCategory;
import com.denfop.integration.jei.JeiInform;
import com.denfop.integration.jei.painting.PaintingHandler;
import com.denfop.recipes.ItemStackHelper;
import com.denfop.screen.ScreenMain;
import com.denfop.utils.Localization;
import com.denfop.utils.ModUtils;
import javax.annotation.Nonnull;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class PaintingCategory
extends ScreenMain
implements IRecipeCategory<PaintingHandler> {
    private final IDrawableStatic bg;
    private final JeiInform jeiInform;
    private int progress = 0;
    private int energy = 0;

    public PaintingCategory(IGuiHelper guiHelper, JeiInform jeiInform) {
        super(new ContainerMenuMultiMachine((Player)Minecraft.m_91087_().f_91074_, (BlockEntityOreWashing)BlockMoreMachine3Entity.orewashing.getDummyTe(), 1, true));
        this.jeiInform = jeiInform;
        this.f_96539_ = Component.m_237113_((String)this.getTitles());
        this.bg = guiHelper.createDrawable(new ResourceLocation("industrialupgrade", "textures/gui/GUIPainter".toLowerCase() + ".png"), 3, 3, 140, 75);
    }

    @Override
    @Nonnull
    public String getTitles() {
        return Localization.translate(ItemStackHelper.fromData(IUItem.basemachine1, 1, 3).m_41778_());
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.bg;
    }

    public void draw(PaintingHandler recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics stack, double mouseX, double mouseY) {
        ++this.progress;
        int xScale = (int)((double)(9 * this.progress) / 100.0);
        if (xScale >= 9) {
            this.progress = 0;
        }
        this.draw(stack, ModUtils.mode(recipe.metadata), 64, 59, 0x404040);
        PaintingCategory.bindTexture(this.getTexture());
        this.drawTexturedModalRect(stack, 76, 35, 179, 34, xScale, 13);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, PaintingHandler recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 26, 33).addItemStack(recipe.getInput());
        builder.addSlot(RecipeIngredientRole.INPUT, 48, 33).addItemStack(recipe.getInput1());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 103, 33).addItemStack(recipe.getOutput());
        ItemStack item = recipe.getOutput();
        CompoundTag nbt = ModUtils.nbt(item);
        nbt.m_128359_("mode", recipe.metadata.m_128461_("mode"));
        builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 103, 33).addItemStack(item);
    }

    public RecipeType<PaintingHandler> getRecipeType() {
        return this.jeiInform.recipeType;
    }

    @Override
    protected ResourceLocation getTexture() {
        return new ResourceLocation("industrialupgrade", "textures/gui/GUIPainter.png".toLowerCase());
    }
}

