/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.smelterycasting;

import com.denfop.IUItem;
import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseFluidMachineRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.FluidStack;

public class SmelteryCastingHandler {
    private static final List<SmelteryCastingHandler> recipes = new ArrayList<SmelteryCastingHandler>();
    private final ItemStack input;
    private final ItemStack output;
    private final FluidStack inputFluid;

    public SmelteryCastingHandler(ItemStack input, ItemStack output, FluidStack inputFluid) {
        this.input = input;
        this.output = output;
        this.inputFluid = inputFluid;
    }

    public static List<SmelteryCastingHandler> getRecipes() {
        if (recipes.isEmpty()) {
            SmelteryCastingHandler.initRecipes();
        }
        return recipes;
    }

    public static SmelteryCastingHandler getRecipe(ItemStack is) {
        if (is == null || is.m_41619_()) {
            return null;
        }
        return recipes.get(0);
    }

    public static void initRecipes() {
        ItemStack output;
        FluidStack inputFluid;
        ItemStack input;
        List<BaseFluidMachineRecipe> list = Recipes.recipes.getRecipeFluid().getRecipeList("ingot_casting");
        for (BaseFluidMachineRecipe baseFluidMachineRecipe : list) {
            input = new ItemStack((ItemLike)IUItem.crafting_elements.getStack(496), 1);
            inputFluid = baseFluidMachineRecipe.input.getInputs().get(0);
            output = baseFluidMachineRecipe.getOutput().items.get(0);
            SmelteryCastingHandler.addRecipe(input, output, inputFluid);
        }
        for (BaseFluidMachineRecipe baseFluidMachineRecipe : Recipes.recipes.getRecipeFluid().getRecipeList("gear_casting")) {
            input = new ItemStack((ItemLike)IUItem.crafting_elements.getStack(497), 1);
            inputFluid = baseFluidMachineRecipe.input.getInputs().get(0);
            output = baseFluidMachineRecipe.getOutput().items.get(0);
            SmelteryCastingHandler.addRecipe(input, output, inputFluid);
        }
    }

    private static SmelteryCastingHandler addRecipe(ItemStack input, ItemStack output, FluidStack inputFluid) {
        SmelteryCastingHandler recipe = new SmelteryCastingHandler(input, output, inputFluid);
        if (recipes.contains(recipe)) {
            return null;
        }
        recipes.add(recipe);
        return recipe;
    }

    public ItemStack getInput() {
        return this.input;
    }

    public ItemStack getOutput() {
        return this.output;
    }

    public FluidStack getInputFluid() {
        return this.inputFluid;
    }
}

