/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.spacebody;

import com.denfop.api.space.IBaseResource;
import com.denfop.api.space.IBody;
import com.denfop.api.space.SpaceNet;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class SpaceBodyHandler {
    private static final List<SpaceBodyHandler> recipes = new ArrayList<SpaceBodyHandler>();
    final IBody body;
    private final List<ItemStack> input;
    List<FluidStack> output;

    public SpaceBodyHandler(IBody body, List<ItemStack> input, List<FluidStack> output) {
        this.body = body;
        this.input = input;
        this.output = output;
    }

    public static List<SpaceBodyHandler> getRecipes() {
        if (recipes.isEmpty()) {
            SpaceBodyHandler.initRecipes();
        }
        return recipes;
    }

    public static SpaceBodyHandler addRecipe(IBody body, List<ItemStack> input, List<FluidStack> output) {
        SpaceBodyHandler recipe = new SpaceBodyHandler(body, input, output);
        if (recipes.contains(recipe)) {
            return null;
        }
        recipes.add(recipe);
        return recipe;
    }

    public static void initRecipes() {
        for (IBody body : SpaceNet.instance.getBodyList()) {
            LinkedList<ItemStack> stacks = new LinkedList<ItemStack>();
            LinkedList<FluidStack> fluidStacks = new LinkedList<FluidStack>();
            List<IBaseResource> resource = body.getResources();
            if (resource == null || resource.isEmpty()) continue;
            block1: for (IBaseResource baseResource : resource) {
                if (baseResource.getItemStack() != null) {
                    for (ItemStack stack : stacks) {
                        if (!stack.m_150930_(baseResource.getItemStack().m_41720_())) continue;
                        continue block1;
                    }
                }
                if (baseResource.getFluidStack() != null) {
                    for (FluidStack fluidStack : fluidStacks) {
                        if (!fluidStack.isFluidEqual(baseResource.getFluidStack())) continue;
                        continue block1;
                    }
                }
                if (baseResource.getFluidStack() != null) {
                    fluidStacks.add(baseResource.getFluidStack());
                }
                if (baseResource.getItemStack() == null) continue;
                stacks.add(baseResource.getItemStack());
            }
            SpaceBodyHandler.addRecipe(body, stacks, fluidStacks);
        }
    }

    public List<ItemStack> getInput() {
        return this.input;
    }

    public List<FluidStack> getOutput() {
        return this.output;
    }
}

