/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.synthesis;

import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseMachineRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;

public class SynthesisHandler {
    private static final List<SynthesisHandler> recipes = new ArrayList<SynthesisHandler>();
    private final int percent;
    private final ItemStack input;
    private final ItemStack input1;
    private final ItemStack output;
    private final BaseMachineRecipe container;

    public SynthesisHandler(ItemStack input, ItemStack input1, ItemStack output, int percent, BaseMachineRecipe container) {
        this.input = input;
        this.input1 = input1;
        this.output = output;
        this.percent = percent;
        this.container = container;
    }

    public static List<SynthesisHandler> getRecipes() {
        if (recipes.isEmpty()) {
            SynthesisHandler.initRecipes();
        }
        return recipes;
    }

    public static SynthesisHandler addRecipe(ItemStack input, ItemStack input1, ItemStack output, int percent, BaseMachineRecipe container) {
        SynthesisHandler recipe = new SynthesisHandler(input, input1, output, percent, container);
        if (recipes.contains(recipe)) {
            return null;
        }
        recipes.add(recipe);
        return recipe;
    }

    public static SynthesisHandler getRecipe(ItemStack is) {
        if (is == null || is.m_41619_()) {
            return null;
        }
        for (SynthesisHandler recipe : recipes) {
            if (!recipe.matchesInput(is)) continue;
            return recipe;
        }
        return null;
    }

    public static void initRecipes() {
        for (BaseMachineRecipe container : Recipes.recipes.getRecipeList("synthesis")) {
            SynthesisHandler.addRecipe(container.input.getInputs().get(0).getInputs().get(0), container.input.getInputs().get(1).getInputs().get(0), container.getOutput().items.get(0), container.getOutput().metadata.m_128451_("percent"), container);
        }
    }

    public BaseMachineRecipe getContainer() {
        return this.container;
    }

    public ItemStack getInput() {
        return this.input;
    }

    public ItemStack getInput1() {
        return this.input1;
    }

    public ItemStack getOutput() {
        return this.output.m_41777_();
    }

    public int getPercent() {
        return this.percent;
    }

    public boolean matchesInput(ItemStack is) {
        return true;
    }
}

