/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.worldcollector.nether;

import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseMachineRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;

public class NetherHandler {
    private static final List<NetherHandler> recipes = new ArrayList<NetherHandler>();
    private final ItemStack input;
    private final ItemStack output;
    private final double need;

    public NetherHandler(ItemStack input, ItemStack output, double need) {
        this.input = input;
        this.output = output;
        this.need = need;
    }

    public static List<NetherHandler> getRecipes() {
        if (recipes.isEmpty()) {
            NetherHandler.initRecipes();
        }
        return recipes;
    }

    public static NetherHandler addRecipe(ItemStack input, ItemStack output, double need) {
        NetherHandler recipe = new NetherHandler(input, output, need);
        if (recipes.contains(recipe)) {
            return null;
        }
        recipes.add(recipe);
        return recipe;
    }

    public static NetherHandler getRecipe(ItemStack is) {
        if (is == null || is.m_41619_()) {
            return null;
        }
        for (NetherHandler recipe : recipes) {
            if (!recipe.matchesInput(is)) continue;
            return recipe;
        }
        return null;
    }

    public static void initRecipes() {
        for (BaseMachineRecipe container : Recipes.recipes.getRecipeList("nethercollector")) {
            NetherHandler.addRecipe(container.input.getInputs().get(0).getInputs().get(0), container.getOutput().items.get(0), container.getOutput().metadata.m_128459_("need"));
        }
    }

    public double getNeed() {
        return this.need;
    }

    public ItemStack getInput() {
        return this.input;
    }

    public ItemStack getOutput() {
        return this.output.m_41777_();
    }

    public boolean matchesInput(ItemStack is) {
        return true;
    }
}

