/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.inventory;

import com.denfop.api.container.CustomWorldContainer;
import com.denfop.api.widget.ITypeSlot;
import com.denfop.recipe.IInputItemStack;
import com.denfop.utils.ModUtils;
import java.util.AbstractList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class Inventory
extends AbstractList<ItemStack>
implements ITypeSlot,
Container {
    public CustomWorldContainer base;
    protected TypeItemSlot typeItemSlot;
    protected NonNullList<ItemStack> contents;
    protected int stackSizeLimit;

    public Inventory(CustomWorldContainer base, TypeItemSlot typeItemSlot, int count) {
        this.contents = NonNullList.m_122780_((int)count, (Object)ItemStack.f_41583_);
        this.base = base;
        this.typeItemSlot = typeItemSlot;
        this.stackSizeLimit = 64;
        base.addInventorySlot(this);
    }

    public Inventory(int count) {
        this.contents = NonNullList.m_122780_((int)count, (Object)ItemStack.f_41583_);
        this.base = null;
        this.typeItemSlot = null;
    }

    @Override
    public void clear() {
        this.contents = NonNullList.m_122780_((int)this.size(), (Object)ItemStack.f_41583_);
        this.stackSizeLimit = 64;
    }

    public boolean acceptAllOrIndex() {
        return true;
    }

    public TypeItemSlot getTypeItemSlot() {
        return this.typeItemSlot;
    }

    public void setTypeItemSlot(TypeItemSlot typeItemSlot) {
        this.typeItemSlot = typeItemSlot;
    }

    public void readFromNbt(CompoundTag nbt) {
        this.clear();
        ContainerHelper.m_18980_((CompoundTag)nbt, this.contents);
        this.m_6596_();
    }

    public CompoundTag writeToNbt(CompoundTag nbt) {
        ContainerHelper.m_18973_((CompoundTag)nbt, this.contents);
        return nbt;
    }

    @Override
    public boolean addAll(List<ItemStack> stacks) {
        boolean added = false;
        for (ItemStack stack : stacks) {
            added = added || this.add(stack);
        }
        return added;
    }

    @Override
    public boolean add(ItemStack stack) {
        if (stack == null) {
            throw new NullPointerException("null ItemStack");
        }
        return this.add(Collections.singletonList(stack), false);
    }

    public int addExperimental(ItemStack stack) {
        if (stack == null) {
            throw new NullPointerException("null ItemStack");
        }
        return this.addExperimental(stack, false);
    }

    public int addExperimental(ItemStack stack, boolean simulate) {
        if (stack != null && !stack.m_41619_()) {
            int count = stack.m_41613_();
            int minSlot = this.size();
            for (int i = 0; i < this.size(); ++i) {
                ItemStack stack1 = this.get(i);
                if (stack1.m_41619_()) {
                    if (i >= minSlot) continue;
                    minSlot = i;
                    continue;
                }
                if (stack1.m_41720_() != stack.m_41720_()) continue;
                if (stack1.m_41613_() + count <= stack.m_41741_()) {
                    if (stack.m_41783_() == null && stack1.m_41783_() == null) {
                        if (!simulate) {
                            stack1.m_41769_(stack.m_41613_());
                        }
                        return 0;
                    }
                    if (!ModUtils.checkNbtEquality(stack.m_41783_(), this.get(i).m_41783_())) continue;
                    if (!simulate) {
                        stack1.m_41769_(count);
                    }
                    return 0;
                }
                int maxFill = stack1.m_41741_() - stack1.m_41613_();
                if (maxFill == 0) continue;
                maxFill = Math.min(count, maxFill);
                count -= maxFill;
                stack1.m_41769_(maxFill);
            }
            if (count != 0) {
                if (minSlot != this.size()) {
                    if (!simulate) {
                        this.set(minSlot, ModUtils.setSize(stack, count));
                    }
                    return 0;
                }
                return count;
            }
            return count;
        }
        return 0;
    }

    public boolean canAdd(List<ItemStack> stacks) {
        boolean can = true;
        for (ItemStack stack : stacks) {
            can = can && this.canAdd(stack);
        }
        return can;
    }

    public boolean canAdd(ItemStack stack) {
        if (stack == null) {
            throw new NullPointerException("null ItemStack");
        }
        return this.add(Collections.singletonList(stack), true);
    }

    public boolean add(List<ItemStack> stacks, boolean simulate) {
        if (stacks != null && !stacks.isEmpty()) {
            for (ItemStack stack : stacks) {
                int minSlot = this.size();
                for (int i = 0; i < this.size(); ++i) {
                    if (this.get(i).m_41619_()) {
                        if (i >= minSlot) continue;
                        minSlot = i;
                        continue;
                    }
                    if (this.get(i).m_41720_() != stack.m_41720_() || this.get(i).m_41613_() + stack.m_41613_() > stack.m_41741_()) continue;
                    if (stack.m_41783_() == null && this.get(i).m_41783_() == null) {
                        if (!simulate) {
                            this.get(i).m_41769_(stack.m_41613_());
                        }
                        return true;
                    }
                    if (!ModUtils.checkNbtEquality(stack.m_41783_(), this.get(i).m_41783_())) continue;
                    if (!simulate) {
                        this.get(i).m_41769_(stack.m_41613_());
                    }
                    return true;
                }
                if (minSlot == this.size()) continue;
                if (!simulate) {
                    this.set(minSlot, stack.m_41777_());
                }
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public int size() {
        return this.contents.size();
    }

    public int m_6643_() {
        return this.size();
    }

    public boolean m_7983_() {
        for (ItemStack stack : this.contents) {
            if (ModUtils.isEmpty(stack)) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int pSlot) {
        return this.get(pSlot);
    }

    public ItemStack m_7407_(int pSlot, int amount) {
        ItemStack stack = this.m_8020_(pSlot);
        if (ModUtils.isEmpty(stack)) {
            return ModUtils.emptyStack;
        }
        if (amount >= ModUtils.getSize(stack)) {
            this.set(pSlot, ModUtils.emptyStack);
            return stack;
        }
        if (amount != 0) {
            if (amount < 0) {
                int space = Math.min(this.getStackSizeLimit(), stack.m_41741_()) - ModUtils.getSize(stack);
                amount = Math.max(amount, -space);
            }
            this.set(pSlot, ModUtils.decSize(stack, amount));
        }
        ItemStack ret = stack.m_41777_();
        ret = ModUtils.setSize(ret, amount);
        return ret;
    }

    public ItemStack m_8016_(int pSlot) {
        ItemStack stack = this.get(pSlot);
        this.contents.set(pSlot, (Object)ItemStack.f_41583_);
        return stack;
    }

    public void m_6836_(int pSlot, ItemStack pStack) {
        this.set(pSlot, pStack);
    }

    public boolean m_6542_(Player pPlayer) {
        return true;
    }

    public void m_6211_() {
        this.clear();
    }

    @Override
    public ItemStack get(int index) {
        return (ItemStack)this.contents.get(index % this.size());
    }

    public void m_6596_() {
    }

    public boolean m_7013_(int index, ItemStack stack) {
        return true;
    }

    public boolean canInput() {
        return this.typeItemSlot == TypeItemSlot.INPUT || this.typeItemSlot == TypeItemSlot.INPUT_OUTPUT;
    }

    public boolean canOutput() {
        return this.typeItemSlot == TypeItemSlot.OUTPUT || this.typeItemSlot == TypeItemSlot.INPUT_OUTPUT;
    }

    public int getStackSizeLimit() {
        return this.stackSizeLimit;
    }

    public void setStackSizeLimit(int stackSizeLimit) {
        this.stackSizeLimit = stackSizeLimit;
    }

    @Override
    public ItemStack set(int i, ItemStack empty) {
        this.contents.set(i, (Object)empty);
        this.m_6596_();
        return empty;
    }

    public boolean canShift() {
        return true;
    }

    public void update() {
    }

    public boolean hasItemList() {
        return false;
    }

    public List<IInputItemStack> getStacks(int index) {
        return Collections.emptyList();
    }

    public static enum TypeItemSlot {
        INPUT,
        OUTPUT,
        INPUT_OUTPUT,
        NONE;


        public boolean isInput() {
            return this == INPUT || this == INPUT_OUTPUT;
        }

        public boolean isOutput() {
            return this == OUTPUT || this == INPUT_OUTPUT;
        }
    }
}

