/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items;

import com.denfop.IUCore;
import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseMachineRecipe;
import com.denfop.api.recipe.IBaseRecipe;
import com.denfop.api.recipe.IRecipeInputStack;
import com.denfop.api.recipe.RecipeArrayList;
import com.denfop.api.recipe.RecipeInputStack;
import com.denfop.items.IProperties;
import com.denfop.items.bags.BagsDescription;
import com.denfop.recipe.IInputItemStack;
import com.denfop.tabs.IItemTab;
import com.denfop.utils.Keyboard;
import com.denfop.utils.ModUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemRecipeSchedule
extends Item
implements IItemTab,
IProperties {
    private final String name;

    public ItemRecipeSchedule() {
        super(new Item.Properties().m_41487_(1).setNoRepair());
        this.name = "recipe_schedule";
        IUCore.proxy.addProperties(this);
    }

    @Override
    public String[] properties() {
        return new String[]{"mode"};
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public float getItemProperty(ItemStack itemStack, ClientLevel level, LivingEntity entity, int p174679, String property) {
        return ModUtils.nbt(itemStack).m_128471_("mode") ? 1.0f : 0.0f;
    }

    @Override
    public CreativeModeTab getItemCategory() {
        return IUCore.ItemTab;
    }

    public List<ItemStack> getItems(ItemStack stack) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        CompoundTag nbt = ModUtils.nbt(stack);
        for (int i = 0; i < 9; ++i) {
            CompoundTag tag = nbt.m_128469_("recipe_" + i);
            ItemStack stack1 = ItemStack.m_41712_((CompoundTag)tag);
            if (stack1.m_41619_()) continue;
            list.add(stack1);
        }
        return list;
    }

    public RecipeArrayList<IRecipeInputStack> getInputs(IBaseRecipe baseRecipe, ItemStack stack) {
        CompoundTag nbt = ModUtils.nbt(stack);
        List<ItemStack> items = this.getItems(stack);
        List<BaseMachineRecipe> recipe_list = Recipes.recipes.getRecipeList(baseRecipe.getName());
        if (nbt.m_128471_("mode")) {
            if (items.isEmpty()) {
                return new RecipeArrayList<IRecipeInputStack>();
            }
            RecipeArrayList<IRecipeInputStack> recipeArrayList = new RecipeArrayList<IRecipeInputStack>();
            for (BaseMachineRecipe baseMachineRecipe : recipe_list) {
                boolean find = false;
                block1: for (ItemStack output_schedule : items) {
                    for (ItemStack output : baseMachineRecipe.output.items) {
                        if (!output.m_150930_(output_schedule.m_41720_())) continue;
                        find = true;
                        break block1;
                    }
                }
                if (!find) continue;
                baseMachineRecipe.input.getInputs().forEach(iInputItemStack -> recipeArrayList.add(new RecipeInputStack((IInputItemStack)iInputItemStack)));
            }
            return recipeArrayList;
        }
        if (items.isEmpty()) {
            return Recipes.recipes.getMap_recipe_managers_itemStack(baseRecipe.getName());
        }
        RecipeArrayList<IRecipeInputStack> recipeArrayList = new RecipeArrayList<IRecipeInputStack>();
        for (BaseMachineRecipe baseMachineRecipe : recipe_list) {
            boolean find = false;
            block4: for (ItemStack output_schedule : items) {
                for (ItemStack output : baseMachineRecipe.output.items) {
                    if (output.m_150930_(output_schedule.m_41720_())) continue;
                    find = true;
                    break block4;
                }
            }
            if (!find) continue;
            baseMachineRecipe.input.getInputs().forEach(iInputItemStack -> recipeArrayList.add(new RecipeInputStack((IInputItemStack)iInputItemStack)));
        }
        return recipeArrayList;
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        if (!Keyboard.isKeyDown(340)) {
            tooltip.add((Component)Component.m_237115_((String)"press.lshift"));
        } else {
            CompoundTag nbt = stack.m_41784_();
            ArrayList<BagsDescription> list = new ArrayList<BagsDescription>();
            for (int i = 0; i < 9; ++i) {
                ItemStack stack1;
                String key = "recipe_" + i;
                if (!nbt.m_128441_(key) || (stack1 = ItemStack.m_41712_((CompoundTag)nbt.m_128469_(key))).m_41619_()) continue;
                list.add(new BagsDescription(stack1));
            }
            for (BagsDescription description : list) {
                tooltip.add((Component)Component.m_237113_((String)(String.valueOf(ChatFormatting.GREEN) + description.getStack().m_41786_().getString())));
            }
        }
    }
}

