/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.armour;

import com.denfop.IUCore;
import com.denfop.api.item.energy.EnergyItem;
import com.denfop.api.item.upgrade.EnumUpgrades;
import com.denfop.api.item.upgrade.UpgradeItem;
import com.denfop.api.item.upgrade.UpgradeSystem;
import com.denfop.api.item.upgrade.event.EventItemLoad;
import com.denfop.items.EnumInfoUpgradeModules;
import com.denfop.items.armour.ISpecialArmor;
import com.denfop.items.armour.ItemArmorEnergy;
import com.denfop.potion.IUPotion;
import com.denfop.utils.ElectricItem;
import com.denfop.utils.KeyboardClient;
import com.denfop.utils.Localization;
import com.denfop.utils.ModUtils;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.Nullable;

public class ItemSolarPanelHelmet
extends ItemArmorEnergy
implements EnergyItem,
ISpecialArmor,
UpgradeItem {
    protected static final Map<MobEffect, Integer> potionRemovalCost = new HashMap<MobEffect, Integer>();
    private final int solarType;
    private final String name;
    private double maxCharge;
    private double transferLimit;
    private int tier;
    private double genDay;
    private double genNight;
    private int energyPerDamage;
    private double damageAbsorptionRatio;
    private boolean sunIsUp;
    private boolean skyIsVisible;
    private boolean ret = false;
    private double storage;
    private double maxStorage;

    public ItemSolarPanelHelmet(int type, String name) {
        super("", ArmorItem.Type.HELMET, type == 1 ? 1000000.0 : (type == 2 ? 1.0E7 : (type == 3 ? 10000.0 : 1.0E8)), type == 1 ? 3000.0 : (type == 2 ? 10000.0 : (type == 3 ? 10000.0 : 38000.0)), type == 1 ? 1 : (type == 2 ? 2 : (type == 3 ? 3 : (type == 4 ? 5 : 7))));
        this.solarType = type;
        this.name = name;
        this.transferLimit = 3000.0;
        this.tier = 1;
        if (this.solarType == 1) {
            this.genDay = 5.0;
            this.genNight = this.genDay / 2.0;
            this.maxCharge = 1000000.0;
            this.energyPerDamage = 800;
            this.damageAbsorptionRatio = 0.9;
            this.storage = 0.0;
            this.maxStorage = 1600.0;
        }
        if (this.solarType == 2) {
            this.genDay = 20.0;
            this.genNight = this.genDay / 2.0;
            this.maxCharge = 1.0E7;
            this.transferLimit = 10000.0;
            this.tier = 2;
            this.energyPerDamage = 2000;
            this.damageAbsorptionRatio = 1.0;
            this.storage = 0.0;
            this.maxStorage = 10000.0;
        }
        if (this.solarType == 3) {
            this.genDay = 80.0;
            this.genNight = this.genDay / 2.0;
            this.maxCharge = 1.0E7;
            this.transferLimit = 10000.0;
            this.tier = 3;
            this.energyPerDamage = 2000;
            this.damageAbsorptionRatio = 1.0;
            this.storage = 0.0;
            this.maxStorage = 100000.0;
        }
        if (this.solarType == 4) {
            this.genDay = 1280.0;
            this.genNight = this.genDay / 2.0;
            this.transferLimit = 38000.0;
            this.maxCharge = 1.0E8;
            this.tier = 5;
            this.energyPerDamage = 800;
            this.damageAbsorptionRatio = 0.9;
            this.storage = 0.0;
            this.maxStorage = 2500000.0;
        }
        if (this.solarType == 5) {
            this.genDay = 5120.0;
            this.genNight = this.genDay / 2.0;
            this.transferLimit = 100000.0;
            this.maxCharge = 1.0E8;
            this.tier = 7;
            this.energyPerDamage = 2000;
            this.damageAbsorptionRatio = 1.0;
            this.storage = 0.0;
            this.maxStorage = 5.0E8;
        }
        potionRemovalCost.put(MobEffects.f_19614_, 100);
        potionRemovalCost.put(IUPotion.radiation, 20);
        potionRemovalCost.put(MobEffects.f_19615_, 100);
        potionRemovalCost.put(MobEffects.f_19612_, 200);
        IUCore.runnableListAfterRegisterItem.add(() -> UpgradeSystem.system.addRecipe((Item)this, EnumUpgrades.SOLAR_HELMET.list));
    }

    @Override
    public void fillItemCategory(CreativeModeTab p_41391_, NonNullList<ItemStack> p_41392_) {
        if (this.allowedIn(p_41391_)) {
            ItemStack var4 = new ItemStack((ItemLike)this, 1);
            ElectricItem.manager.charge(var4, 2.147483647E9, Integer.MAX_VALUE, true, false);
            p_41392_.add((Object)var4);
            p_41392_.add((Object)new ItemStack((ItemLike)this, 1));
        }
    }

    public void setDamage(ItemStack stack, int damage) {
        int prev = this.getDamage(stack);
    }

    @Override
    protected String m_41467_() {
        if (this.nameItem == null) {
            StringBuilder pathBuilder = new StringBuilder(Util.m_137492_((String)"iu", (ResourceLocation)BuiltInRegistries.f_257033_.m_7981_((Object)this)));
            String targetString = "industrialupgrade.";
            String replacement = "";
            if (replacement != null) {
                int index = pathBuilder.indexOf(targetString);
                while (index != -1) {
                    pathBuilder.replace(index, index + targetString.length(), replacement);
                    index = pathBuilder.indexOf(targetString, index + replacement.length());
                }
            }
            this.nameItem = "item." + pathBuilder.toString().split("\\.")[2];
        }
        return this.nameItem;
    }

    @Override
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        CompoundTag nbtData = ModUtils.nbt(stack);
        if (!nbtData.m_128461_("mode").isEmpty()) {
            return "industrialupgrade:textures/armor/" + this.name + "_" + nbtData.m_128461_("mode") + ".png";
        }
        return "industrialupgrade:textures/armor/" + this.name + ".png";
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    private double experimental_generating(Level world) {
        double k = 0.0;
        float celestialAngle = (float)world.m_46468_() % 24000.0f / 24000.0f;
        if ((celestialAngle *= 360.0f) <= 90.0f) {
            k = celestialAngle / 90.0f;
        } else if (celestialAngle > 90.0f && celestialAngle < 180.0f) {
            k = 1.0f - (celestialAngle -= 90.0f) / 90.0f;
        } else if (celestialAngle > 180.0f && celestialAngle < 270.0f) {
            k = (celestialAngle -= 180.0f) / 90.0f;
        } else if (celestialAngle > 270.0f && celestialAngle < 360.0f) {
            k = 1.0f - (celestialAngle -= 270.0f) / 90.0f;
        }
        return k;
    }

    public void onArmorTick(@Nonnull ItemStack itemStack, Level worldObj, @Nonnull Player player) {
        int repaired;
        if (worldObj.f_46443_) {
            return;
        }
        this.gainFuel(player);
        CompoundTag nbtData = ModUtils.nbt(itemStack);
        int resistance = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.RESISTANCE, itemStack) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.RESISTANCE, (ItemStack)itemStack).number : 0;
        int n = repaired = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.REPAIRED, itemStack) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.REPAIRED, (ItemStack)itemStack).number : 0;
        if (UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.INVISIBILITY, itemStack)) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19609_, 300));
        }
        boolean Nightvision = nbtData.m_128471_("Nightvision");
        byte toggleTimer = nbtData.m_128445_("toggleTimer");
        if (IUCore.keyboard.isArmorKey(player) && toggleTimer == 0) {
            toggleTimer = 10;
            boolean bl = Nightvision = !Nightvision;
            if (!player.m_9236_().m_5776_()) {
                nbtData.m_128379_("Nightvision", Nightvision);
                if (Nightvision) {
                    IUCore.proxy.messagePlayer(player, "Nightvision enabled.");
                } else {
                    IUCore.proxy.messagePlayer(player, "Nightvision disabled.");
                }
            }
        }
        if (!player.m_9236_().m_5776_() && toggleTimer > 0) {
            toggleTimer = (byte)(toggleTimer - 1);
            nbtData.m_128344_("toggleTimer", toggleTimer);
        }
        if (Nightvision && !player.m_9236_().m_5776_() && ElectricItem.manager.use(itemStack, 1.0, (LivingEntity)player)) {
            boolean without;
            int x = Mth.m_14107_((double)player.m_20185_());
            int z = Mth.m_14107_((double)player.m_20189_());
            int y = Mth.m_14107_((double)player.m_20186_());
            int skylight = player.m_9236_().m_46803_(new BlockPos(x, y, z));
            boolean with = this.solarType == 1;
            boolean bl = without = this.solarType == 2 || this.solarType == 3;
            if (without || with) {
                if (skylight > 8) {
                    IUCore.proxy.removePotion((LivingEntity)player, MobEffects.f_19611_);
                    if (with) {
                        player.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 100, 0, true, true));
                    }
                } else {
                    if (with) {
                        IUCore.proxy.removePotion((LivingEntity)player, MobEffects.f_19610_);
                    }
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19611_, 300, 0));
                }
            } else {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19611_, 300, 0));
            }
            this.ret = true;
        }
        if (repaired != 0 && worldObj.m_8044_() % 80L == 0L) {
            ElectricItem.manager.charge(itemStack, this.getMaxEnergy(itemStack) * 1.0E-5 * (double)repaired, Integer.MAX_VALUE, true, false);
        }
        if (resistance != 0) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 300, resistance));
        }
        int genday = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.GENDAY, itemStack) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.GENDAY, (ItemStack)itemStack).number : 0;
        int gennight = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.GENNIGHT, itemStack) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.GENNIGHT, (ItemStack)itemStack).number : 0;
        int storage = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.STORAGE, itemStack) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.STORAGE, (ItemStack)itemStack).number : 0;
        double k = this.experimental_generating(worldObj);
        if (this.sunIsUp && this.skyIsVisible) {
            this.storage = nbtData.m_128459_("storage");
            this.storage += (this.genDay + this.genDay * 0.05 * (double)genday) * k;
            nbtData.m_128347_("storage", this.storage);
        }
        if (this.skyIsVisible) {
            this.storage = nbtData.m_128459_("storage");
            this.storage += (this.genNight + this.genNight * 0.05 * (double)gennight) * k;
            nbtData.m_128347_("storage", this.storage);
        }
        if (nbtData.m_128459_("storage") >= this.maxStorage + this.maxStorage * 0.05 * (double)storage) {
            nbtData.m_128347_("storage", this.maxStorage + this.maxStorage * 0.05 * (double)storage);
        }
        if (nbtData.m_128459_("storage") < 0.0) {
            nbtData.m_128347_("storage", 0.0);
        }
        for (MobEffectInstance effect : new LinkedList(player.m_21220_())) {
            Integer cost = potionRemovalCost.get(effect.m_19544_());
            if (cost == null || !ElectricItem.manager.canUse(itemStack, (cost = Integer.valueOf(cost * (effect.m_19564_() + 1))).intValue())) continue;
            ElectricItem.manager.use(itemStack, cost.intValue(), null);
            IUCore.proxy.removePotion((LivingEntity)player, effect.m_19544_());
            this.ret = true;
        }
        double tempstorage = nbtData.m_128459_("storage");
        if (tempstorage > 0.0) {
            double sentPacket;
            double energyLeft = tempstorage;
            for (int i = 0; i < player.m_150109_().f_35975_.size(); ++i) {
                if (energyLeft > 0.0) {
                    if (((ItemStack)player.m_150109_().f_35975_.get(i)).m_41619_() || !(((ItemStack)player.m_150109_().f_35975_.get(i)).m_41720_() instanceof EnergyItem) || !((sentPacket = ElectricItem.manager.charge((ItemStack)player.m_150109_().f_35975_.get(i), energyLeft, Integer.MAX_VALUE, true, false)) > 0.0)) continue;
                    nbtData.m_128347_("storage", energyLeft -= sentPacket);
                    this.ret = true;
                    continue;
                }
                return;
            }
            for (int j = 0; j < player.m_150109_().f_35974_.size(); ++j) {
                if (energyLeft > 0.0) {
                    if (((ItemStack)player.m_150109_().f_35974_.get(j)).m_41619_() || !(((ItemStack)player.m_150109_().f_35974_.get(j)).m_41720_() instanceof EnergyItem) || !((sentPacket = ElectricItem.manager.charge((ItemStack)player.m_150109_().f_35974_.get(j), energyLeft, Integer.MAX_VALUE, true, false)) > 0.0)) continue;
                    nbtData.m_128347_("storage", energyLeft -= sentPacket);
                    this.ret = true;
                    continue;
                }
                return;
            }
        }
        if (this.ret) {
            player.f_36096_.m_38946_();
        }
        if (UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.NIGTHVISION, itemStack)) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19611_, 300));
        }
        if (UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.WATER, itemStack)) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19608_, 300));
        }
    }

    public void gainFuel(Player player) {
        if (player.m_9236_().m_46467_() % 128L == 0L) {
            this.updateVisibility(player);
        }
    }

    public void updateVisibility(Player player) {
        BlockPos pos = new BlockPos((int)player.m_20185_(), (int)player.m_20186_(), (int)player.m_20189_());
        boolean noSunWorld = player.m_9236_().m_46472_() != Level.f_46428_;
        boolean rainWeather = player.m_9236_().m_46471_() || player.m_9236_().m_46470_();
        this.sunIsUp = player.m_9236_().m_46461_() && !rainWeather;
        this.skyIsVisible = player.m_9236_().m_45527_(pos.m_7494_()) && player.m_9236_().m_8055_(pos.m_7494_()).m_284242_((BlockGetter)player.m_9236_(), pos.m_7494_()) == MapColor.f_283808_ && !noSunWorld;
    }

    @Override
    public ISpecialArmor.ArmorProperties getProperties(LivingEntity player, @Nonnull ItemStack armor, DamageSource source, double damage, int slot) {
        double absorptionRatio = this.getBaseAbsorptionRatio() * this.getDamageAbsorptionRatio();
        int protect = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.PROTECTION, armor) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.PROTECTION, (ItemStack)armor).number : 0;
        int energyPerDamage = (int)((double)this.getEnergyPerDamage() - (double)this.getEnergyPerDamage() * 0.2 * (double)protect);
        int damageLimit = (int)(energyPerDamage > 0 ? 25.0 * ElectricItem.manager.getCharge(armor) / (double)energyPerDamage : 0.0);
        return new ISpecialArmor.ArmorProperties(0, absorptionRatio, damageLimit);
    }

    @Override
    public int getArmorDisplay(Player player, @Nonnull ItemStack armor, int slot) {
        if (ElectricItem.manager.getCharge(armor) >= (double)this.getEnergyPerDamage()) {
            return (int)Math.round(20.0 * this.getBaseAbsorptionRatio() * this.getDamageAbsorptionRatio());
        }
        return 0;
    }

    @Override
    public void damageArmor(LivingEntity entity, @Nonnull ItemStack stack, DamageSource source, float damage, int slot) {
        int protect = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.PROTECTION, stack) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.PROTECTION, (ItemStack)stack).number : 0;
        ElectricItem.manager.discharge(stack, (double)damage * ((double)this.getEnergyPerDamage() - (double)this.getEnergyPerDamage() * 0.2 * (double)protect), Integer.MAX_VALUE, true, false, false);
    }

    @Override
    public int getEnergyPerDamage() {
        return this.energyPerDamage;
    }

    @Override
    public double getDamageAbsorptionRatio() {
        return this.damageAbsorptionRatio;
    }

    @Override
    public boolean canProvideEnergy(ItemStack itemStack) {
        return false;
    }

    @Override
    public double getMaxEnergy(ItemStack itemStack) {
        return this.maxCharge;
    }

    @Override
    public short getTierItem(ItemStack itemStack) {
        return (short)this.tier;
    }

    @Override
    public double getTransferEnergy(ItemStack itemStack) {
        return this.transferLimit;
    }

    public void m_7373_(ItemStack itemStack, @Nullable Level p_41422_, List<Component> info, TooltipFlag p_41424_) {
        boolean auto;
        super.m_7373_(itemStack, p_41422_, info, p_41424_);
        CompoundTag nbtData1 = ModUtils.nbt(itemStack);
        info.add((Component)Component.m_237113_((String)(Localization.translate("iu.storage.helmet") + " " + ModUtils.getString(nbtData1.m_128459_("storage")) + " EF")));
        boolean with = this.solarType == 1;
        boolean without = this.solarType == 2 || this.solarType == 3;
        boolean bl = auto = this.solarType > 3;
        if (with || without || auto) {
            info.add((Component)Component.m_237113_((String)(Localization.translate("iu.special_armor_nightvision") + KeyboardClient.armormode.getKey().m_84875_().getString())));
            if (with) {
                info.add((Component)Component.m_237113_((String)Localization.translate("iu.special_armor_nightvision_1")));
            }
            if (without) {
                info.add((Component)Component.m_237113_((String)Localization.translate("iu.special_armor_nightvision_2")));
            }
            if (auto) {
                info.add((Component)Component.m_237113_((String)Localization.translate("iu.special_armor_nightvision_3")));
            }
        }
    }

    public void m_6883_(ItemStack itemStack, Level world, Entity p_41406_, int p_41407_, boolean p_41408_) {
        CompoundTag nbt = ModUtils.nbt(itemStack);
        if (!UpgradeSystem.system.hasInMap(itemStack)) {
            nbt.m_128379_("hasID", false);
            MinecraftForge.EVENT_BUS.post((Event)new EventItemLoad(world, this, itemStack));
        }
    }

    @Override
    public List<EnumInfoUpgradeModules> getUpgradeModules() {
        return EnumUpgrades.SOLAR_HELMET.list;
    }
}

