/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.bags;

import com.denfop.IUCore;
import com.denfop.api.container.CustomWorldContainer;
import com.denfop.containermenu.ContainerMenuLeadBox;
import com.denfop.items.IItemStackInventory;
import com.denfop.items.bags.ItemStackLeadBox;
import com.denfop.items.reactors.IRadioactiveItemType;
import com.denfop.items.reactors.ItemBaseRod;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.potion.IUPotion;
import com.denfop.tabs.IItemTab;
import com.denfop.utils.Localization;
import com.denfop.utils.ModUtils;
import io.netty.buffer.ByteBuf;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;

public class ItemLeadBox
extends Item
implements IItemStackInventory,
IItemTab {
    private final int slots;
    private String nameItem;

    public ItemLeadBox() {
        super(new Item.Properties().m_41487_(1));
        this.slots = 27;
    }

    @Override
    public void fillItemCategory(CreativeModeTab p_41391_, NonNullList<ItemStack> p_41392_) {
        if (this.allowedIn(p_41391_)) {
            p_41392_.add((Object)new ItemStack((ItemLike)this, 1));
        }
    }

    @Override
    public CreativeModeTab getItemCategory() {
        return IUCore.EnergyTab;
    }

    protected String m_41467_() {
        if (this.nameItem == null) {
            StringBuilder pathBuilder = new StringBuilder(Util.m_137492_((String)"iu", (ResourceLocation)BuiltInRegistries.f_257033_.m_7981_((Object)this)));
            String targetString = "industrialupgrade.";
            String replacement = "";
            if (replacement != null) {
                int index = pathBuilder.indexOf(targetString);
                while (index != -1) {
                    pathBuilder.replace(index, index + targetString.length(), replacement);
                    index = pathBuilder.indexOf(targetString, index + replacement.length());
                }
            }
            this.nameItem = "item." + pathBuilder.toString().split("\\.")[2];
        }
        return this.nameItem;
    }

    @Override
    public CustomWorldContainer getInventory(Player player, ItemStack stack) {
        return new ItemStackLeadBox(player, stack, this.slots);
    }

    public void save(ItemStack stack, Player player) {
        CompoundTag nbt = ModUtils.nbt(stack);
        nbt.m_128379_("open", true);
        nbt.m_128405_("slot_inventory", player.m_150109_().f_35977_);
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int itemSlot, boolean isSelected) {
        ItemStackLeadBox toolbox;
        int slotId;
        super.m_6883_(stack, world, entity, itemSlot, isSelected);
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        CompoundTag nbt = stack.m_41784_();
        if (nbt.m_128471_("open") && (slotId = nbt.m_128451_("slot_inventory")) != itemSlot && !world.f_46443_ && !stack.m_41619_() && player.f_36096_ instanceof ContainerMenuLeadBox && (toolbox = (ItemStackLeadBox)((ContainerMenuLeadBox)player.f_36096_).base).isThisContainer(stack)) {
            toolbox.saveAsThrown(stack);
            player.m_6915_();
            nbt.m_128379_("open", false);
        }
        if (world.m_46467_() % 40L == 0L && !(player.f_36096_ instanceof ContainerMenuLeadBox)) {
            boolean rod = nbt.m_128471_("rod");
            for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
                ItemStackLeadBox box;
                ItemStack currentStack = player.m_150109_().m_8020_(i);
                if (!(currentStack.m_41720_() instanceof IRadioactiveItemType) || !rod && currentStack.m_41720_() instanceof ItemBaseRod || !(box = (ItemStackLeadBox)this.getInventory(player, stack)).canAdd(currentStack)) continue;
                box.add(currentStack);
                player.m_21195_((MobEffect)IUPotion.radiation);
                player.m_150109_().m_6836_(i, ItemStack.f_41583_);
                player.f_36096_.m_38946_();
                box.m_6596_();
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"iu.radiationbox"));
        CompoundTag nbt = stack.m_41784_();
        boolean rod = nbt.m_128471_("rod");
        tooltip.add((Component)Component.m_237115_((String)"message.text.mode_no_instrument").m_130946_(": ").m_7220_((Component)(rod ? Component.m_237115_((String)"message.leadbox.enable") : Component.m_237115_((String)"message.leadbox.disable"))));
        if (!Screen.m_96638_()) {
            tooltip.add((Component)Component.m_237115_((String)"press.lshift"));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"iu.changemode_key").m_7220_((Component)Component.m_237115_((String)"iu.changemode_rcm1")).m_130946_(" + SHIFT"));
        }
        super.m_7373_(stack, world, tooltip, flag);
    }

    public boolean onDroppedByPlayer(@Nonnull ItemStack stack, @Nonnull Player player) {
        ItemStackLeadBox toolbox;
        if (!player.m_9236_().f_46443_ && !stack.m_41619_() && player.f_36096_ instanceof ContainerMenuLeadBox && (toolbox = (ItemStackLeadBox)((ContainerMenuLeadBox)player.f_36096_).base).isThisContainer(stack)) {
            toolbox.saveAndThrow(stack);
            player.m_6915_();
        }
        return true;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(@Nonnull Level world, @Nonnull Player player, @Nonnull InteractionHand hand) {
        ItemStack stack = ModUtils.get(player, hand);
        if (!world.f_46443_ && !player.m_6144_()) {
            this.save(stack, player);
            CustomPacketBuffer growingBuffer = new CustomPacketBuffer();
            growingBuffer.writeByte(1);
            growingBuffer.flip();
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)this.getInventory(player, player.m_21120_(hand)), buf -> buf.writeBytes((ByteBuf)growingBuffer));
            return InteractionResultHolder.m_19090_((Object)player.m_21120_(hand));
        }
        if (!world.f_46443_ && player.m_6144_()) {
            CompoundTag nbt = ModUtils.nbt(stack);
            boolean rod = !nbt.m_128471_("rod");
            nbt.m_128379_("rod", rod);
            if (rod) {
                IUCore.proxy.messagePlayer(player, String.valueOf(ChatFormatting.GREEN) + Localization.translate("message.text.mode_no_instrument") + ": " + Localization.translate("message.leadbox.enable"));
            } else {
                IUCore.proxy.messagePlayer(player, String.valueOf(ChatFormatting.RED) + Localization.translate("message.text.mode_no_instrument") + ": " + Localization.translate("message.leadbox.disable"));
            }
        }
        return InteractionResultHolder.m_19098_((Object)player.m_21120_(hand));
    }

    public boolean canInsert(Player player, ItemStack stack, ItemStack stack1) {
        ItemStackLeadBox box = (ItemStackLeadBox)this.getInventory(player, stack);
        CompoundTag nbt = ModUtils.nbt(stack);
        boolean rod = nbt.m_128471_("rod");
        if (stack1.m_41720_() instanceof IRadioactiveItemType) {
            if (!rod) {
                return !(stack1.m_41720_() instanceof ItemBaseRod);
            }
            return box.canAdd(stack1);
        }
        return false;
    }

    public void insert(Player player, ItemStack stack, ItemStack stack1) {
        ItemStackLeadBox box = (ItemStackLeadBox)this.getInventory(player, stack);
        box.add(stack1);
        box.m_6596_();
    }
}

