/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.bee;

import com.denfop.api.bee.Bee;
import com.denfop.api.bee.genetics.EnumGenetic;
import com.denfop.api.bee.genetics.Genome;
import com.denfop.api.pollution.component.LevelPollution;
import com.denfop.api.pollution.radiation.EnumLevelRadiation;
import com.denfop.containermenu.ContainerMenuBase;
import com.denfop.containermenu.ContainerMenuBeeAnalyzer;
import com.denfop.inventory.Inventory;
import com.denfop.items.ItemStackInventory;
import com.denfop.items.bee.ItemJarBees;
import com.denfop.screen.ScreenBeeAnalyzer;
import com.denfop.screen.ScreenIndustrialUpgrade;
import com.denfop.utils.ModUtils;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemStackBeeAnalyzer
extends ItemStackInventory {
    public final int inventorySize;
    public final ItemStack itemStack1;
    public Genome genome;
    public Bee crop;
    public int weatherGenome = 0;
    public double pestGenome = 1.0;
    public double birthRateGenome = 1.0;
    public double radiusGenome = 1.0;
    public double populationGenome = 1.0;
    public double foodGenome = 1.0;
    public double jellyGenome = 1.0;
    public double productGenome = 1.0;
    public double hardeningGenome = 1.0;
    public double swarmGenome = 1.0;
    public double mortalityGenome = 1.0;
    public boolean sunGenome = false;
    public boolean nightGenome = false;
    public int genomeResistance = 0;
    public int genomeAdaptive = 0;
    public LevelPollution airPollution = LevelPollution.LOW;
    public LevelPollution soilPollution = LevelPollution.LOW;
    public EnumLevelRadiation radiationPollution = EnumLevelRadiation.LOW;

    public ItemStackBeeAnalyzer(Player player, ItemStack stack, int inventorySize) {
        super(player, stack, inventorySize);
        this.inventorySize = inventorySize;
        this.itemStack1 = stack;
    }

    @Override
    public boolean isItemValidForSlot(int i, ItemStack itemstack) {
        return itemstack.m_41720_() instanceof ItemJarBees;
    }

    public void set() {
        this.reset();
        if (this.genome == null) {
            return;
        }
        if (this.genome.hasGenome(EnumGenetic.WEATHER)) {
            this.weatherGenome = this.genome.getLevelGenome(EnumGenetic.WEATHER, Integer.class);
        }
        if (this.genome.hasGenome(EnumGenetic.PEST)) {
            this.pestGenome = this.genome.getLevelGenome(EnumGenetic.PEST, Double.class);
        }
        if (this.genome.hasGenome(EnumGenetic.BIRTH)) {
            this.birthRateGenome = this.genome.getLevelGenome(EnumGenetic.BIRTH, Double.class);
        }
        if (this.genome.hasGenome(EnumGenetic.RADIUS)) {
            this.radiusGenome = this.genome.getLevelGenome(EnumGenetic.RADIUS, Double.class);
        }
        if (this.genome.hasGenome(EnumGenetic.POPULATION)) {
            this.populationGenome = this.genome.getLevelGenome(EnumGenetic.POPULATION, Double.class);
        }
        if (this.genome.hasGenome(EnumGenetic.FOOD)) {
            this.foodGenome = this.genome.getLevelGenome(EnumGenetic.FOOD, Double.class);
        }
        if (this.genome.hasGenome(EnumGenetic.JELLY)) {
            this.jellyGenome = this.genome.getLevelGenome(EnumGenetic.JELLY, Double.class);
        }
        if (this.genome.hasGenome(EnumGenetic.PRODUCT)) {
            this.productGenome = this.genome.getLevelGenome(EnumGenetic.PRODUCT, Double.class);
        }
        if (this.genome.hasGenome(EnumGenetic.HARDENING)) {
            this.hardeningGenome = this.genome.getLevelGenome(EnumGenetic.HARDENING, Double.class);
        }
        if (this.genome.hasGenome(EnumGenetic.SWARM)) {
            this.swarmGenome = this.genome.getLevelGenome(EnumGenetic.SWARM, Double.class);
        }
        if (this.genome.hasGenome(EnumGenetic.MORTALITY_RATE)) {
            this.mortalityGenome = this.genome.getLevelGenome(EnumGenetic.MORTALITY_RATE, Double.class);
        }
        if (this.genome.hasGenome(EnumGenetic.SUN)) {
            this.sunGenome = this.genome.getLevelGenome(EnumGenetic.SUN, Boolean.class);
        }
        if (this.genome.hasGenome(EnumGenetic.NIGHT)) {
            this.nightGenome = this.genome.getLevelGenome(EnumGenetic.NIGHT, Boolean.class);
        }
        if (this.genome.hasGenome(EnumGenetic.AIR)) {
            this.airPollution = this.genome.getLevelGenome(EnumGenetic.AIR, LevelPollution.class);
        }
        if (this.genome.hasGenome(EnumGenetic.SOIL)) {
            this.soilPollution = this.genome.getLevelGenome(EnumGenetic.SOIL, LevelPollution.class);
        }
        if (this.genome.hasGenome(EnumGenetic.RADIATION)) {
            this.radiationPollution = this.genome.getLevelGenome(EnumGenetic.RADIATION, EnumLevelRadiation.class);
        }
        if (this.genome.hasGenome(EnumGenetic.GENOME_RESISTANCE)) {
            this.genomeResistance = this.genome.getLevelGenome(EnumGenetic.GENOME_RESISTANCE, Integer.class);
        }
        if (this.genome.hasGenome(EnumGenetic.GENOME_ADAPTIVE)) {
            this.genomeAdaptive = this.genome.getLevelGenome(EnumGenetic.GENOME_ADAPTIVE, Integer.class);
        }
    }

    public void reset() {
        this.weatherGenome = 0;
        this.pestGenome = 1.0;
        this.swarmGenome = 1.0;
        this.mortalityGenome = 1.0;
        this.birthRateGenome = 1.0;
        this.radiusGenome = 1.0;
        this.populationGenome = 1.0;
        this.foodGenome = 1.0;
        this.jellyGenome = 1.0;
        this.productGenome = 1.0;
        this.hardeningGenome = 1.0;
        this.sunGenome = false;
        this.nightGenome = false;
        this.genomeResistance = 0;
        this.genomeAdaptive = 0;
        this.airPollution = LevelPollution.LOW;
        this.soilPollution = LevelPollution.LOW;
        this.radiationPollution = EnumLevelRadiation.LOW;
    }

    @Override
    public void save() {
        super.save();
    }

    public void saveAndThrow(ItemStack stack) {
        ListTag contentList = new ListTag();
        for (int i = 0; i < this.inventory.length; ++i) {
            if (ModUtils.isEmpty(this.inventory[i])) continue;
            CompoundTag nbt = new CompoundTag();
            nbt.m_128344_("Slot", (byte)i);
            this.inventory[i].m_41739_(nbt);
            contentList.add((Object)nbt);
        }
        ModUtils.nbt(stack).m_128365_("Items", (Tag)contentList);
        this.clear();
    }

    public ContainerMenuBeeAnalyzer getGuiContainer(Player player) {
        return new ContainerMenuBeeAnalyzer(player, this);
    }

    @OnlyIn(value=Dist.CLIENT)
    public ScreenIndustrialUpgrade<ContainerMenuBase<?>> getGui(Player player, ContainerMenuBase<?> isAdmin) {
        return new ScreenBeeAnalyzer((ContainerMenuBeeAnalyzer)isAdmin, this.itemStack1);
    }

    @Override
    public void addInventorySlot(Inventory var1) {
    }

    public ItemStack get(int index) {
        return this.inventory[index];
    }

    protected void restore(ItemStack[] backup) {
        if (backup.length != this.inventory.length) {
            throw new IllegalArgumentException("invalid array size");
        }
        System.arraycopy(backup, 0, this.inventory, 0, this.inventory.length);
    }

    @Override
    @Nonnull
    public String getName() {
        return "toolbox";
    }

    public boolean hasCustomName() {
        return false;
    }
}

