/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.crop;

import com.denfop.api.crop.Crop;
import com.denfop.api.crop.CropItem;
import com.denfop.api.crop.genetics.Genome;
import com.denfop.containermenu.ContainerMenuAgriculturalAnalyzer;
import com.denfop.containermenu.ContainerMenuBase;
import com.denfop.inventory.Inventory;
import com.denfop.items.ItemStackInventory;
import com.denfop.screen.ScreenAgriculturalAnalyzer;
import com.denfop.screen.ScreenIndustrialUpgrade;
import com.denfop.utils.ModUtils;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemStackAgriculturalAnalyzer
extends ItemStackInventory {
    public final int inventorySize;
    public final ItemStack itemStack1;
    public Genome genome;
    public Crop crop;

    public ItemStackAgriculturalAnalyzer(Player player, ItemStack stack, int inventorySize) {
        super(player, stack, inventorySize);
        this.inventorySize = inventorySize;
        this.itemStack1 = stack;
    }

    @Override
    public boolean isItemValidForSlot(int i, ItemStack itemstack) {
        return itemstack.m_41720_() instanceof CropItem;
    }

    @Override
    public void save() {
        super.save();
    }

    public void saveAndThrow(ItemStack stack) {
        ListTag contentList = new ListTag();
        for (int i = 0; i < this.inventory.length; ++i) {
            if (ModUtils.isEmpty(this.inventory[i])) continue;
            CompoundTag nbt = new CompoundTag();
            nbt.m_128344_("Slot", (byte)i);
            this.inventory[i].m_41739_(nbt);
            contentList.add((Object)nbt);
        }
        ModUtils.nbt(stack).m_128365_("Items", (Tag)contentList);
        this.clear();
    }

    public ContainerMenuAgriculturalAnalyzer getGuiContainer(Player player) {
        return new ContainerMenuAgriculturalAnalyzer(player, this);
    }

    @OnlyIn(value=Dist.CLIENT)
    public ScreenIndustrialUpgrade<ContainerMenuBase<?>> getGui(Player player, ContainerMenuBase<?> isAdmin) {
        return new ScreenAgriculturalAnalyzer((ContainerMenuAgriculturalAnalyzer)isAdmin, this.itemStack1);
    }

    @Override
    public void addInventorySlot(Inventory var1) {
    }

    public ItemStack get(int index) {
        return this.inventory[index];
    }

    protected void restore(ItemStack[] backup) {
        if (backup.length != this.inventory.length) {
            throw new IllegalArgumentException("invalid array size");
        }
        System.arraycopy(backup, 0, this.inventory, 0, this.inventory.length);
    }

    @Override
    @Nonnull
    public String getName() {
        return "toolbox";
    }

    public boolean hasCustomName() {
        return false;
    }

    protected ItemStack[] backup() {
        ItemStack[] ret = new ItemStack[this.inventory.length];
        for (int i = 0; i < this.inventory.length; ++i) {
            ItemStack content = this.inventory[i];
            ret[i] = ModUtils.isEmpty(content) ? ModUtils.emptyStack : content.m_41777_();
        }
        return ret;
    }

    public void put(ItemStack content) {
        this.put(0, content);
    }

    public void put(int index, ItemStack content) {
        if (ModUtils.isEmpty(content)) {
            content = ModUtils.emptyStack;
        }
        this.inventory[index] = content;
        this.save();
    }

    public int getStackSizeLimit() {
        return 64;
    }
}

