/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.energy;

import com.denfop.IUCore;
import com.denfop.IUItem;
import com.denfop.api.blockentity.Wrenchable;
import com.denfop.api.item.energy.EnergyItem;
import com.denfop.api.item.upgrade.EnumUpgrades;
import com.denfop.api.item.upgrade.UpgradeItem;
import com.denfop.api.item.upgrade.UpgradeSystem;
import com.denfop.api.item.upgrade.event.EventItemLoad;
import com.denfop.blockentity.base.BlockEntityInventory;
import com.denfop.blockentity.base.BlockEntityMultiMachine;
import com.denfop.blockentity.base.IManufacturerBlock;
import com.denfop.componets.AbstractComponent;
import com.denfop.items.EnumInfoUpgradeModules;
import com.denfop.items.IProperties;
import com.denfop.items.energy.ItemTreetap;
import com.denfop.proxy.CommonProxy;
import com.denfop.sound.EnumSound;
import com.denfop.tabs.IItemTab;
import com.denfop.utils.ElectricItem;
import com.denfop.utils.ElectricItemManager;
import com.denfop.utils.KeyboardClient;
import com.denfop.utils.Localization;
import com.denfop.utils.ModUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.eventbus.api.Event;

public class ItemGraviTool
extends TieredItem
implements EnergyItem,
UpgradeItem,
IProperties,
IItemTab {
    protected static final double ROTATE = 50.0;
    protected static final double HOE = 50.0;
    protected static final double TAP = 50.0;
    private String nameItem;

    public ItemGraviTool() {
        super((Tier)Tiers.IRON, new Item.Properties().m_41487_(1).setNoRepair());
        IUCore.proxy.addProperties(this);
        IUCore.runnableListAfterRegisterItem.add(() -> UpgradeSystem.system.addRecipe((Item)this, this.getUpgradeModules()));
    }

    public static GraviToolMode readToolMode(ItemStack stack) {
        return GraviToolMode.getFromID(ModUtils.nbt(stack).m_128451_("toolMode"));
    }

    public static GraviToolMode readNextToolMode(ItemStack stack) {
        return GraviToolMode.getFromID(ModUtils.nbt(stack).m_128451_("toolMode") + 1);
    }

    public static void saveToolMode(ItemStack stack, GraviToolMode mode) {
        ModUtils.nbt(stack).m_128405_("toolMode", mode.ordinal());
    }

    public static boolean hasNecessaryPower(ItemStack stack, double usage, Player player) {
        double coef = 1.0 - (UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.ENERGY, stack) ? (double)UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.ENERGY, (ItemStack)stack).number * 0.25 : 0.0);
        return ElectricItem.manager.canUse(stack, usage * coef);
    }

    protected static boolean checkNecessaryPower(ItemStack stack, double usage, Player player) {
        return ItemGraviTool.checkNecessaryPower(stack, usage, player, false);
    }

    protected static boolean checkNecessaryPower(ItemStack stack, double usage, Player player, boolean supressSound) {
        double coef = 1.0 - (UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.ENERGY, stack) ? (double)UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.ENERGY, (ItemStack)stack).number * 0.25 : 0.0);
        if (ElectricItem.manager.use(stack, usage * coef, (LivingEntity)player)) {
            if (supressSound || player.m_9236_().f_46443_) {
                // empty if block
            }
            return true;
        }
        CommonProxy.sendPlayerMessage(player, Localization.translate("message.text.noenergy"));
        return false;
    }

    public static boolean hasToolMode(ItemStack stack) {
        if (!stack.m_41782_()) {
            return false;
        }
        assert (stack.m_41783_() != null);
        return stack.m_41783_().m_128425_("toolMode", 4);
    }

    public boolean m_142522_(ItemStack stack) {
        return true;
    }

    public int m_142159_(ItemStack stack) {
        return ModUtils.convertRGBcolorToInt(33, 91, 199);
    }

    public int m_142158_(ItemStack stack) {
        return 13 - (int)(13.0 * Math.min(Math.max(1.0 - ElectricItem.manager.getCharge(stack) / ElectricItem.manager.getMaxCharge(stack), 0.0), 1.0));
    }

    protected String m_41467_() {
        if (this.nameItem == null) {
            StringBuilder pathBuilder = new StringBuilder(Util.m_137492_((String)"iu", (ResourceLocation)BuiltInRegistries.f_257033_.m_7981_((Object)this)));
            String targetString = "industrialupgrade.";
            String replacement = "";
            if (replacement != null) {
                int index = pathBuilder.indexOf(targetString);
                while (index != -1) {
                    pathBuilder.replace(index, index + targetString.length(), replacement);
                    index = pathBuilder.indexOf(targetString, index + replacement.length());
                }
            }
            this.nameItem = "item.gravitool";
        }
        return this.nameItem;
    }

    @Override
    public String[] properties() {
        return new String[]{"mode"};
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public float getItemProperty(ItemStack itemStack, ClientLevel level, LivingEntity entity, int p174679, String property) {
        return (float)ItemGraviTool.readToolMode(itemStack).ordinal() * 0.25f;
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return ToolActions.DEFAULT_HOE_ACTIONS.contains(toolAction) && ItemGraviTool.readToolMode(stack) == GraviToolMode.HOE;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(@Nonnull Level world, @Nonnull Player player, @Nonnull InteractionHand hand) {
        if (IUCore.keyboard.isChangeKeyDown(player)) {
            ItemStack stack = ModUtils.get(player, hand);
            if (world.f_46443_) {
                player.m_5496_(EnumSound.toolchange.getSoundEvent(), 1.0f, 1.0f);
            } else {
                GraviToolMode mode = ItemGraviTool.readNextToolMode(stack);
                ItemGraviTool.saveToolMode(stack, mode);
                CommonProxy.sendPlayerMessage(player, String.valueOf(mode.colour) + Localization.translate(mode.translationName));
            }
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        return super.m_7203_(world, player, hand);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level world, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flag) {
        GraviToolMode mode = ItemGraviTool.readToolMode(stack);
        tooltip.add((Component)Component.m_237115_((String)"message.text.mode").m_130946_(": " + String.valueOf(mode.colour)).m_7220_((Component)Component.m_237115_((String)mode.translationName)));
        if (!Screen.m_96638_()) {
            tooltip.add((Component)Component.m_237115_((String)"press.lshift"));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"iu.changemode_key").m_130946_(" " + KeyboardClient.changemode.getKey().m_84875_().getString()).m_7220_((Component)Component.m_237115_((String)"iu.changemode_rcm")));
        }
        super.m_7373_(stack, world, tooltip, flag);
    }

    @Nonnull
    public InteractionResult onItemUseFirst(@Nonnull ItemStack stack, @Nonnull UseOnContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        InteractionHand hand = context.m_43724_();
        return switch (ItemGraviTool.readToolMode(stack)) {
            case GraviToolMode.WRENCH -> {
                if (this.onWrenchUse(stack, player, level, pos, context.m_43719_())) {
                    yield InteractionResult.SUCCESS;
                }
                yield InteractionResult.FAIL;
            }
            case GraviToolMode.SCREWDRIVER -> {
                if (this.onScrewdriverUse(stack, player, level, pos)) {
                    yield InteractionResult.SUCCESS;
                }
                yield InteractionResult.FAIL;
            }
            default -> super.onItemUseFirst(stack, context);
        };
    }

    @Nonnull
    public InteractionResult m_6225_(@Nonnull UseOnContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        InteractionHand hand = context.m_43724_();
        ItemStack stack = player.m_21120_(hand);
        BlockHitResult hitResult = new BlockHitResult(context.m_43720_(), context.m_43719_(), pos, context.m_43721_());
        if (player == null) {
            return InteractionResult.PASS;
        }
        switch (ItemGraviTool.readToolMode(stack)) {
            case HOE: {
                return this.onHoeUse(stack, player, level, pos, hitResult.m_82434_()) ? InteractionResult.SUCCESS : InteractionResult.FAIL;
            }
            case TREETAP: {
                return this.onTreeTapUse(stack, player, level, pos, hitResult.m_82434_()) ? InteractionResult.SUCCESS : InteractionResult.FAIL;
            }
            case PURIFIER: {
                BlockEntityInventory base;
                BlockEntity tile = level.m_7702_(pos);
                if (!(tile instanceof BlockEntityInventory) && !(tile instanceof IManufacturerBlock)) {
                    return InteractionResult.PASS;
                }
                double coef = 1.0 - (UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.ENERGY, stack) ? (double)UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.ENERGY, (ItemStack)stack).number * 0.25 : 0.0);
                if (tile instanceof BlockEntityInventory) {
                    base = (BlockEntityInventory)tile;
                    double energy = 10000.0;
                    if (UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.PURIFIER, stack)) {
                        energy = 0.0;
                    }
                    if (!base.canEntityDestroy((Entity)player)) {
                        return InteractionResult.FAIL;
                    }
                    for (AbstractComponent component : base.getComponentList()) {
                        if (!component.canUsePurifier(player) || !ElectricItem.manager.canUse(stack, energy * coef)) continue;
                        component.workPurifier();
                        return InteractionResult.SUCCESS;
                    }
                }
                if (tile instanceof BlockEntityMultiMachine) {
                    if (!ElectricItem.manager.canUse(stack, 500.0 * coef)) {
                        return InteractionResult.PASS;
                    }
                    base = (BlockEntityMultiMachine)tile;
                    ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
                    if (((BlockEntityMultiMachine)base).multi_process.quickly) {
                        stackList.add(new ItemStack((ItemLike)IUItem.module_quickly.getItem()));
                        ((BlockEntityMultiMachine)base).multi_process.setQuickly(false);
                        ((BlockEntityMultiMachine)base).multi_process.shrinkModule(1);
                    }
                    if (((BlockEntityMultiMachine)base).multi_process.modulesize) {
                        stackList.add(new ItemStack((ItemLike)IUItem.module_stack.getItem()));
                        ((BlockEntityMultiMachine)base).multi_process.setModulesize(false);
                        ((BlockEntityMultiMachine)base).multi_process.shrinkModule(1);
                    }
                    if (((BlockEntityMultiMachine)base).multi_process.module_separate) {
                        stackList.add(new ItemStack((ItemLike)IUItem.module_separate.getItem()));
                        ((BlockEntityMultiMachine)base).multi_process.module_separate = false;
                        ((BlockEntityMultiMachine)base).multi_process.shrinkModule(1);
                    }
                    if (((BlockEntityMultiMachine)base).solartype != null) {
                        stackList.add(new ItemStack((ItemLike)IUItem.module6.getStack(((BlockEntityMultiMachine)base).solartype.meta), 1));
                        ((BlockEntityMultiMachine)base).solartype = null;
                    }
                    if (((BlockEntityMultiMachine)base).multi_process.modulestorage) {
                        stackList.add(new ItemStack((ItemLike)IUItem.module_storage.getItem()));
                        ((BlockEntityMultiMachine)base).multi_process.setModulestorage(false);
                        ((BlockEntityMultiMachine)base).multi_process.shrinkModule(1);
                    }
                    if (((BlockEntityMultiMachine)base).multi_process.module_infinity_water) {
                        stackList.add(new ItemStack((ItemLike)IUItem.module_infinity_water.getItem()));
                        ((BlockEntityMultiMachine)base).multi_process.module_infinity_water = false;
                        ((BlockEntityMultiMachine)base).multi_process.shrinkModule(1);
                    }
                    for (ItemStack dropStack : stackList) {
                        if (level.f_46443_) continue;
                        ItemEntity itemEntity = new ItemEntity((Level)((ServerLevel)level), player.m_20185_(), player.m_20186_(), player.m_20189_(), dropStack);
                        itemEntity.m_32010_(0);
                        level.m_7967_((Entity)itemEntity);
                        player.m_6330_(EnumSound.purifier.getSoundEvent(), SoundSource.PLAYERS, 1.0f, 1.0f);
                    }
                    ElectricItem.manager.use(stack, 500.0 * coef, (LivingEntity)player);
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.PASS;
            }
        }
        return super.onItemUseFirst(stack, context);
    }

    protected boolean onHoeUse(ItemStack stack, Player player, Level world, BlockPos pos, Direction side) {
        if (player.m_36204_(pos.m_121945_(side), side, stack) && ItemGraviTool.hasNecessaryPower(stack, 50.0, player)) {
            BlockState state = world.m_8055_(pos);
            Block block = state.m_60734_();
            BlockState state1 = world.m_8055_(pos.m_7495_());
            if (side != Direction.DOWN && !state1.m_60795_()) {
                if (block == Blocks.f_50440_ || block == Blocks.f_152481_) {
                    return this.setHoedBlock(stack, player, world, pos, Blocks.f_50093_.m_49966_());
                }
                if (block == Blocks.f_50493_) {
                    return this.setHoedBlock(stack, player, world, pos, Blocks.f_50093_.m_49966_());
                }
                if (block == Blocks.f_50546_) {
                    return this.setHoedBlock(stack, player, world, pos, Blocks.f_50493_.m_49966_());
                }
            }
            return false;
        }
        return false;
    }

    protected boolean setHoedBlock(ItemStack stack, Player player, Level world, BlockPos pos, BlockState state) {
        if (ItemGraviTool.checkNecessaryPower(stack, 50.0, player, true)) {
            world.m_5594_(null, pos, SoundEvents.f_11955_, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!world.f_46443_) {
                world.m_7731_(pos, state, 11);
            }
            return true;
        }
        return false;
    }

    public void m_6883_(ItemStack itemStack, Level world, Entity entity, int slot, boolean selected) {
        if (!world.f_46443_) {
            CompoundTag nbt = itemStack.m_41784_();
            if (!UpgradeSystem.system.hasInMap(itemStack)) {
                nbt.m_128379_("hasID", false);
                MinecraftForge.EVENT_BUS.post((Event)new EventItemLoad(world, this, itemStack));
            }
        }
    }

    protected boolean onTreeTapUse(ItemStack stack, Player player, Level world, BlockPos pos, Direction side) {
        BlockState state = world.m_8055_(pos);
        return ItemGraviTool.hasNecessaryPower(stack, 50.0, player) && (state.m_60734_() == IUItem.rubWood.getBlock().get() && ItemTreetap.attemptExtract(player, world, pos, side, state, null) || state.m_60734_() == IUItem.swampRubWood.getBlock().get() && ItemTreetap.attemptSwampExtract(player, world, pos, side, state, null) || state.m_60734_() == IUItem.tropicalRubWood.getBlock().get() && ItemTreetap.attemptTropicalExtract(player, world, pos, side, state, null)) && ItemGraviTool.checkNecessaryPower(stack, 50.0, player);
    }

    protected boolean onWrenchUse(ItemStack stack, Player player, Level world, BlockPos pos, Direction side) {
        BlockState state = world.m_8055_(pos);
        Block block = state.m_60734_();
        if (state.m_60795_()) {
            return false;
        }
        if (block instanceof Wrenchable) {
            Direction newFacing;
            Wrenchable wrenchable = (Wrenchable)block;
            Direction current = wrenchable.getFacing(world, pos);
            if (!IUCore.keyboard.isChangeKeyDown(player)) {
                newFacing = player.m_6144_() ? side.m_122424_() : side;
            } else {
                Direction.Axis axis = side.m_122434_();
                newFacing = !(!player.m_6144_() && side.m_122421_() == Direction.AxisDirection.POSITIVE || player.m_6144_() && side.m_122421_() == Direction.AxisDirection.NEGATIVE) ? current.m_175364_(axis).m_175364_(axis).m_175364_(axis) : current.m_175362_(axis);
            }
            if (current != newFacing) {
                if (!ItemGraviTool.hasNecessaryPower(stack, 50.0, player)) {
                    return false;
                }
                if (wrenchable.setFacing(world, pos, newFacing, player)) {
                    player.m_5496_(EnumSound.wrench.getSoundEvent(), 1.0f, 1.0f);
                    return ItemGraviTool.checkNecessaryPower(stack, 50.0, player);
                }
            }
            if (wrenchable.wrenchCanRemove(world, pos, player)) {
                if (!ItemGraviTool.hasNecessaryPower(stack, 50.0, player)) {
                    return false;
                }
                player.m_5496_(EnumSound.wrench.getSoundEvent(), 1.0f, 1.0f);
                if (!world.f_46443_) {
                    int experience;
                    BlockEntity te = world.m_7702_(pos);
                    if (player instanceof ServerPlayer) {
                        experience = ForgeHooks.onBlockBreakEvent((Level)world, (GameType)((ServerPlayer)player).f_8941_.m_9290_(), (ServerPlayer)((ServerPlayer)player), (BlockPos)pos);
                        if (experience < 0) {
                            return false;
                        }
                    } else {
                        experience = 0;
                    }
                    block.m_5707_(world, pos, state, player);
                    if (!block.onDestroyedByPlayer(state, world, pos, player, true, world.m_6425_(pos))) {
                        return false;
                    }
                    int fortune = world.f_46441_.m_188503_(100);
                    if (UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.WRENCH, stack)) {
                        fortune = 100;
                    }
                    for (ItemStack drop : wrenchable.getWrenchDrops(world, pos, state, te, player, fortune)) {
                        ModUtils.dropAsEntity(world, pos, drop);
                    }
                    wrenchable.wrenchBreak(world, pos);
                    if (!player.m_7500_() && experience > 0) {
                        block.m_49805_((ServerLevel)world, pos, experience);
                    }
                }
                return ItemGraviTool.checkNecessaryPower(stack, 50.0, player);
            }
        }
        return false;
    }

    protected boolean onScrewdriverUse(ItemStack stack, Player player, Level world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        Block block = state.m_60734_();
        if (!state.m_60795_() && block instanceof HorizontalDirectionalBlock && ItemGraviTool.checkNecessaryPower(stack, 500.0, player)) {
            Direction facing = (Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
            facing = player.m_6144_() ? facing.m_122428_() : facing.m_122427_();
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)facing), 3);
            return true;
        }
        return false;
    }

    @Override
    public boolean canProvideEnergy(ItemStack stack) {
        return false;
    }

    @Override
    public double getMaxEnergy(ItemStack stack) {
        return 300000.0;
    }

    @Override
    public short getTierItem(ItemStack stack) {
        return 2;
    }

    @Override
    public double getTransferEnergy(ItemStack stack) {
        return 10000.0;
    }

    @Override
    public List<EnumInfoUpgradeModules> getUpgradeModules() {
        return EnumUpgrades.GRAVITOOL.list;
    }

    @Override
    public CreativeModeTab getItemCategory() {
        return IUCore.EnergyTab;
    }

    @Override
    public void fillItemCategory(CreativeModeTab p_41391_, NonNullList<ItemStack> p_41392_) {
        if (this.allowedIn(p_41391_)) {
            ElectricItemManager.addChargeVariants((Item)this, p_41392_);
        }
    }

    public static enum GraviToolMode {
        HOE(ChatFormatting.GOLD),
        TREETAP(ChatFormatting.LIGHT_PURPLE),
        WRENCH(ChatFormatting.AQUA),
        SCREWDRIVER(ChatFormatting.YELLOW),
        PURIFIER(ChatFormatting.DARK_AQUA);

        private static final GraviToolMode[] VALUES;
        public final String translationName = "iu.graviTool.snap." + this.name().toLowerCase(Locale.ENGLISH);
        public final ChatFormatting colour;

        private GraviToolMode(ChatFormatting colour) {
            this.colour = colour;
        }

        public static GraviToolMode getFromID(int ID) {
            return VALUES[ID % VALUES.length];
        }

        static {
            VALUES = GraviToolMode.values();
        }
    }
}

