/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.resource;

import com.denfop.IUCore;
import com.denfop.api.item.armor.HazmatLike;
import com.denfop.blocks.SubEnum;
import com.denfop.items.ItemMain;
import com.denfop.items.reactors.IRadioactiveItemType;
import com.denfop.potion.IUPotion;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class ItemNuclearResource<T extends Enum<T>>
extends ItemMain<T> {
    public ItemNuclearResource(T element) {
        super(new Item.Properties(), element);
    }

    @Override
    public CreativeModeTab getItemCategory() {
        return IUCore.ReactorsTab;
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slotIndex, boolean isCurrentItem) {
        LivingEntity entityLiving;
        if (entity instanceof LivingEntity && !HazmatLike.hasCompleteHazmat(entityLiving = (LivingEntity)entity)) {
            IUPotion.radiation.applyEffect(entityLiving, ((Types)this.getElement()).getRadiationDuration());
        }
    }

    public static enum Types implements SubEnum,
    IRadioactiveItemType
    {
        uranium(0, 60, 100),
        uranium_235(1, 150, 100),
        uranium_238(2, 10, 90),
        plutonium(3, 150, 100),
        mox(4, 300, 100),
        small_uranium_235(5, 150, 100),
        small_uranium_238(6, 10, 90),
        small_plutonium(7, 150, 100),
        uranium_pellet(8, 60, 100),
        mox_pellet(9, 300, 100),
        americium_dust(10, 60, 100),
        neptunium_dust(11, 60, 100),
        curium_dust(12, 60, 100),
        americium_smalldust(13, 60, 100),
        neptunium_smalldust(14, 60, 100),
        curium_smalldust(15, 60, 100),
        thorium_shard(16, 60, 100),
        unprocessed_radioactive_americium(17, 60, 100),
        unprocessed_radioactive_neptunium(18, 60, 100),
        unprocessed_radioactive_thorium(19, 60, 100),
        unprocessed_radioactive_curium(20, 60, 100),
        unprocessed_radioactive_uranium(21, 60, 100);

        private final int id;
        private final int radLen;
        private final int radAmplifier;

        private Types(int id, int radLen, int radAmplifier) {
            this.id = id;
            this.radLen = radLen;
            this.radAmplifier = radAmplifier;
        }

        public static Types getFromID(int ID) {
            return Types.values()[ID % Types.values().length];
        }

        @Override
        public String getName() {
            return this.name();
        }

        @Override
        public String getMainPath() {
            return "nuclearresource";
        }

        @Override
        public int getId() {
            return this.id;
        }

        @Override
        public int getRadiationDuration() {
            return this.radLen;
        }

        @Override
        public int getRadiationAmplifier() {
            return this.radAmplifier;
        }
    }
}

