/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.network;

import com.denfop.IUCore;
import com.denfop.blockentity.base.BlockEntityBase;
import com.denfop.network.UpdateTileEntityPacket;
import com.denfop.network.WorldData;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.EnumTypePacket;
import com.denfop.network.packet.IPacket;
import com.denfop.network.packet.PacketAbstractComponent;
import com.denfop.network.packet.PacketAddBuildingToColony;
import com.denfop.network.packet.PacketAddRelocatorPoint;
import com.denfop.network.packet.PacketChangeSolarPanel;
import com.denfop.network.packet.PacketChangeSpaceOperation;
import com.denfop.network.packet.PacketColorPicker;
import com.denfop.network.packet.PacketColorPickerAllLoggIn;
import com.denfop.network.packet.PacketCreateAutoSends;
import com.denfop.network.packet.PacketCreateColony;
import com.denfop.network.packet.PacketDeleteColony;
import com.denfop.network.packet.PacketDrainFluidPipette;
import com.denfop.network.packet.PacketExplosion;
import com.denfop.network.packet.PacketFixerRecipe;
import com.denfop.network.packet.PacketItemStackEvent;
import com.denfop.network.packet.PacketItemStackUpdate;
import com.denfop.network.packet.PacketKeys;
import com.denfop.network.packet.PacketRadiation;
import com.denfop.network.packet.PacketRadiationChunk;
import com.denfop.network.packet.PacketRadiationUpdateValue;
import com.denfop.network.packet.PacketRelocatorTeleportPlayer;
import com.denfop.network.packet.PacketRemoveRelocatorPoint;
import com.denfop.network.packet.PacketReturnRoversToPlanet;
import com.denfop.network.packet.PacketSendResourceToEarth;
import com.denfop.network.packet.PacketSendRoversToPlanet;
import com.denfop.network.packet.PacketSoundPlayer;
import com.denfop.network.packet.PacketStopSound;
import com.denfop.network.packet.PacketStopSoundPlayer;
import com.denfop.network.packet.PacketSuccessUpdateColony;
import com.denfop.network.packet.PacketSynhronyzationRelocator;
import com.denfop.network.packet.PacketUpdateBody;
import com.denfop.network.packet.PacketUpdateBookMarks;
import com.denfop.network.packet.PacketUpdateCompleteQuest;
import com.denfop.network.packet.PacketUpdateFakeBody;
import com.denfop.network.packet.PacketUpdateFieldContainerTile;
import com.denfop.network.packet.PacketUpdateFieldTile;
import com.denfop.network.packet.PacketUpdateInformationAboutQuestsPlayer;
import com.denfop.network.packet.PacketUpdateInventory;
import com.denfop.network.packet.PacketUpdateOvertimeTile;
import com.denfop.network.packet.PacketUpdateRadiation;
import com.denfop.network.packet.PacketUpdateRadiationValue;
import com.denfop.network.packet.PacketUpdateRecipe;
import com.denfop.network.packet.PacketUpdateRelocator;
import com.denfop.network.packet.PacketUpdateServerTile;
import com.denfop.network.packet.PacketUpdateSkipQuest;
import com.denfop.network.packet.PacketUpdateTile;
import com.denfop.network.packet.PacketUpdateVeinData;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.commons.lang3.tuple.Pair;

public class NetworkManager {
    public static Map<Byte, IPacket> packetMap = new HashMap<Byte, IPacket>();
    private static SimpleChannel channel;
    private static ResourceLocation handler;

    public NetworkManager() {
        handler = new ResourceLocation("industrialupgrade", "network");
        if (channel == null) {
            channel = NetworkRegistry.newSimpleChannel((ResourceLocation)handler, () -> "1.0.0", e -> true, e -> true);
        }
        this.registerPacket(new PacketKeys());
        this.registerPacket(new PacketAbstractComponent());
        this.registerPacket(new PacketColorPickerAllLoggIn(null));
        this.registerPacket(new PacketRadiation());
        this.registerPacket(new PacketUpdateServerTile());
        this.registerPacket(new PacketUpdateTile());
        this.registerPacket(new PacketRadiationChunk());
        this.registerPacket(new PacketRadiationUpdateValue());
        this.registerPacket(new PacketUpdateFieldContainerTile());
        this.registerPacket(new PacketColorPicker());
        this.registerPacket(new PacketUpdateFieldTile());
        this.registerPacket(new PacketExplosion());
        this.registerPacket(new PacketChangeSolarPanel());
        this.registerPacket(new PacketSoundPlayer());
        this.registerPacket(new PacketUpdateOvertimeTile());
        this.registerPacket(new PacketItemStackUpdate());
        this.registerPacket(new PacketItemStackEvent());
        this.registerPacket(new PacketStopSound());
        this.registerPacket(new PacketUpdateInventory());
        this.registerPacket(new PacketUpdateRadiationValue());
        this.registerPacket(new PacketUpdateRadiation());
        this.registerPacket(new PacketStopSoundPlayer());
        this.registerPacket(new PacketAddRelocatorPoint());
        this.registerPacket(new PacketRemoveRelocatorPoint());
        this.registerPacket(new PacketRelocatorTeleportPlayer());
        this.registerPacket(new PacketUpdateBody());
        this.registerPacket(new PacketUpdateFakeBody());
        this.registerPacket(new PacketSendRoversToPlanet());
        this.registerPacket(new PacketReturnRoversToPlanet());
        this.registerPacket(new PacketChangeSpaceOperation());
        this.registerPacket(new PacketCreateColony());
        this.registerPacket(new PacketSendResourceToEarth());
        this.registerPacket(new PacketAddBuildingToColony());
        this.registerPacket(new PacketSuccessUpdateColony());
        this.registerPacket(new PacketCreateAutoSends());
        this.registerPacket(new PacketDeleteColony());
        this.registerPacket(new PacketUpdateCompleteQuest());
        this.registerPacket(new PacketUpdateInformationAboutQuestsPlayer());
        this.registerPacket(new PacketSynhronyzationRelocator());
        this.registerPacket(new PacketUpdateRelocator());
        this.registerPacket(new PacketFixerRecipe());
        this.registerPacket(new PacketDrainFluidPipette());
        this.registerPacket(new PacketUpdateRecipe());
        this.registerPacket(new PacketUpdateSkipQuest());
        this.registerPacket(new PacketUpdateBookMarks());
        this.registerPacket(new PacketUpdateVeinData());
        channel.registerMessage(0, CustomPacketBuffer.class, (customPacketBuffer, buf) -> buf.writeBytes((ByteBuf)customPacketBuffer), CustomPacketBuffer::new, this::onPacketData);
    }

    public static SimpleChannel getChannel() {
        return channel;
    }

    public static <T extends Collection<ServerPlayer>> T getPlayersInRange(Level world, BlockPos pos, T result) {
        if (!(world instanceof ServerLevel)) {
            return result;
        }
        List list = ((ServerLevel)world).m_7726_().f_8325_.m_183262_(new ChunkPos(pos), false);
        result.addAll(list);
        return result;
    }

    public Packet<?> makePacket(NetworkDirection direction, CustomPacketBuffer buffer) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.writeByte(0);
        buf.writeBoolean(this.isClient());
        buf.writeBytes((ByteBuf)buffer);
        return direction.buildPacket(Pair.of((Object)buf, (Object)0), handler).getThis();
    }

    public void sendPacket(PacketDistributor.PacketTarget packetDistributor, CustomPacketBuffer buffer) {
        if (!this.isClient()) {
            packetDistributor.send(this.makePacket(packetDistributor.getDirection(), buffer));
        } else {
            IUCore.network.getClient().sendPacket(packetDistributor, buffer);
        }
    }

    public void registerPacket(IPacket packet) {
        if (!packetMap.containsKey(packet.getId())) {
            packetMap.put(packet.getId(), packet);
        }
    }

    protected boolean isClient() {
        return false;
    }

    public void onPacketData(CustomPacketBuffer is, Supplier<NetworkEvent.Context> ctx) {
        boolean isClient = is.readBoolean();
        if (!isClient) {
            is.retain();
            byte[] bytes = new byte[is.writerIndex() - is.readerIndex()];
            is.readBytes(bytes);
            ctx.get().enqueueWork(() -> {
                CustomPacketBuffer is1 = new CustomPacketBuffer(bytes);
                if (is1.writerIndex() > is1.readerIndex()) {
                    byte type = is1.readByte();
                    IUCore.network.getClient().onPacketData(is1, type);
                }
            });
        } else {
            is.retain();
            byte[] bytes = new byte[is.writerIndex() - is.readerIndex()];
            is.readBytes(bytes);
            ctx.get().enqueueWork(() -> {
                CustomPacketBuffer is1 = new CustomPacketBuffer(bytes);
                if (is1.writerIndex() > is1.readerIndex()) {
                    try {
                        byte type = is1.readByte();
                        IPacket packet = packetMap.get(type);
                        if (packet != null && packet.getPacketType() == EnumTypePacket.CLIENT) {
                            packet.readPacket(is1, (Player)((NetworkEvent.Context)ctx.get()).getSender());
                        }
                    }
                    catch (Exception e) {
                        System.err.println("\u041e\u0448\u0438\u0431\u043a\u0430 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u043f\u0430\u043a\u0435\u0442\u0430: " + e.getMessage());
                        e.printStackTrace();
                    }
                }
            });
        }
        ctx.get().setPacketHandled(true);
    }

    public void onPacketData(CustomPacketBuffer is, byte type) {
    }

    public final void sendPacket(CustomPacketBuffer buffer, ServerPlayer player) {
        this.sendPacket(PacketDistributor.PLAYER.with(() -> player), buffer);
    }

    public void sendPacket(CustomPacketBuffer buffer) {
        if (!this.isClient()) {
            PlayerList players = ServerLifecycleHooks.getCurrentServer().m_6846_();
            for (ServerPlayer player : players.m_11314_()) {
                this.sendPacket(PacketDistributor.PLAYER.with(() -> player), buffer);
            }
        } else {
            IUCore.network.getClient().sendPacket(buffer);
        }
    }

    public void onTickEnd(WorldData worldData) {
        try {
            UpdateTileEntityPacket.send(worldData);
        }
        catch (IOException var3) {
            throw new RuntimeException(var3);
        }
    }

    public void addTileContainerToUpdate(BlockEntityBase te, ServerPlayer player, CustomPacketBuffer packetBuffer) {
        Map<ServerPlayer, CustomPacketBuffer> map;
        if (te == null) {
            return;
        }
        WorldData worldData = WorldData.get(te.m_58904_());
        if (te.m_58901_()) {
            return;
        }
        if (worldData.mapUpdateContainer.containsKey((Object)te)) {
            map = worldData.mapUpdateContainer.computeIfAbsent(te, k -> new HashMap());
        } else {
            map = new HashMap();
            worldData.mapUpdateContainer.put(te, map);
        }
        map.put(player, packetBuffer);
    }

    public void addTileToUpdate(BlockEntityBase te) {
        if (te.m_58898_()) {
            WorldData worldData = WorldData.get(te.m_58904_());
            worldData.listUpdateTile.add(te);
        }
    }

    public void addTileToOvertimeUpdate(BlockEntityBase te) {
        WorldData worldData = WorldData.get(te.m_58904_());
        if (!worldData.mapUpdateOvertimeField.containsKey(te.m_58899_())) {
            worldData.mapUpdateOvertimeField.put(te.m_58899_(), te);
        }
    }

    public void removeTileToOvertimeUpdate(BlockEntityBase te) {
        WorldData worldData = WorldData.get(te.m_58904_());
        worldData.mapUpdateOvertimeField.remove(te.m_58899_());
    }

    public void addTileFieldToUpdate(BlockEntityBase te, CustomPacketBuffer packet) {
        WorldData worldData = WorldData.get(te.m_58904_());
        if (worldData.mapUpdateField.containsKey((Object)te)) {
            worldData.mapUpdateField.get((Object)te).add(packet);
        } else {
            worldData.mapUpdateField.put(te, new LinkedList<CustomPacketBuffer>(Collections.singletonList(packet)));
        }
    }
}

