/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.network;

import com.denfop.IUCore;
import com.denfop.network.NetworkManager;
import com.denfop.network.WorldData;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.EnumTypePacket;
import com.denfop.network.packet.IPacket;
import com.mojang.text2speech.Narrator;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.server.ServerLifecycleHooks;

@OnlyIn(value=Dist.CLIENT)
public class NetworkManagerClient
extends NetworkManager {
    private static final double PACKET_RANGE = 2.0;

    @Override
    public void sendPacket(CustomPacketBuffer buffer) {
        Objects.requireNonNull(buffer, "Packet buffer cannot be null");
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server == null) {
            this.sendPacketToNearbyPlayers(buffer);
            return;
        }
        this.sendPacketToServerPlayer(buffer);
    }

    private void sendPacketToNearbyPlayers(CustomPacketBuffer buffer) {
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        if (player == null) {
            Narrator.LOGGER.warn("Cannot send packet: player is null");
            return;
        }
        PacketDistributor.TargetPoint targetPoint = new PacketDistributor.TargetPoint(player.m_20185_(), player.m_20186_(), player.m_20189_(), 2.0, player.m_9236_().m_46472_());
        this.sendPacket(PacketDistributor.NEAR.with(() -> targetPoint), buffer);
    }

    private void sendPacketToServerPlayer(CustomPacketBuffer buffer) {
        UUID playerUUID = IUCore.proxy.getPlayerInstance().m_20148_();
        ServerPlayer serverPlayer = ServerLifecycleHooks.getCurrentServer().m_6846_().m_11259_(playerUUID);
        if (serverPlayer == null) {
            Narrator.LOGGER.warn("Cannot send packet: server player not found for UUID {}", (Object)playerUUID);
            return;
        }
        this.sendPacket(PacketDistributor.PLAYER.with(() -> serverPlayer), buffer);
    }

    @Override
    public void sendPacket(PacketDistributor.PacketTarget packetDistributor, CustomPacketBuffer buffer) {
        Objects.requireNonNull(packetDistributor, "Packet distributor cannot be null");
        Objects.requireNonNull(buffer, "Packet buffer cannot be null");
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            Narrator.LOGGER.warn("Cannot send packet: player connection is not available");
            return;
        }
        player.f_108617_.m_104955_(this.makePacket(NetworkDirection.PLAY_TO_SERVER, buffer));
    }

    @Override
    public void onPacketData(CustomPacketBuffer buffer, byte type) {
        Objects.requireNonNull(buffer, "Packet buffer cannot be null");
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            Narrator.LOGGER.warn("Cannot process packet: player is null");
            return;
        }
        IPacket packet = (IPacket)packetMap.get(type);
        if (packet != null && packet.getPacketType() == EnumTypePacket.SERVER) {
            try {
                packet.readPacket(buffer, (Player)player);
            }
            catch (Exception e) {
                Narrator.LOGGER.error("Error processing packet type {}", (Object)type, (Object)e);
            }
        } else {
            Narrator.LOGGER.warn("Unknown or invalid packet type: {}", (Object)type);
        }
    }

    @Override
    protected boolean isClient() {
        return true;
    }

    @Override
    public void onTickEnd(WorldData worldData) {
    }
}

