/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.recipe.universalrecipe;

import com.denfop.IUCore;
import com.denfop.api.space.BaseResource;
import com.denfop.api.space.SpaceInit;
import com.denfop.api.space.SpaceNet;
import com.denfop.api.space.rovers.enums.EnumTypeRovers;
import com.denfop.recipe.IInputItemStack;
import com.denfop.recipe.InputFluidStack;
import com.denfop.recipe.InputItemStack;
import com.denfop.recipe.InputOreDict;
import com.denfop.recipe.universalrecipe.SpaceBodyRecipe;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public class SpaceBodySerializer
implements RecipeSerializer<SpaceBodyRecipe> {
    public static final SpaceBodySerializer INSTANCE = new SpaceBodySerializer();

    public SpaceBodyRecipe fromJson(ResourceLocation id, JsonObject json) {
        String bodyName = GsonHelper.m_13906_((JsonObject)json, (String)"body");
        ArrayList<IInputItemStack> input = new ArrayList<IInputItemStack>();
        if (GsonHelper.m_13900_((JsonObject)json, (String)"inputs")) {
            JsonArray inArray = GsonHelper.m_13933_((JsonObject)json, (String)"inputs");
            block22: for (JsonElement el : inArray) {
                JsonObject obj = el.getAsJsonObject();
                String type = GsonHelper.m_13906_((JsonObject)obj, (String)"type");
                String itemId = GsonHelper.m_13906_((JsonObject)obj, (String)"id");
                int amount = GsonHelper.m_13824_((JsonObject)obj, (String)"amount", (int)1);
                switch (type) {
                    case "item": {
                        ItemStack stack = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemId)), amount);
                        input.add(new InputItemStack(stack));
                        continue block22;
                    }
                    case "tag": {
                        input.add(new InputOreDict(itemId, amount));
                        continue block22;
                    }
                    case "fluid": {
                        FluidStack fluidStack = new FluidStack((Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(itemId)), amount);
                        input.add(new InputFluidStack(fluidStack));
                        continue block22;
                    }
                }
                throw new IllegalArgumentException("Unknown input type: " + type);
            }
        }
        String roverType = GsonHelper.m_13906_((JsonObject)json, (String)"typeRover");
        String operationType = GsonHelper.m_13906_((JsonObject)json, (String)"typeOperation");
        int percent = GsonHelper.m_13927_((JsonObject)json, (String)"percent");
        int chance = GsonHelper.m_13927_((JsonObject)json, (String)"chance");
        if (operationType.equals("addAll")) {
            switch (roverType) {
                case "rover": {
                    for (IInputItemStack itemStack : input) {
                        if (itemStack instanceof InputItemStack) {
                            SpaceInit.regBaseResource.add(() -> new BaseResource(((InputItemStack)itemStack).input, chance, 100, percent, SpaceNet.instance.getBodyFromName(bodyName.toLowerCase()), EnumTypeRovers.ROVERS));
                        }
                        if (itemStack instanceof InputFluidStack) {
                            SpaceInit.regBaseResource.add(() -> new BaseResource(((InputFluidStack)itemStack).getFluid(), chance, 100, percent, SpaceNet.instance.getBodyFromName(bodyName.toLowerCase()), EnumTypeRovers.ROVERS));
                        }
                        if (!(itemStack instanceof InputOreDict)) continue;
                        SpaceInit.regBaseResource.add(() -> new BaseResource(itemStack.getInputs().get(0), chance, 100, percent, SpaceNet.instance.getBodyFromName(bodyName.toLowerCase()), EnumTypeRovers.ROVERS));
                    }
                    break;
                }
                case "probe": {
                    for (IInputItemStack itemStack : input) {
                        if (itemStack instanceof InputItemStack) {
                            SpaceInit.regBaseResource.add(() -> new BaseResource(((InputItemStack)itemStack).input, chance, 100, percent, SpaceNet.instance.getBodyFromName(bodyName.toLowerCase()), EnumTypeRovers.PROBE));
                        }
                        if (itemStack instanceof InputFluidStack) {
                            SpaceInit.regBaseResource.add(() -> new BaseResource(((InputFluidStack)itemStack).getFluid(), chance, 100, percent, SpaceNet.instance.getBodyFromName(bodyName.toLowerCase()), EnumTypeRovers.PROBE));
                        }
                        if (!(itemStack instanceof InputOreDict)) continue;
                        SpaceInit.regBaseResource.add(() -> new BaseResource(((InputOreDict)itemStack).getInputs().get(0), chance, 100, percent, SpaceNet.instance.getBodyFromName(bodyName.toLowerCase()), EnumTypeRovers.PROBE));
                    }
                    break;
                }
                case "satellite": {
                    for (IInputItemStack itemStack : input) {
                        if (itemStack instanceof InputItemStack) {
                            SpaceInit.regBaseResource.add(() -> new BaseResource(((InputItemStack)itemStack).input, chance, 100, percent, SpaceNet.instance.getBodyFromName(bodyName.toLowerCase()), EnumTypeRovers.SATELLITE));
                        }
                        if (itemStack instanceof InputFluidStack) {
                            SpaceInit.regBaseResource.add(() -> new BaseResource(((InputFluidStack)itemStack).getFluid(), chance, 100, percent, SpaceNet.instance.getBodyFromName(bodyName.toLowerCase()), EnumTypeRovers.SATELLITE));
                        }
                        if (!(itemStack instanceof InputOreDict)) continue;
                        SpaceInit.regBaseResource.add(() -> new BaseResource(itemStack.getInputs().get(0), chance, 100, percent, SpaceNet.instance.getBodyFromName(bodyName.toLowerCase()), EnumTypeRovers.SATELLITE));
                    }
                    break;
                }
                case "rocket": {
                    for (IInputItemStack itemStack : input) {
                        if (itemStack instanceof InputItemStack) {
                            SpaceInit.regBaseResource.add(() -> new BaseResource(((InputItemStack)itemStack).input, chance, 100, percent, SpaceNet.instance.getBodyFromName(bodyName.toLowerCase()), EnumTypeRovers.ROCKET));
                        }
                        if (itemStack instanceof InputFluidStack) {
                            SpaceInit.regBaseResource.add(() -> new BaseResource(((InputFluidStack)itemStack).getFluid(), chance, 100, percent, SpaceNet.instance.getBodyFromName(bodyName.toLowerCase()), EnumTypeRovers.ROCKET));
                        }
                        if (!(itemStack instanceof InputOreDict)) continue;
                        SpaceInit.regBaseResource.add(() -> new BaseResource(((InputOreDict)itemStack).getInputs().get(0), chance, 100, percent, SpaceNet.instance.getBodyFromName(bodyName.toLowerCase()), EnumTypeRovers.ROCKET));
                    }
                    break;
                }
            }
        }
        return new SpaceBodyRecipe(id, bodyName, percent, chance, roverType, operationType, input);
    }

    public void toNetwork(FriendlyByteBuf buf, SpaceBodyRecipe recipe) {
        buf.m_130070_(recipe.bodyName);
        buf.m_130130_(recipe.percent.intValue());
        buf.m_130130_(recipe.chance.intValue());
        buf.m_130070_(recipe.roverType);
        buf.m_130070_(recipe.operationType);
        buf.m_130130_(recipe.input.size());
        for (IInputItemStack inputStack : recipe.input) {
            if (inputStack instanceof InputItemStack) {
                InputItemStack stack = (InputItemStack)inputStack;
                buf.m_130070_("item");
                buf.m_130070_(ForgeRegistries.ITEMS.getKey((Object)stack.input.m_41720_()).toString());
                buf.m_130130_(stack.input.m_41613_());
                continue;
            }
            if (inputStack instanceof InputFluidStack) {
                InputFluidStack fluid = (InputFluidStack)inputStack;
                buf.m_130070_("fluid");
                buf.m_130070_(ForgeRegistries.FLUIDS.getKey((Object)fluid.getFluid().getFluid()).toString());
                buf.m_130130_(fluid.getFluid().getAmount());
                continue;
            }
            if (inputStack instanceof InputOreDict) {
                InputOreDict ore = (InputOreDict)inputStack;
                buf.m_130070_("tag");
                buf.m_130070_(ore.getTag().f_203868_().toString());
                buf.m_130130_(ore.getInputs().get(0).m_41613_());
                continue;
            }
            throw new IllegalArgumentException("Unknown input type: " + String.valueOf(inputStack));
        }
    }

    public SpaceBodyRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
        String bodyName = buf.m_130277_();
        int percent = buf.m_130242_();
        int chance = buf.m_130242_();
        String typeRover = buf.m_130277_();
        String typeOperation = buf.m_130277_();
        int size = buf.m_130242_();
        ArrayList<IInputItemStack> inputs = new ArrayList<IInputItemStack>();
        block22: for (int i = 0; i < size; ++i) {
            String type = buf.m_130277_();
            switch (type) {
                case "item": {
                    ResourceLocation itemId = buf.m_130281_();
                    int amount = buf.m_130242_();
                    ItemStack itemStack = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(itemId), amount);
                    inputs.add(new InputItemStack(itemStack));
                    continue block22;
                }
                case "fluid": {
                    ResourceLocation fluidId = buf.m_130281_();
                    int amount = buf.m_130242_();
                    FluidStack fluidStack = new FluidStack((Fluid)ForgeRegistries.FLUIDS.getValue(fluidId), amount);
                    inputs.add(new InputFluidStack(fluidStack));
                    continue block22;
                }
                case "tag": {
                    String tagId = buf.m_130277_();
                    int amount = buf.m_130242_();
                    inputs.add(new InputOreDict(tagId, amount));
                    continue block22;
                }
                default: {
                    throw new IllegalArgumentException("Unknown input type: " + type);
                }
            }
        }
        if (!IUCore.updateRecipe && typeRover.equals("add")) {
            switch (typeOperation) {
                case "rover": {
                    for (IInputItemStack itemStack : inputs) {
                        if (itemStack instanceof InputItemStack) {
                            SpaceInit.regBaseResource.add(() -> new BaseResource(((InputItemStack)itemStack).input, chance, 100, percent, SpaceNet.instance.getBodyFromName(bodyName.toLowerCase()), EnumTypeRovers.ROVERS));
                        }
                        if (itemStack instanceof InputFluidStack) {
                            SpaceInit.regBaseResource.add(() -> new BaseResource(((InputFluidStack)itemStack).getFluid(), chance, 100, percent, SpaceNet.instance.getBodyFromName(bodyName.toLowerCase()), EnumTypeRovers.ROVERS));
                        }
                        if (!(itemStack instanceof InputOreDict)) continue;
                        SpaceInit.regBaseResource.add(() -> new BaseResource(itemStack.getInputs().get(0), chance, 100, percent, SpaceNet.instance.getBodyFromName(bodyName.toLowerCase()), EnumTypeRovers.ROVERS));
                    }
                    break;
                }
                case "probe": {
                    for (IInputItemStack itemStack : inputs) {
                        if (itemStack instanceof InputItemStack) {
                            SpaceInit.regBaseResource.add(() -> new BaseResource(((InputItemStack)itemStack).input, chance, 100, percent, SpaceNet.instance.getBodyFromName(bodyName.toLowerCase()), EnumTypeRovers.PROBE));
                        }
                        if (itemStack instanceof InputFluidStack) {
                            SpaceInit.regBaseResource.add(() -> new BaseResource(((InputFluidStack)itemStack).getFluid(), chance, 100, percent, SpaceNet.instance.getBodyFromName(bodyName.toLowerCase()), EnumTypeRovers.PROBE));
                        }
                        if (!(itemStack instanceof InputOreDict)) continue;
                        SpaceInit.regBaseResource.add(() -> new BaseResource(((InputOreDict)itemStack).getInputs().get(0), chance, 100, percent, SpaceNet.instance.getBodyFromName(bodyName.toLowerCase()), EnumTypeRovers.PROBE));
                    }
                    break;
                }
                case "satellite": {
                    for (IInputItemStack itemStack : inputs) {
                        if (itemStack instanceof InputItemStack) {
                            SpaceInit.regBaseResource.add(() -> new BaseResource(((InputItemStack)itemStack).input, chance, 100, percent, SpaceNet.instance.getBodyFromName(bodyName.toLowerCase()), EnumTypeRovers.SATELLITE));
                        }
                        if (itemStack instanceof InputFluidStack) {
                            SpaceInit.regBaseResource.add(() -> new BaseResource(((InputFluidStack)itemStack).getFluid(), chance, 100, percent, SpaceNet.instance.getBodyFromName(bodyName.toLowerCase()), EnumTypeRovers.SATELLITE));
                        }
                        if (!(itemStack instanceof InputOreDict)) continue;
                        SpaceInit.regBaseResource.add(() -> new BaseResource(itemStack.getInputs().get(0), chance, 100, percent, SpaceNet.instance.getBodyFromName(bodyName.toLowerCase()), EnumTypeRovers.SATELLITE));
                    }
                    break;
                }
                case "rocket": {
                    for (IInputItemStack itemStack : inputs) {
                        if (itemStack instanceof InputItemStack) {
                            SpaceInit.regBaseResource.add(() -> new BaseResource(((InputItemStack)itemStack).input, chance, 100, percent, SpaceNet.instance.getBodyFromName(bodyName.toLowerCase()), EnumTypeRovers.ROCKET));
                        }
                        if (itemStack instanceof InputFluidStack) {
                            SpaceInit.regBaseResource.add(() -> new BaseResource(((InputFluidStack)itemStack).getFluid(), chance, 100, percent, SpaceNet.instance.getBodyFromName(bodyName.toLowerCase()), EnumTypeRovers.ROCKET));
                        }
                        if (!(itemStack instanceof InputOreDict)) continue;
                        SpaceInit.regBaseResource.add(() -> new BaseResource(((InputOreDict)itemStack).getInputs().get(0), chance, 100, percent, SpaceNet.instance.getBodyFromName(bodyName.toLowerCase()), EnumTypeRovers.ROCKET));
                    }
                    break;
                }
            }
        }
        return new SpaceBodyRecipe(id, bodyName, percent, chance, typeRover, typeOperation, inputs);
    }
}

