/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.register;

import com.denfop.blocks.BlockFluidIU;
import com.denfop.blocks.FluidName;
import com.denfop.blocks.IUFluid;
import com.denfop.blocks.fluid.IUFluidType;
import com.denfop.dataregistry.DataItem;
import com.denfop.items.ItemBucket;
import com.denfop.register.Register;
import java.util.function.Supplier;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.registries.RegistryObject;

public class FluidHandler {
    public final RegistryObject<IUFluid> source;
    public final RegistryObject<IUFluid> flowing;
    private final IUFluidType fluidType;
    private final RegistryObject<LiquidBlock> liquedBlock;
    private ForgeFlowingFluid.Properties properties;

    public FluidHandler(IUFluidType fluidType, FluidName fluidName) {
        RegistryObject blockRegistryObject;
        this.fluidType = fluidType;
        this.source = Register.FLUIDS.register(fluidName.getName().toLowerCase(), () -> new IUFluid(this.properties, true));
        this.flowing = Register.FLUIDS.register(fluidName.getName().toLowerCase() + "_flowing", () -> new IUFluid(this.properties, false));
        MapColor steam = MapColor.f_283818_;
        RegistryObject bucket = Register.ITEMS.register("bucket/" + fluidName.name().toLowerCase().replace("fluid", ""), () -> new ItemBucket((Supplier<? extends Fluid>)this.source, fluidName));
        DataItem.objects.add((RegistryObject<Item>)bucket);
        this.liquedBlock = blockRegistryObject = Register.BLOCKS.register("fluid/" + fluidName.name().toLowerCase(), () -> new BlockFluidIU((Supplier<? extends FlowingFluid>)this.source, BlockBehaviour.Properties.m_284310_().m_284180_(steam).m_280170_().m_278788_().m_60953_(state -> ((IUFluid)((Object)((Object)((Object)this.source.get())))).getFluidType().getLightLevel())));
        this.properties = new ForgeFlowingFluid.Properties(() -> this.fluidType, this.source, this.flowing).slopeFindDistance(2).bucket((Supplier)bucket).levelDecreasePerBlock(2).block((Supplier)blockRegistryObject);
    }

    public RegistryObject<LiquidBlock> getLiquedBlock() {
        return this.liquedBlock;
    }

    public IUFluidType getFluidType() {
        return this.fluidType;
    }

    public ForgeFlowingFluid.Properties getProperties() {
        return this.properties;
    }

    public void setProperties(ForgeFlowingFluid.Properties properties) {
        this.properties = properties;
    }
}

