/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.render.macerator;

import com.denfop.IUItem;
import com.denfop.blockentity.mechanism.BlockEntityMacerator;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.ForgeHooksClient;

public class TileEntityRenderMacerator
implements BlockEntityRenderer<BlockEntityMacerator> {
    private final BlockEntityRendererProvider.Context contex;
    private ItemStack stack;
    private float rotation;
    private float prevRotation;

    public TileEntityRenderMacerator(BlockEntityRendererProvider.Context context) {
        this.contex = context;
    }

    public void render(BlockEntityMacerator tile, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        ItemStack output;
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        poseStack.m_85836_();
        if (tile.durability == 0) {
            if (this.stack == null) {
                this.stack = new ItemStack((ItemLike)IUItem.crafting_elements.getStack(41));
            }
            this.renderItem(this.stack, tile.m_58904_(), poseStack, buffer, combinedLight, combinedOverlay);
        }
        poseStack.m_85849_();
        ItemStack input = tile.inputSlotA.get(0);
        if (!input.m_41619_()) {
            poseStack.m_85836_();
            poseStack.m_85837_(0.5, 0.55, tile.facing == 4 || tile.facing == 5 ? 0.31 : 0.3);
            poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
            itemRenderer.m_269128_(input, ItemDisplayContext.GROUND, combinedLight, combinedOverlay, poseStack, buffer, tile.m_58904_(), 0);
            poseStack.m_85849_();
        }
        if (!(output = tile.outputSlot.get(0)).m_41619_()) {
            poseStack.m_85836_();
            poseStack.m_85837_(0.5, 0.55, 0.4);
            poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
            itemRenderer.m_269128_(output, ItemDisplayContext.GROUND, combinedLight, combinedOverlay, poseStack, buffer, tile.m_58904_(), 0);
            poseStack.m_85849_();
        }
    }

    private int transformModelCount(PoseStack poseStack, float partialTicks) {
        int modelCount = 1;
        float offsetY = 1.0f;
        poseStack.m_85837_(0.5, (double)(0.25f * offsetY) + 0.25, 0.5);
        poseStack.m_85841_(0.4f, 0.4f, 0.4f);
        this.prevRotation = this.rotation = (this.prevRotation + (this.rotation - this.prevRotation) * partialTicks) % 360.0f;
        this.rotation += 2.0f;
        poseStack.m_252781_(Axis.f_252436_.m_252977_(this.rotation));
        return modelCount;
    }

    public void renderItem(ItemStack itemStack, Level level, PoseStack poseStack, MultiBufferSource buffer, int light, int overlay) {
        if (itemStack.m_41619_()) {
            return;
        }
        BakedModel bakedModel = this.contex.m_234447_().m_174264_(itemStack, level, null, 0);
        RandomSource random = level.f_46441_;
        if (bakedModel != null) {
            boolean isGui3d = bakedModel.m_7539_();
            poseStack.m_85836_();
            poseStack.m_252880_(0.0f, 2.0f, 0.0f);
            int count = this.transformModelCount(poseStack, Minecraft.m_91087_().getPartialTick());
            for (int i = 0; i < 1; ++i) {
                poseStack.m_85836_();
                if (isGui3d) {
                    if (i > 0) {
                        float xOffset = (random.m_188501_() * 2.0f - 1.0f) * 0.15f;
                        yOffset = (random.m_188501_() * 2.0f - 1.0f) * 0.15f;
                        float zOffset = (random.m_188501_() * 2.0f - 1.0f) * 0.15f;
                        poseStack.m_252880_(xOffset, yOffset, zOffset);
                    }
                } else if (i > 0) {
                    float xOffset = (random.m_188501_() * 2.0f - 1.0f) * 0.075f;
                    yOffset = (random.m_188501_() * 2.0f - 1.0f) * 0.075f;
                    poseStack.m_252880_(xOffset, yOffset, 0.0f);
                }
                BakedModel transformedModel = ForgeHooksClient.handleCameraTransforms((PoseStack)new PoseStack(), (BakedModel)bakedModel, (ItemDisplayContext)ItemDisplayContext.GROUND, (boolean)false);
                this.contex.m_234447_().m_115143_(itemStack, ItemDisplayContext.FIXED, false, poseStack, buffer, light, overlay, transformedModel);
                poseStack.m_85849_();
            }
            poseStack.m_85849_();
        }
    }
}

