/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.render.sintezator;

import com.denfop.blockentity.base.BlockEntitySintezator;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class TileEntitySintezatorRenderer
implements BlockEntityRenderer<BlockEntitySintezator> {
    private final BlockRenderDispatcher blockRenderer;
    private final Map<BlockState, BakedModel> modelCache = new HashMap<BlockState, BakedModel>();

    public TileEntitySintezatorRenderer(BlockEntityRendererProvider.Context context) {
        this.blockRenderer = Minecraft.m_91087_().m_91289_();
    }

    public void render(BlockEntitySintezator tile, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int combinedLight, int combinedOverlay) {
        poseStack.m_85836_();
        for (int i = 0; i < 9; ++i) {
            Item item;
            ItemStack stack = tile.inputslot.get(i);
            if (stack.m_41619_() || !((item = stack.m_41720_()) instanceof BlockItem)) continue;
            BlockItem blockItem = (BlockItem)item;
            Block block = blockItem.m_40614_();
            BlockState state = block.m_49966_();
            poseStack.m_85836_();
            poseStack.m_85837_(0.25 + 0.189 * (double)(i % 3), 0.3125, 0.25 + 0.189 * (double)(i / 3));
            poseStack.m_85841_(0.125f, 0.125f, 0.125f);
            BakedModel model = this.modelCache.computeIfAbsent(state, arg_0 -> ((BlockRenderDispatcher)this.blockRenderer).m_110910_(arg_0));
            for (Direction direction : Direction.values()) {
                this.renderQuads(poseStack, bufferSource, model.m_213637_(state, direction, tile.m_58904_().m_213780_()), combinedLight, combinedOverlay);
            }
            this.renderQuads(poseStack, bufferSource, model.m_213637_(state, null, tile.m_58904_().m_213780_()), combinedLight, combinedOverlay);
            poseStack.m_85849_();
        }
        poseStack.m_85849_();
    }

    private void renderQuads(PoseStack poseStack, MultiBufferSource bufferSource, List<BakedQuad> quads, int combinedLight, int combinedOverlay) {
        VertexConsumer buffer = bufferSource.m_6299_(RenderType.m_110451_());
        PoseStack.Pose pose = poseStack.m_85850_();
        for (BakedQuad quad : quads) {
            buffer.m_85987_(pose, quad, 1.0f, 1.0f, 1.0f, combinedLight, OverlayTexture.f_118083_);
        }
    }
}

