/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.render.streak;

import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.render.streak.RGB;
import net.minecraft.nbt.CompoundTag;

public class PlayerStreakInfo {
    private RGB rgb;
    private boolean rainbow;

    public PlayerStreakInfo(RGB rgb, boolean rainbow) {
        this.rgb = rgb;
        this.rainbow = rainbow;
    }

    public PlayerStreakInfo(CompoundTag nbtTagCompound) {
        this.rgb = new RGB(nbtTagCompound.m_128448_("red"), nbtTagCompound.m_128448_("green"), nbtTagCompound.m_128448_("blue"));
        this.rainbow = nbtTagCompound.m_128471_("rainbow");
    }

    public PlayerStreakInfo(CustomPacketBuffer customPacketBuffer) {
        this.rgb = new RGB(customPacketBuffer.readShort(), customPacketBuffer.readShort(), customPacketBuffer.readShort());
        this.rainbow = customPacketBuffer.readBoolean();
    }

    public CompoundTag writeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128376_("red", this.rgb.getRed());
        nbt.m_128376_("blue", this.rgb.getBlue());
        nbt.m_128376_("green", this.rgb.getGreen());
        nbt.m_128379_("rainbow", this.rainbow);
        return nbt;
    }

    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer packetBuffer = new CustomPacketBuffer();
        packetBuffer.writeShort(this.rgb.getRed());
        packetBuffer.writeShort(this.rgb.getBlue());
        packetBuffer.writeShort(this.rgb.getGreen());
        packetBuffer.writeBoolean(this.rainbow);
        return packetBuffer;
    }

    public boolean isRainbow() {
        return this.rainbow;
    }

    public void setRainbow(boolean rainbow) {
        this.rainbow = rainbow;
    }

    public RGB getRgb() {
        return this.rgb;
    }

    public void setRgb(RGB rgb) {
        this.rgb = rgb;
    }
}

