/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.screen;

import com.denfop.IUItem;
import com.denfop.api.bee.Product;
import com.denfop.api.bee.genetics.GeneticTraits;
import com.denfop.api.widget.AdvancedTooltipWidget;
import com.denfop.api.widget.ScrollDirection;
import com.denfop.api.widget.TooltipWidget;
import com.denfop.blockentity.bee.BlockEntityApiary;
import com.denfop.containermenu.ContainerMenuApiary;
import com.denfop.screen.ScreenMain;
import com.denfop.utils.Localization;
import com.denfop.utils.ModUtils;
import com.google.common.base.Supplier;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ScreenApiary<T extends ContainerMenuApiary>
extends ScreenMain<ContainerMenuApiary> {
    public ContainerMenuApiary container;
    int indexGenome = 0;
    int maxIndexGenome = 3;
    int indexAdditionProducts = 0;
    int maxIndexAdditionProducts = 3;

    public ScreenApiary(ContainerMenuApiary container1) {
        super(container1);
        this.container = container1;
        this.componentList.clear();
        this.f_97726_ = 199;
        this.f_97727_ = 207;
        this.addWidget(new AdvancedTooltipWidget(this, 10, 21, 21, 69).withTooltip((Supplier<String>)((Supplier)() -> ModUtils.getString(((BlockEntityApiary)container1.base).food))));
        this.addWidget(new AdvancedTooltipWidget(this, 154, 21, 165, 69).withTooltip((Supplier<String>)((Supplier)() -> ModUtils.getString(((BlockEntityApiary)container1.base).royalJelly))));
        this.addWidget(new AdvancedTooltipWidget(this, 37, 22, 50, 32).withTooltip((Supplier<String>)((Supplier)() -> ModUtils.getString(((BlockEntityApiary)container1.base).workers))));
        this.addWidget(new AdvancedTooltipWidget(this, 37, 35, 50, 49).withTooltip((Supplier<String>)((Supplier)() -> ModUtils.getString(((BlockEntityApiary)container1.base).doctors))));
        this.addWidget(new AdvancedTooltipWidget(this, 37, 51, 50, 64).withTooltip((Supplier<String>)((Supplier)() -> ModUtils.getString(((BlockEntityApiary)container1.base).builders))));
        this.addWidget(new AdvancedTooltipWidget(this, 37, 67, 50, 80).withTooltip((Supplier<String>)((Supplier)() -> ModUtils.getString(((BlockEntityApiary)container1.base).attacks))));
        this.addWidget(new AdvancedTooltipWidget(this, 37, 83, 50, 94).withTooltip((Supplier<String>)((Supplier)() -> ModUtils.getString(((BlockEntityApiary)container1.base).ill))));
        this.addWidget(new AdvancedTooltipWidget(this, 37, 97, 50, 109).withTooltip((Supplier<String>)((Supplier)() -> ModUtils.getString(((BlockEntityApiary)container1.base).birth) + "/" + ModUtils.getString(((BlockEntityApiary)container1.base).death))));
    }

    @Override
    public boolean m_6050_(double d, double d2, double d3) {
        ScrollDirection scrollDirection = d3 != 0.0 ? (d3 < 0.0 ? ScrollDirection.down : ScrollDirection.up) : ScrollDirection.stopped;
        int mouseX = (int)(d - (double)this.guiLeft);
        int mouseY = (int)(d2 - (double)this.guiTop);
        if (mouseX >= 174 && mouseX <= 194 && mouseY >= 4 && (double)mouseY <= 58.4) {
            if (scrollDirection == ScrollDirection.up) {
                --this.indexGenome;
                if (this.indexGenome < 0) {
                    this.indexGenome = 0;
                }
            }
            if (scrollDirection == ScrollDirection.down) {
                ++this.indexGenome;
                if (this.indexGenome > this.maxIndexGenome - 3) {
                    this.indexGenome = this.maxIndexGenome - 3;
                    this.indexGenome = Math.max(0, this.indexGenome);
                }
            }
        }
        if (mouseX >= 174 && mouseX <= 194 && (double)mouseY >= 60.0 && (double)mouseY <= 128.0) {
            if (scrollDirection == ScrollDirection.up) {
                --this.indexAdditionProducts;
                if (this.indexAdditionProducts < 0) {
                    this.indexAdditionProducts = 0;
                }
            }
            if (scrollDirection == ScrollDirection.down) {
                ++this.indexAdditionProducts;
                if (this.indexAdditionProducts > this.maxIndexAdditionProducts - 3) {
                    this.indexAdditionProducts = this.maxIndexAdditionProducts - 3;
                    this.indexAdditionProducts = Math.max(0, this.indexAdditionProducts);
                }
            }
        }
        return super.m_6050_(d, d2, d3);
    }

    private void handleUpgradeTooltip(int mouseX, int mouseY) {
        if (mouseX >= 3 && mouseX <= 13 && mouseY >= 3 && mouseY <= 13) {
            ArrayList<String> text = new ArrayList<String>();
            text.add(Localization.translate("iu.bee.info"));
            ArrayList<String> compatibleUpgrades = new ArrayList<String>();
            for (int i = 1; i < 21; ++i) {
                compatibleUpgrades.add(Localization.translate("iu.bee.info" + i));
            }
            for (String itemstack : compatibleUpgrades) {
                text.add(itemstack);
            }
            this.drawTooltip(mouseX - 160, mouseY, text);
        }
    }

    @Override
    protected void drawForegroundLayer(GuiGraphics poseStack, int par1, int par2) {
        super.drawForegroundLayer(poseStack, par1, par2);
        if (((BlockEntityApiary)this.container.base).getQueen() == null) {
            return;
        }
        if (((BlockEntityApiary)this.container.base).getGenome() != null) {
            int i;
            int j;
            List<GeneticTraits> values = ((BlockEntityApiary)this.container.base).getGenome().getGeneticTraitsMap().values().stream().toList();
            this.maxIndexGenome = values.size();
            List<Product> products = ((BlockEntityApiary)this.container.base).getQueen().getProduct();
            this.maxIndexAdditionProducts = products.size();
            if (this.maxIndexGenome == 0) {
                this.addWidget(new TooltipWidget(this, 174, 4, 20, 76).withTooltip((Supplier<String>)((Supplier)() -> Localization.translate("iu.apiary_genome_descriptions"))));
            } else {
                j = 0;
                i = this.indexGenome;
                while (i < Math.min(this.indexGenome + 3, this.maxIndexGenome)) {
                    int finalI = i++;
                    this.addWidget(new TooltipWidget(this, 176, 8 + 16 * j, 16, 16).withTooltip((Supplier<String>)((Supplier)() -> Localization.translate("iu.info.bee_genome_" + ((GeneticTraits)((Object)((Object)values.get(finalI)))).name().toLowerCase()))));
                    ++j;
                }
            }
            if (this.maxIndexAdditionProducts == 0) {
                this.addWidget(new TooltipWidget(this, 174, 60, 20, 76).withTooltip((Supplier<String>)((Supplier)() -> Localization.translate("iu.apiary_additional_product_descriptions"))));
            } else {
                j = 0;
                i = this.indexAdditionProducts;
                while (i < Math.min((this.indexAdditionProducts + 1) * 3, this.maxIndexAdditionProducts)) {
                    Product product = products.get(i);
                    this.addWidget(new TooltipWidget(this, 176, (int)(8.0 + 16.0 * ((double)j + 3.5)), 16, 16).withTooltip((Supplier<String>)((Supplier)() -> product.getCrop().getDrop().get(0).m_41611_().getString() + "\n" + Localization.translate("iu.space_chance") + " " + ModUtils.getString(product.getChance() / 3.0) + "%")));
                    ++i;
                    ++j;
                }
            }
        }
        this.handleUpgradeTooltip(par1, par2);
    }

    @Override
    protected ResourceLocation getTexture() {
        return new ResourceLocation("industrialupgrade", "textures/gui/guiapiary.png");
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(GuiGraphics poseStack, float f, int x, int y) {
        super.drawGuiContainerBackgroundLayer(poseStack, f, x, y);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (((BlockEntityApiary)this.container.base).getQueen() == null) {
            return;
        }
        if (((BlockEntityApiary)this.container.base).getGenome() != null) {
            List<GeneticTraits> values = ((BlockEntityApiary)this.container.base).getGenome().getGeneticTraitsMap().values().stream().toList();
            this.maxIndexGenome = values.size();
            int j = 0;
            int i = this.indexGenome;
            while (i < Math.min(this.indexGenome + 3, this.maxIndexGenome)) {
                GeneticTraits geneticTraits = values.get(i);
                RenderSystem.enableBlend();
                poseStack.m_280480_(new ItemStack((ItemLike)IUItem.genome_bee.getStack(geneticTraits.ordinal()), 1), 176 + this.guiLeft(), 8 + 16 * j + this.guiTop());
                RenderSystem.disableBlend();
                ++i;
                ++j;
            }
            j = 0;
            List<Product> products = ((BlockEntityApiary)this.container.base).getQueen().getProduct();
            this.maxIndexAdditionProducts = products.size();
            int i2 = this.indexAdditionProducts;
            while (i2 < Math.min((this.indexAdditionProducts + 1) * 3, this.maxIndexAdditionProducts)) {
                Product product = products.get(i2);
                RenderSystem.enableBlend();
                poseStack.m_280480_(product.getCrop().getDrop().get(0), 176 + this.guiLeft(), (int)(8.0 + 16.0 * ((double)j + 3.5) + (double)this.guiTop()));
                RenderSystem.disableBlend();
                ++i2;
                ++j;
            }
        }
        this.bindTexture();
        switch (((BlockEntityApiary)this.container.base).task) {
            case 0: {
                this.drawTexturedModalRect(poseStack, this.guiLeft + 60, this.guiTop + 24, 249, 1, 6, 6);
                break;
            }
            case 1: {
                this.drawTexturedModalRect(poseStack, this.guiLeft + 60, this.guiTop + 71, 249, 1, 6, 6);
                break;
            }
            case 2: {
                this.drawTexturedModalRect(poseStack, this.guiLeft + 60, this.guiTop + 39, 249, 1, 6, 6);
                break;
            }
            case 3: {
                this.drawTexturedModalRect(poseStack, this.guiLeft + 60, this.guiTop + 55, 249, 1, 6, 6);
            }
        }
        if (((BlockEntityApiary)this.container.base).deathTask == 1) {
            this.drawTexturedModalRect(poseStack, this.guiLeft + 60, this.guiTop + 101, 249, 1, 6, 6);
        }
        if (((BlockEntityApiary)this.container.base).illTask == 1) {
            this.drawTexturedModalRect(poseStack, this.guiLeft + 60, this.guiTop + 86, 249, 1, 6, 6);
        }
        int renderHeight = (int)(49.0 * ModUtils.limit(((BlockEntityApiary)this.container.base).food / ((double)((BlockEntityApiary)this.container.base).maxFood * 1.0), 0.0, 1.0));
        this.drawTexturedModalRect(poseStack, this.guiLeft + 10, this.guiTop + 20 + 50 - renderHeight, 236, 50 - renderHeight, 12, renderHeight);
        renderHeight = (int)(49.0 * ModUtils.limit(((BlockEntityApiary)this.container.base).royalJelly / ((double)((BlockEntityApiary)this.container.base).maxJelly * 1.0), 0.0, 1.0));
        this.drawTexturedModalRect(poseStack, this.guiLeft + 154, this.guiTop + 20 + 50 - renderHeight, 223, 50 - renderHeight, 12, renderHeight);
        ScreenApiary.bindTexture(new ResourceLocation("industrialupgrade", "textures/gui/infobutton.png"));
        this.drawTexturedRect(poseStack, 3.0, 3.0, 10.0, 10.0, 0.0, 0.0);
    }
}

