/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.screen;

import com.denfop.api.recipe.InventoryBioMultiRecipes;
import com.denfop.api.widget.EnumTypeComponent;
import com.denfop.api.widget.ScreenWidget;
import com.denfop.api.widget.WidgetDefault;
import com.denfop.blockentity.base.BlockEntityBioMultiMachine;
import com.denfop.blockentity.mechanism.EnumTypeMachines;
import com.denfop.componets.ComponentBioFuelEnergy;
import com.denfop.componets.ComponentBioProcessRender;
import com.denfop.componets.EnumTypeStyle;
import com.denfop.componets.Fluids;
import com.denfop.componets.HeatComponent;
import com.denfop.containermenu.ContainerMenuBioMultiMachine;
import com.denfop.containermenu.SlotInvSlot;
import com.denfop.screen.ScreenMain;
import com.denfop.utils.Localization;
import com.denfop.utils.ModUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.Slot;

public class ScreenBioMultiMachine<T extends ContainerMenuBioMultiMachine>
extends ScreenMain<ContainerMenuBioMultiMachine> {
    private final ContainerMenuBioMultiMachine container;
    private final ScreenWidget process;

    public ScreenBioMultiMachine(ContainerMenuBioMultiMachine container1) {
        super(container1, EnumTypeStyle.BIO);
        this.container = container1;
        this.process = new ScreenWidget(this, 0, 0, EnumTypeComponent.BIO_MULTI_PROCESS, new WidgetDefault<ComponentBioProcessRender>(new ComponentBioProcessRender(((BlockEntityBioMultiMachine)container1.base).multi_process, ((BlockEntityBioMultiMachine)container1.base).getTypeMachine())));
        this.addComponent(new ScreenWidget(this, 7, 64, EnumTypeComponent.BIO_FLUID, new WidgetDefault<ComponentBioFuelEnergy>(((BlockEntityBioMultiMachine)this.container.base).bioFuel)));
        this.f_97726_ = 192;
        if (((BlockEntityBioMultiMachine)this.container.base).tank != null) {
            this.addComponent(new ScreenWidget(this, 27, 63, EnumTypeComponent.WATER, new WidgetDefault<Fluids.InternalFluidTank>(((BlockEntityBioMultiMachine)this.container.base).tank)));
        }
        if (((BlockEntityBioMultiMachine)this.container.base).getMachine().type == EnumTypeMachines.Centrifuge) {
            this.addComponent(new ScreenWidget(this, 27, 63, EnumTypeComponent.COLD, new WidgetDefault<HeatComponent>(((BlockEntityBioMultiMachine)this.container.base).heat)));
        }
    }

    private void handleUpgradeTooltip(int mouseX, int mouseY) {
        if (mouseX >= 3 && mouseX <= 13 && mouseY >= 3 && mouseY <= 13) {
            ArrayList<String> text = new ArrayList<String>();
            text.add(Localization.translate("bio_machine.info"));
            ArrayList<String> compatibleUpgrades = new ArrayList<String>();
            for (int i = 1; i < 9; ++i) {
                compatibleUpgrades.add(Localization.translate("bio_machine.info" + i));
            }
            for (String itemstack : compatibleUpgrades) {
                text.add(itemstack);
            }
            this.drawTooltip(mouseX - 100, mouseY, text);
        }
    }

    @Override
    protected void drawForegroundLayer(GuiGraphics poseStack, int mouseX, int mouseY) {
        super.drawForegroundLayer(poseStack, mouseX, mouseY);
        this.drawForeground(poseStack, mouseX, mouseY);
        this.handleUpgradeTooltip(mouseX, mouseY);
        int i = 0;
        for (Slot slot : this.container.f_38839_) {
            if (!(slot instanceof SlotInvSlot)) continue;
            int xX = slot.f_40220_;
            int yY = slot.f_40221_;
            SlotInvSlot slotInv = (SlotInvSlot)slot;
            if (!(slotInv.inventory instanceof InventoryBioMultiRecipes)) continue;
            this.process.setIndex(i);
            this.process.m_252865_(xX);
            this.process.m_253211_(yY + 19);
            this.process.drawForeground(poseStack, mouseX, mouseY);
            ++i;
        }
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(GuiGraphics poseStack, float f, int x, int y) {
        super.drawGuiContainerBackgroundLayer(poseStack, f, x, y);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ScreenBioMultiMachine.bindTexture(this.getTexture());
        int j = this.guiLeft;
        int k = this.guiTop;
        this.drawTexturedModalRect(poseStack, j, k, 0, 0, 176, this.f_97727_);
        int xoffset = this.guiLeft;
        int yoffset = this.guiTop;
        this.drawBackground(poseStack);
        int i = 0;
        for (Slot slot : this.container.f_38839_) {
            if (!(slot instanceof SlotInvSlot)) continue;
            int xX = slot.f_40220_;
            int yY = slot.f_40221_;
            SlotInvSlot slotInv = (SlotInvSlot)slot;
            if (!(slotInv.inventory instanceof InventoryBioMultiRecipes)) continue;
            this.process.setIndex(i);
            this.process.m_252865_(xX);
            this.process.m_253211_(yY + 19);
            this.process.drawBackground(poseStack, xoffset, yoffset);
            ++i;
        }
        ScreenBioMultiMachine.bindTexture(this.getTexture());
        if (!this.isBlack) {
            this.drawXCenteredString(poseStack, 88, 6, Localization.translate(((BlockEntityBioMultiMachine)this.container.base).getName()), 0x404040, false);
        } else {
            this.drawXCenteredString(poseStack, 88, 6, Localization.translate(((BlockEntityBioMultiMachine)this.container.base).getName()), ModUtils.convertRGBcolorToInt(216, 216, 216), false);
        }
        for (ScreenWidget guiElement : this.elements) {
            guiElement.drawBackground(poseStack, this.guiLeft, this.guiTop);
        }
        ScreenBioMultiMachine.bindTexture(new ResourceLocation("industrialupgrade", "textures/gui/infobutton.png"));
        this.drawTexturedRect(poseStack, 3.0, 3.0, 10.0, 10.0, 0.0, 0.0);
    }

    @Override
    public ResourceLocation getTexture() {
        return new ResourceLocation("industrialupgrade", "textures/gui/guibio_machine.png");
    }
}

