/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.screen;

import com.denfop.api.sound.AudioFixer;
import com.denfop.api.widget.AdvancedTooltipWidget;
import com.denfop.api.widget.EnumTypeComponent;
import com.denfop.api.widget.ScreenWidget;
import com.denfop.api.widget.WidgetDefault;
import com.denfop.blockentity.base.BlockEntityBase;
import com.denfop.blockentity.base.BlockEntityFisher;
import com.denfop.blockentity.base.BlockEntityInventory;
import com.denfop.componets.ComponentProgress;
import com.denfop.componets.ComponentSoundButton;
import com.denfop.componets.Energy;
import com.denfop.containermenu.ContainerMenuFisher;
import com.denfop.screen.ScreenMain;
import com.denfop.utils.ListInformationUtils;
import com.denfop.utils.Localization;
import com.denfop.utils.ModUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ScreenFisher<T extends ContainerMenuFisher>
extends ScreenMain<ContainerMenuFisher> {
    public final ContainerMenuFisher container;

    public ScreenFisher(ContainerMenuFisher container1) {
        super(container1);
        this.container = container1;
        this.addComponent(new ScreenWidget(this, 5, 20, EnumTypeComponent.SOUND_BUTTON, new WidgetDefault<ComponentSoundButton>(new ComponentSoundButton((BlockEntityBase)((Object)this.container.base), 10, (AudioFixer)((Object)this.container.base)))));
        this.addComponent(new ScreenWidget(this, 146, 28, EnumTypeComponent.ENERGY_HEIGHT, new WidgetDefault<Energy>(((BlockEntityFisher)this.container.base).energy)));
        this.addComponent(new ScreenWidget(this, 41, 45, EnumTypeComponent.PROGRESS4, new WidgetDefault<1>(new ComponentProgress((BlockEntityInventory)this.container.base, 1, 0){

            @Override
            public double getBar() {
                return (double)((BlockEntityFisher)ScreenFisher.this.container.base).progress / 100.0;
            }
        })));
    }

    @Override
    protected void drawForegroundLayer(GuiGraphics poseStack, int par1, int par2) {
        this.drawForeground(poseStack, par1, par2);
        this.draw(poseStack, this.getName(), (int)((float)(this.f_97726_ - this.getStringWidth(this.getName())) / 2.0f), 6, 0x404040);
        this.handleUpgradeTooltip(par1, par2);
        String tooltip2 = ModUtils.getString(Math.min(((BlockEntityFisher)this.container.base).energy.getEnergy(), ((BlockEntityFisher)this.container.base).energy.getCapacity())) + "/" + ModUtils.getString(((BlockEntityFisher)this.container.base).energy.getCapacity()) + " EF";
        String tooltip = ModUtils.getString(Math.min(((BlockEntityFisher)this.container.base).progress, 100)) + "%";
        new AdvancedTooltipWidget(this, 147, 27, 158, 76).withTooltip(tooltip2).drawForeground(poseStack, par1, par2);
        new AdvancedTooltipWidget(this, 41, 45, 55, 60).withTooltip(tooltip).drawForeground(poseStack, par1, par2);
    }

    private void handleUpgradeTooltip(int mouseX, int mouseY) {
        if (mouseX >= 3 && mouseX <= 15 && mouseY >= 3 && mouseY <= 15) {
            ArrayList<String> text = new ArrayList<String>();
            text.add(Localization.translate("iu.fisherinformation"));
            List<String> compatibleUpgrades = ListInformationUtils.fisherinform;
            for (String itemstack : compatibleUpgrades) {
                text.add(itemstack);
            }
            this.drawTooltip(mouseX, mouseY, text);
        }
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(GuiGraphics poseStack, float f, int x, int y) {
        ScreenFisher.bindTexture(this.getTexture());
        this.drawTexturedModalRect(poseStack, this.guiLeft(), this.guiTop(), 0, 0, this.f_97726_, this.f_97727_);
        this.drawBackground(poseStack);
        ScreenFisher.bindTexture(new ResourceLocation("industrialupgrade", "textures/gui/infobutton.png"));
        this.drawTexturedModalRect(poseStack, this.guiLeft() + 3, this.guiTop() + 3, 0, 0, 10, 10);
        ScreenFisher.bindTexture(this.getTexture());
        int chargeLevel = (int)(48.0 * ((BlockEntityFisher)this.container.base).energy.getEnergy() / ((BlockEntityFisher)this.container.base).energy.getCapacity());
        int progress = 15 * ((BlockEntityFisher)this.container.base).progress / 100;
        if (chargeLevel > 0) {
            this.drawTexturedModalRect(poseStack, this.guiLeft() + 140 + 1 + 5, this.guiTop() + 28 + 48 - chargeLevel, 176, 48 - chargeLevel, 48, chargeLevel);
        }
        if (progress > 0) {
            this.drawTexturedModalRect(poseStack, this.guiLeft() + 42, this.guiTop() + 46, 177, 48, progress + 1, 14);
        }
    }

    public String getName() {
        return Localization.translate(((BlockEntityFisher)this.container.base).getName());
    }

    @Override
    public ResourceLocation getTexture() {
        return new ResourceLocation("industrialupgrade", "textures/gui/guimachine.png");
    }
}

