/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.screen;

import com.denfop.api.energy.networking.EnergyNetGlobal;
import com.denfop.api.water.upgrade.RotorUpgradeSystem;
import com.denfop.api.widget.AdvancedTooltipWidget;
import com.denfop.api.widget.ItemStackWidget;
import com.denfop.api.widget.ScrollDirection;
import com.denfop.api.widget.TooltipWidget;
import com.denfop.api.windsystem.EnumTypeWind;
import com.denfop.api.windsystem.IWindMechanism;
import com.denfop.api.windsystem.WindSystem;
import com.denfop.blockentity.hydroturbine.BlockEntityHydroTurbineController;
import com.denfop.containermenu.ContainerMenuHydroTurbineController;
import com.denfop.network.packet.PacketUpdateServerTile;
import com.denfop.screen.ScreenMain;
import com.denfop.utils.ListInformationUtils;
import com.denfop.utils.Localization;
import com.denfop.utils.ModUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class ScreenHydroTurbineController<T extends ContainerMenuHydroTurbineController>
extends ScreenMain<ContainerMenuHydroTurbineController> {
    private final ResourceLocation background;
    public boolean hoverChangeSide;
    public boolean hoverChangePower;

    public ScreenHydroTurbineController(ContainerMenuHydroTurbineController guiContainer) {
        super(guiContainer, ((BlockEntityHydroTurbineController)guiContainer.base).getStyle());
        this.f_97727_ = 247;
        this.f_97726_ = 207;
        this.background = new ResourceLocation("industrialupgrade", "textures/gui/guiwater_turbine.png");
        this.inventory.m_253211_(159);
        this.inventory.m_252865_(22);
    }

    public void m_7856_() {
        super.m_7856_();
    }

    @Override
    protected void mouseClicked(int i, int j, int k) {
        super.mouseClicked(i, j, k);
        if (((BlockEntityHydroTurbineController)((ContainerMenuHydroTurbineController)this.container).base).getRotor() != null && this.hoverChangeSide) {
            new PacketUpdateServerTile((BlockEntity)((ContainerMenuHydroTurbineController)this.container).base, 0.0);
        }
    }

    @Override
    public boolean m_6050_(double d, double d2, double d3) {
        ScrollDirection scrollDirection = d3 != 0.0 ? (d3 < 0.0 ? ScrollDirection.down : ScrollDirection.up) : ScrollDirection.stopped;
        int mouseX = (int)(d - (double)this.guiLeft);
        int mouseY = (int)(d2 - (double)this.guiTop);
        if (mouseX >= 35 && mouseX <= 171 && mouseY >= 118 && mouseY <= 124) {
            new PacketUpdateServerTile((BlockEntity)((ContainerMenuHydroTurbineController)this.container).base, (double)((BlockEntityHydroTurbineController)((ContainerMenuHydroTurbineController)this.container).base).coefficient_power + d3);
            this.hoverChangePower = true;
        }
        return super.m_6050_(d, d2, d3);
    }

    private void handleUpgradeTooltip(int mouseX, int mouseY) {
        if (mouseX >= 3 && mouseX <= 15 && mouseY >= 3 && mouseY <= 15) {
            ArrayList<String> text = new ArrayList<String>();
            text.add(Localization.translate("iu.water_generator.info_main"));
            List<String> compatibleUpgrades = ListInformationUtils.water_generator;
            for (String itemstack : compatibleUpgrades) {
                text.add(itemstack);
            }
            this.drawTooltip(mouseX, mouseY, text);
        }
    }

    @Override
    protected void drawBackgroundAndTitle(GuiGraphics poseStack, float partialTicks, int mouseX, int mouseY) {
        this.bindTexture();
        poseStack.m_280218_(currentTexture, this.getGuiLeft(), this.getGuiTop(), 0, 0, this.getXSize(), this.getYSize());
        String name = ((BlockEntityHydroTurbineController)((ContainerMenuHydroTurbineController)this.container).base).m_5446_().getString();
        int textWidth = this.getStringWidth(name);
        float scale = 1.0f;
        if (textWidth > 120) {
            scale = 120.0f / (float)textWidth;
        }
        PoseStack pose = poseStack.m_280168_();
        pose.m_85836_();
        pose.m_85841_(scale, scale, 1.0f);
        int centerX = this.guiLeft + this.f_97726_ / 2;
        int textX = (int)((float)centerX / scale - (float)textWidth / 2.0f);
        int textY = (int)((float)(this.guiTop + 3) / scale);
        poseStack.m_280056_(Minecraft.m_91087_().f_91062_, name, textX, textY, 0x404040, false);
        pose.m_85841_(1.0f / scale, 1.0f / scale, 1.0f);
        pose.m_85849_();
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(GuiGraphics poseStack, float partialTicks, int mouseX, int mouseY) {
        super.drawGuiContainerBackgroundLayer(poseStack, partialTicks, mouseX, mouseY);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.bindTexture();
        int xoffset = this.guiLeft;
        int yoffset = this.guiTop;
        ScreenHydroTurbineController.bindTexture(new ResourceLocation("industrialupgrade", "textures/gui/infobutton.png"));
        this.drawTexturedModalRect(poseStack, xoffset + 3, yoffset + 3, 0, 0, 10, 10);
        this.bindTexture();
        this.drawTexturedModalRect(poseStack, (int)((double)(xoffset + 34) + (double)(((BlockEntityHydroTurbineController)((ContainerMenuHydroTurbineController)this.container).base).coefficient_power - 100) / 50.0 * 130.0), yoffset + 116, 235, 0, 10, 12);
        if (this.hoverChangePower) {
            this.drawTexturedModalRect(poseStack, (int)((double)(xoffset + 34) + (double)(((BlockEntityHydroTurbineController)((ContainerMenuHydroTurbineController)this.container).base).coefficient_power - 100) / 50.0 * 130.0), yoffset + 116, 246, 0, 10, 12);
        }
        this.hoverChangePower = false;
        if (!((BlockEntityHydroTurbineController)((ContainerMenuHydroTurbineController)this.container).base).slot.m_7983_()) {
            List<ItemStack> list = RotorUpgradeSystem.instance.getListStack(((BlockEntityHydroTurbineController)((ContainerMenuHydroTurbineController)this.container).base).slot.get(0));
            int i = 0;
            for (ItemStack stack : list) {
                if (stack.m_41619_()) {
                    ++i;
                    continue;
                }
                new ItemStackWidget(this, 80 + i * 18, 134, () -> stack).drawBackground(poseStack, xoffset, yoffset);
                ++i;
            }
        }
        ScreenHydroTurbineController.bindTexture(this.getTexture());
        ItemStack rotor = ((BlockEntityHydroTurbineController)((ContainerMenuHydroTurbineController)this.container).base).slot.get(0);
        if ((double)rotor.m_41773_() >= (double)rotor.m_41776_() * 0.25) {
            this.drawTexturedModalRect(poseStack, this.guiLeft + 46, this.guiTop + 137, 245, 34, 11, 11);
        }
        if (((BlockEntityHydroTurbineController)((ContainerMenuHydroTurbineController)this.container).base).getRotor() != null) {
            double renderHeight;
            int windHeight = 74;
            double bar = renderHeight = (double)windHeight * ModUtils.limit(Math.min(24.4 + (double)((BlockEntityHydroTurbineController)((ContainerMenuHydroTurbineController)this.container).base).mind_speed, WindSystem.windSystem.getSpeedFromWaterPower(((BlockEntityHydroTurbineController)((ContainerMenuHydroTurbineController)this.container).base).m_58899_(), (IWindMechanism)((Object)((ContainerMenuHydroTurbineController)this.container).base), ((BlockEntityHydroTurbineController)((ContainerMenuHydroTurbineController)this.container).base).generation / ((double)((BlockEntityHydroTurbineController)((ContainerMenuHydroTurbineController)this.container).base).coefficient_power / 100.0)) * ((BlockEntityHydroTurbineController)((ContainerMenuHydroTurbineController)this.container).base).getCoefficient()) / 24.4, 0.0, 1.0);
            this.drawTexturedModalRect(poseStack, this.guiLeft + 11, (int)((double)(this.guiTop + 15 + windHeight) - bar), 236, (int)(120.0 - bar), 9, (int)bar);
            windHeight = 74;
            bar = renderHeight = (double)windHeight * ((BlockEntityHydroTurbineController)((ContainerMenuHydroTurbineController)this.container).base).energy.getEnergy().getFillRatio();
            this.drawTexturedModalRect(poseStack, this.guiLeft + 186, (int)((double)(this.guiTop + 15 + windHeight) - bar), 247, (int)(120.0 - bar), 9, (int)bar);
            if (this.hoverChangeSide) {
                this.drawTexturedModalRect(poseStack, this.guiLeft + 157, this.guiTop + 133, 236, 13, 20, 20);
            }
        }
    }

    @Override
    protected void drawForegroundLayer(GuiGraphics poseStack, int mouseX, int mouseY) {
        Object fields;
        super.drawForegroundLayer(poseStack, mouseX, mouseY);
        this.handleUpgradeTooltip(mouseX, mouseY);
        this.hoverChangeSide = false;
        if (mouseX >= 157 && mouseY >= 133 && mouseX <= 176 && mouseY <= 152) {
            this.hoverChangeSide = true;
        }
        if (((BlockEntityHydroTurbineController)((ContainerMenuHydroTurbineController)this.container).base).getWorld().m_46472_() == Level.f_46428_) {
            fields = "";
            fields = ((BlockEntityHydroTurbineController)((ContainerMenuHydroTurbineController)this.container).base).getMinWind() != 0 ? (String)fields + Localization.translate("iu.water_meter.info") + String.format("%.1f", Math.min(24.7 + (double)((BlockEntityHydroTurbineController)((ContainerMenuHydroTurbineController)this.container).base).mind_speed, WindSystem.windSystem.getSpeedFromWaterPower(((BlockEntityHydroTurbineController)((ContainerMenuHydroTurbineController)this.container).base).m_58899_(), (IWindMechanism)((Object)((ContainerMenuHydroTurbineController)this.container).base), ((BlockEntityHydroTurbineController)((ContainerMenuHydroTurbineController)this.container).base).generation / ((double)((BlockEntityHydroTurbineController)((ContainerMenuHydroTurbineController)this.container).base).coefficient_power / 100.0)) / ((BlockEntityHydroTurbineController)((ContainerMenuHydroTurbineController)this.container).base).getCoefficient())) + " m/s" : (String)fields + Localization.translate("iu.water_meter.info") + String.format("%.1f", ((BlockEntityHydroTurbineController)((ContainerMenuHydroTurbineController)this.container).base).wind_speed + (double)((BlockEntityHydroTurbineController)((ContainerMenuHydroTurbineController)this.container).base).mind_speed) + " m/s";
            PoseStack pose = poseStack.m_280168_();
            pose.m_85836_();
            pose.m_252880_((float)(175 - this.getStringWidth((String)fields)), 100.0f, 0.0f);
            pose.m_85841_(0.85f, 0.85f, 1.0f);
            this.draw(poseStack, (String)fields, 0, 0, ModUtils.convertRGBcolorToInt(13, 229, 34));
            pose.m_85849_();
        }
        if (!((BlockEntityHydroTurbineController)((ContainerMenuHydroTurbineController)this.container).base).slot.m_7983_()) {
            List<ItemStack> list = RotorUpgradeSystem.instance.getListStack(((BlockEntityHydroTurbineController)((ContainerMenuHydroTurbineController)this.container).base).slot.get(0));
            int i = 0;
            for (ItemStack stack : list) {
                if (stack.m_41619_()) {
                    ++i;
                    continue;
                }
                new AdvancedTooltipWidget(this, 80 + i * 18, 134, 80 + i * 18 + 18, 152).withTooltip(stack.m_41611_().getString()).drawForeground(poseStack, mouseX, mouseY);
                ++i;
            }
        }
        if (((BlockEntityHydroTurbineController)((ContainerMenuHydroTurbineController)this.container).base).getRotor() != null) {
            if (((BlockEntityHydroTurbineController)((ContainerMenuHydroTurbineController)this.container).base).wind_side == null) {
                return;
            }
            fields = Localization.translate("iu.water_side") + Localization.translate("iu.wind." + ((BlockEntityHydroTurbineController)((ContainerMenuHydroTurbineController)this.container).base).wind_side.name().toLowerCase());
            if (((BlockEntityHydroTurbineController)((ContainerMenuHydroTurbineController)this.container).base).getRotorSide() != null) {
                fields = (String)fields + "\n" + Localization.translate("iu.wind_mec_side") + Localization.translate("iu.wind." + ((BlockEntityHydroTurbineController)((ContainerMenuHydroTurbineController)this.container).base).getRotorSide().name().toLowerCase());
            }
            fields = (String)fields + "\n" + Localization.translate("iu.wind_gen") + ModUtils.getString(((BlockEntityHydroTurbineController)((ContainerMenuHydroTurbineController)this.container).base).generation) + " EF/t";
            fields = (String)fields + "\n" + Localization.translate("iu.water_coef") + String.format("%.2f", ((BlockEntityHydroTurbineController)((ContainerMenuHydroTurbineController)this.container).base).getCoefficient());
            fields = (String)fields + "\n" + Localization.translate("iu.wind_tier") + String.format("%d", ((BlockEntityHydroTurbineController)((ContainerMenuHydroTurbineController)this.container).base).getRotor().getLevel());
            if (((BlockEntityHydroTurbineController)((ContainerMenuHydroTurbineController)this.container).base).enumTypeWind != null) {
                int meta = Math.min(((BlockEntityHydroTurbineController)((ContainerMenuHydroTurbineController)this.container).base).enumTypeWind.ordinal() + ((BlockEntityHydroTurbineController)((ContainerMenuHydroTurbineController)this.container).base).getMinWind(), 9);
                WindSystem.windSystem.getEnumTypeWind();
                EnumTypeWind enumTypeWinds = EnumTypeWind.values()[meta];
                fields = (String)fields + "\n" + Localization.translate("iu.wind_level_info") + String.format("%d", enumTypeWinds.ordinal() + 1);
                double hours = 0.0;
                double minutes = 0.0;
                double seconds = 0.0;
                List<Double> time = ModUtils.Time((double)((BlockEntityHydroTurbineController)((ContainerMenuHydroTurbineController)this.container).base).timers / 20.0);
                if (!time.isEmpty()) {
                    hours = time.get(0);
                    minutes = time.get(1);
                    seconds = time.get(2);
                }
                String time1 = hours > 0.0 ? ModUtils.getString(hours) + Localization.translate("iu.hour") : "";
                String time2 = minutes > 0.0 ? ModUtils.getString(minutes) + Localization.translate("iu.minutes") : "";
                String time3 = seconds > 0.0 ? ModUtils.getString(seconds) + Localization.translate("iu.seconds") : "";
                fields = (String)fields + "\n" + Localization.translate("iu.wind_change_time") + time1 + time2 + time3;
                String tooltip3 = Localization.translate("iu.wind_meter.info") + String.format("%.1f", enumTypeWinds.getMin() + (double)((BlockEntityHydroTurbineController)((ContainerMenuHydroTurbineController)this.container).base).getMinWindSpeed()) + "-" + String.format("%.1f", enumTypeWinds.getMax() + (double)((BlockEntityHydroTurbineController)((ContainerMenuHydroTurbineController)this.container).base).getMinWindSpeed()) + " m/s";
                new AdvancedTooltipWidget(this, 9, 12, 23, 91).withTooltip(tooltip3).drawForeground(poseStack, mouseX, mouseY);
            }
            new AdvancedTooltipWidget(this, 35, 117, 172, 125).withTooltip(((BlockEntityHydroTurbineController)((ContainerMenuHydroTurbineController)this.container).base).coefficient_power + "%").drawForeground(poseStack, mouseX, mouseY);
            new AdvancedTooltipWidget(this, 183, 12, 197, 91).withTooltip(ModUtils.getString(Math.min(((BlockEntityHydroTurbineController)((ContainerMenuHydroTurbineController)this.container).base).energy.getEnergy().getEnergy(), ((BlockEntityHydroTurbineController)((ContainerMenuHydroTurbineController)this.container).base).energy.getEnergy().getCapacity())) + "/" + ModUtils.getString(((BlockEntityHydroTurbineController)((ContainerMenuHydroTurbineController)this.container).base).energy.getEnergy().getCapacity()) + " EF\n" + Localization.translate("EUStorage.gui.info.output", ModUtils.getString(EnergyNetGlobal.instance.getPowerFromTier(((BlockEntityHydroTurbineController)((ContainerMenuHydroTurbineController)this.container).base).energy.getEnergy().getSourceTier())))).drawForeground(poseStack, mouseX, mouseY);
            ItemStack rotor = ((BlockEntityHydroTurbineController)((ContainerMenuHydroTurbineController)this.container).base).slot.get(0);
            if ((double)rotor.m_41773_() >= (double)rotor.m_41776_() * 0.25) {
                new TooltipWidget(this, 46, 137, 11, 11).withTooltip(Localization.translate("iu.wind.repair")).drawForeground(poseStack, mouseX, mouseY);
            }
            float scale = 1.0f;
            List<String> lines = this.wrapTextWithNewlines((String)fields, 255);
            int y = 0;
            for (String line : lines) {
                PoseStack poseStack1 = poseStack.m_280168_();
                poseStack1.m_85836_();
                poseStack1.m_252880_(32.0f, (float)(20 + y), 0.0f);
                poseStack1.m_85841_(0.7f, 0.7f, 1.0f);
                this.draw(poseStack, line, 0, 0, ModUtils.convertRGBcolorToInt(13, 229, 34));
                poseStack1.m_85849_();
                y += 10;
            }
        }
    }

    @Override
    protected ResourceLocation getTexture() {
        return this.background;
    }
}

