/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.screen;

import com.denfop.api.widget.AdvancedTooltipWidget;
import com.denfop.api.widget.TooltipWidget;
import com.denfop.blockentity.base.BlockEntityBaseWorldCollector;
import com.denfop.containermenu.ContainerMenuWorldCollector;
import com.denfop.screen.ScreenIndustrialUpgrade;
import com.denfop.utils.Localization;
import com.denfop.utils.ModUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;

public class ScreenWolrdCollector<T extends ContainerMenuWorldCollector>
extends ScreenIndustrialUpgrade<ContainerMenuWorldCollector> {
    public final ContainerMenuWorldCollector container;

    public ScreenWolrdCollector(ContainerMenuWorldCollector container1) {
        super(container1);
        this.container = container1;
    }

    @Override
    protected void drawForegroundLayer(GuiGraphics poseStack, int par1, int par2) {
        super.drawForegroundLayer(poseStack, par1, par2);
        String tooltip2 = ModUtils.getString(((BlockEntityBaseWorldCollector)this.container.base).matter_energy) + "/" + ModUtils.getString(((BlockEntityBaseWorldCollector)this.container.base).max_matter_energy) + " ME";
        new AdvancedTooltipWidget(this, 29, 15, 38, 70).withTooltip(tooltip2).drawForeground(poseStack, par1, par2);
        new TooltipWidget(this, 66, 34, 34, 18).withTooltip(Localization.translate("gui.MolecularTransformer.progress") + ": " + (int)(Math.min(((BlockEntityBaseWorldCollector)this.container.base).guiProgress, 1.0) * 100.0) + "%").drawForeground(poseStack, par1, par2);
    }

    @Override
    protected void m_7286_(GuiGraphics poseStack, float f, int x, int y) {
        super.m_7286_(poseStack, f, x, y);
        ScreenWolrdCollector.bindTexture(this.getTexture());
        int chargeLevel = (int)(51.0 * ((BlockEntityBaseWorldCollector)this.container.base).matter_energy / ((BlockEntityBaseWorldCollector)this.container.base).max_matter_energy);
        int progress = (int)(34.0 * ((BlockEntityBaseWorldCollector)this.container.base).guiProgress);
        int xoffset = this.guiLeft;
        int yoffset = this.guiTop;
        if (chargeLevel > 0) {
            this.drawTexturedModalRect(poseStack, xoffset + 31, yoffset + 17 + 51 - chargeLevel, 179, 53 - chargeLevel, 5, chargeLevel);
        }
        if (progress > 0) {
            this.drawTexturedModalRect(poseStack, xoffset + 66, yoffset + 34, 177, 60, progress, 18);
        }
        ScreenWolrdCollector.bindTexture(new ResourceLocation("industrialupgrade", "textures/gui/infobutton.png"));
        this.drawTexturedRect(poseStack, 3.0, 3.0, 10.0, 10.0, 0.0, 0.0);
    }

    @Override
    public ResourceLocation getTexture() {
        switch (((BlockEntityBaseWorldCollector)this.container.base).enumTypeCollector) {
            case AQUA: {
                return new ResourceLocation("industrialupgrade", "textures/gui/guiwaterassembler.png");
            }
            case NETHER: {
                return new ResourceLocation("industrialupgrade", "textures/gui/guinetherassembler.png");
            }
            case EARTH: {
                return new ResourceLocation("industrialupgrade", "textures/gui/guiearthassembler.png");
            }
            case END: {
                return new ResourceLocation("industrialupgrade", "textures/gui/guiendassembler.png");
            }
            case AER: {
                return new ResourceLocation("industrialupgrade", "textures/gui/guiaerassembler.png");
            }
        }
        return new ResourceLocation("industrialupgrade", "textures/gui/guicrystallize.png");
    }
}

