/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.utils;

import com.denfop.IUCore;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;

public class DataEntities {
    List<EntityType<?>> entityList;
    Map<ResourceLocation, EntityType<?>> mapList = new HashMap();

    public DataEntities() {
        this.entityList = new ArrayList(ForgeRegistries.ENTITY_TYPES.getValues());
        this.entityList.forEach(entityType -> this.mapList.put(ForgeRegistries.ENTITY_TYPES.getKey(entityType), (EntityType<?>)entityType));
    }

    public boolean contains(ResourceLocation location) {
        return this.mapList.containsKey(location);
    }

    public EntityType<?> getTypeFromResourceLocation(ResourceLocation location) {
        return this.mapList.get(location);
    }

    public Entity createEntityByIDFromName(ResourceLocation entityId, Level world) {
        EntityType<?> entityType = this.mapList.get(entityId);
        return entityType == null ? null : entityType.m_20615_(world);
    }

    public Entity createEntityFromNBT(CompoundTag nbt, Level world) {
        ResourceLocation resourcelocation = new ResourceLocation(nbt.m_128461_("id"));
        Entity entity = this.createEntityByIDFromName(resourcelocation, world);
        if (entity == null) {
            IUCore.LOGGER.warn("Skipping Entity with id {}", (Object)resourcelocation);
        } else {
            try {
                entity.m_20258_(nbt);
            }
            catch (Exception e) {
                IUCore.LOGGER.error("An Entity {}({}) has thrown an exception during loading, its state cannot be restored. Report this to the mod author", new Object[]{nbt.m_128461_("id"), entity.m_7755_(), e});
                entity = null;
            }
        }
        return entity;
    }
}

