/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.world.vein.noise;

import java.util.Random;

public class PerlinNoise {
    private final int[] permutation = new int[512];

    public PerlinNoise(long seed) {
        int i;
        Integer[] p = new Integer[256];
        for (int i2 = 0; i2 < 256; ++i2) {
            p[i2] = i2;
        }
        Random random = new Random(seed);
        for (i = 255; i > 0; --i) {
            int index = random.nextInt(i + 1);
            int temp = p[i];
            p[i] = p[index];
            p[index] = temp;
        }
        for (i = 0; i < 512; ++i) {
            this.permutation[i] = p[i % 256];
        }
    }

    public PerlinNoise() {
        this(System.currentTimeMillis());
    }

    public double noise(double x, double y) {
        int X = (int)Math.floor(x) & 0xFF;
        int Y = (int)Math.floor(y) & 0xFF;
        x -= Math.floor(x);
        y -= Math.floor(y);
        double u = this.fade(x);
        double v = this.fade(y);
        int A = this.permutation[X] + Y;
        int B = this.permutation[X + 1] + Y;
        return this.lerp(v, this.lerp(u, this.grad(this.permutation[A], x, y), this.grad(this.permutation[B], x - 1.0, y)), this.lerp(u, this.grad(this.permutation[A + 1], x, y - 1.0), this.grad(this.permutation[B + 1], x - 1.0, y - 1.0)));
    }

    private double fade(double t) {
        return t * t * t * (t * (t * 6.0 - 15.0) + 10.0);
    }

    private double lerp(double t, double a, double b) {
        return a + t * (b - a);
    }

    private double grad(int hash, double x, double y) {
        int h = hash & 7;
        double u = h < 4 ? x : y;
        double v = h < 4 ? y : x;
        return ((h & 1) == 0 ? u : -u) + ((h & 2) == 0 ? v : -v);
    }
}

