/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.base;

import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.registries.ForgeRegistries;
import org.moddingx.libx.creativetab.CreativeTabItemProvider;
import org.moddingx.libx.mod.ModX;
import org.moddingx.libx.registration.Registerable;
import org.moddingx.libx.registration.RegistrationContext;

public class BlockBase
extends Block
implements Registerable,
CreativeTabItemProvider {
    protected final ModX mod;
    private final boolean hasItem;
    @Nullable
    private final Item item;

    public BlockBase(ModX mod, BlockBehaviour.Properties properties) {
        this(mod, properties, new Item.Properties());
    }

    public BlockBase(ModX mod, BlockBehaviour.Properties properties, @Nullable Item.Properties itemProperties) {
        super(properties);
        this.mod = mod;
        if (itemProperties == null) {
            this.hasItem = false;
            this.item = null;
        } else {
            this.hasItem = true;
            this.item = new BaseBlockItem(this, itemProperties);
        }
    }

    public void initializeItemClient(@Nonnull Consumer<IClientItemExtensions> consumer) {
    }

    public int getBurnTime(ItemStack stack, @Nullable RecipeType<?> recipeType) {
        return -1;
    }

    @Override
    public Stream<ItemStack> makeCreativeTabStacks() {
        return Stream.of(new ItemStack((ItemLike)this));
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public void registerAdditional(RegistrationContext ctx, Registerable.EntryCollector builder) {
        if (this.hasItem) {
            builder.register(Registries.f_256913_, this.item);
        }
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public void initTracking(RegistrationContext ctx, Registerable.TrackingCollector builder) throws ReflectiveOperationException {
        if (this.hasItem) {
            builder.track(ForgeRegistries.ITEMS, BlockBase.class.getDeclaredField("item"));
        }
    }

    private class BaseBlockItem
    extends BlockItem
    implements CreativeTabItemProvider {
        public BaseBlockItem(Block block, Item.Properties itemProperties) {
            super(block, itemProperties);
        }

        public void initializeClient(@Nonnull Consumer<IClientItemExtensions> consumer) {
            BlockBase.this.initializeItemClient(consumer);
        }

        public int getBurnTime(ItemStack stack, @Nullable RecipeType<?> recipeType) {
            return BlockBase.this.getBurnTime(stack, recipeType);
        }

        @Override
        public Stream<ItemStack> makeCreativeTabStacks() {
            return BlockBase.this.makeCreativeTabStacks();
        }
    }
}

