/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.datagen.provider.patchouli;

import com.google.common.collect.Streams;
import com.google.gson.JsonElement;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraftforge.common.data.ExistingFileHelper;
import org.moddingx.libx.datagen.DatagenContext;
import org.moddingx.libx.datagen.PackTarget;
import org.moddingx.libx.datagen.provider.patchouli.BookProperties;
import org.moddingx.libx.datagen.provider.patchouli.CategoryBuilder;
import org.moddingx.libx.datagen.provider.patchouli.EntryBuilder;
import org.moddingx.libx.impl.datagen.load.DatagenFontLoader;
import org.moddingx.libx.impl.datagen.patchouli.translate.TranslationManager;
import org.moddingx.libx.mod.ModX;

public abstract class PatchouliProviderBase
implements DataProvider {
    protected final ModX mod;
    protected final PackTarget packTarget;
    protected final ExistingFileHelper fileHelper;
    private final BookProperties properties;
    private final String bookNamespace;
    private final List<CategoryBuilder> categories;
    private final Set<String> categoryIds;
    private final List<EntryBuilder> entries;

    public PatchouliProviderBase(DatagenContext ctx, BookProperties properties) {
        this.mod = ctx.mod();
        this.packTarget = ctx.target();
        this.fileHelper = ctx.fileHelper();
        this.properties = properties;
        this.bookNamespace = properties.namespace() != null ? properties.namespace() : this.mod.modid;
        DatagenFontLoader.getFontMetrics(this.fileHelper);
        this.categories = new ArrayList<CategoryBuilder>();
        this.categoryIds = new HashSet<String>();
        this.entries = new ArrayList<EntryBuilder>();
    }

    protected abstract void setup();

    public CategoryBuilder category(String id) {
        CategoryBuilder builder = new CategoryBuilder(this.mod, new ResourceLocation(this.bookNamespace, id));
        this.categories.add(builder);
        this.categoryIds.add(id);
        return builder;
    }

    public EntryBuilder entry(String id) {
        if (this.categories.isEmpty()) {
            throw new IllegalStateException("No categories defined");
        }
        return this.entry(id, this.categories.get((int)(this.categories.size() - 1)).id.m_135815_());
    }

    public EntryBuilder entry(String id, String category) {
        return this.entry(id, category, false);
    }

    public EntryBuilder foreignEntry(String id, String category) {
        return this.entry(id, category, true);
    }

    private EntryBuilder entry(String id, String category, boolean foreignEntry) {
        if (foreignEntry) {
            if (this.categoryIds.contains(category)) {
                throw new IllegalArgumentException("Foreign entry in known category: " + category);
            }
        } else if (!this.categoryIds.contains(category)) {
            throw new IllegalArgumentException("Unknown category: " + category);
        }
        EntryBuilder builder = new EntryBuilder(this.mod, id, new ResourceLocation(this.bookNamespace, category));
        this.entries.add(builder);
        return builder;
    }

    @Nonnull
    public String m_6055_() {
        return this.mod.modid + " " + (String)(this.properties.namespace() == null ? "" : this.properties.namespace() + ":") + this.properties.bookName() + " patchouli book";
    }

    @Nonnull
    public CompletableFuture<?> m_213708_(@Nonnull CachedOutput cache) {
        BiFunction<String, List, String> translations;
        TranslationManager mgr;
        this.setup();
        if (this.properties.translate()) {
            mgr = new TranslationManager(this.properties.bookName());
            translations = mgr::add;
        } else {
            mgr = null;
            translations = (str, path) -> str;
        }
        return CompletableFuture.allOf((CompletableFuture[])Streams.concat((Stream[])new Stream[]{Streams.mapWithIndex(this.categories.stream(), (category, idx) -> {
            Path path = this.packTarget.path(PackType.CLIENT_RESOURCES).resolve(category.id.m_135827_() + "/patchouli_books/" + this.properties.bookName() + "/en_us/categories/" + category.id.m_135815_() + ".json");
            return DataProvider.m_253162_((CachedOutput)cache, (JsonElement)category.build(translations, (int)idx), (Path)path);
        }), this.entries.stream().map(entry -> {
            Path path = this.packTarget.path(PackType.CLIENT_RESOURCES).resolve(entry.category.m_135827_() + "/patchouli_books/" + this.properties.bookName() + "/en_us/entries/" + entry.category.m_135815_() + "/" + entry.id + ".json");
            return DataProvider.m_253162_((CachedOutput)cache, (JsonElement)entry.build(translations, this.fileHelper), (Path)path);
        }), Stream.ofNullable(mgr).map(theMgr -> {
            Path langPath = this.packTarget.path(PackType.CLIENT_RESOURCES).resolve(this.mod.modid + "_" + this.properties.bookName() + "/lang/en_us.json");
            return DataProvider.m_253162_((CachedOutput)cache, (JsonElement)theMgr.build(), (Path)langPath);
        })}).toArray(CompletableFuture[]::new));
    }
}

