/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.gui;

import com.google.common.collect.ImmutableList;
import fi.dy.masa.malilib.config.ConfigManager;
import fi.dy.masa.malilib.config.IConfigBase;
import fi.dy.masa.malilib.config.gui.ButtonPressDirtyListenerSimple;
import fi.dy.masa.malilib.event.InputEventHandler;
import fi.dy.masa.malilib.gui.GuiListBase;
import fi.dy.masa.malilib.gui.button.ConfigButtonKeybind;
import fi.dy.masa.malilib.gui.interfaces.IConfigInfoProvider;
import fi.dy.masa.malilib.gui.interfaces.IDialogHandler;
import fi.dy.masa.malilib.gui.interfaces.IKeybindConfigGui;
import fi.dy.masa.malilib.gui.widgets.WidgetConfigOption;
import fi.dy.masa.malilib.gui.widgets.WidgetListConfigOptions;
import fi.dy.masa.malilib.util.GuiUtils;
import fi.dy.masa.malilib.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screens.Screen;

public abstract class GuiConfigsBase
extends GuiListBase<ConfigOptionWrapper, WidgetConfigOption, WidgetListConfigOptions>
implements IKeybindConfigGui {
    protected final List<Runnable> hotkeyChangeListeners = new ArrayList<Runnable>();
    protected final ButtonPressDirtyListenerSimple dirtyListener = new ButtonPressDirtyListenerSimple();
    protected final String modId;
    protected ConfigButtonKeybind activeKeybindButton;
    protected int configWidth = 204;
    @Nullable
    protected IConfigInfoProvider hoverInfoProvider;
    @Nullable
    protected IDialogHandler dialogHandler;

    public GuiConfigsBase(int listX, int listY, String modId, @Nullable Screen parent, String titleKey, Object ... args) {
        super(listX, listY);
        this.modId = modId;
        this.title = StringUtils.translate(titleKey, args);
    }

    @Override
    protected int getBrowserWidth() {
        return this.f_96543_ - 20;
    }

    @Override
    protected int getBrowserHeight() {
        return this.f_96544_ - 80;
    }

    protected boolean useKeybindSearch() {
        return false;
    }

    protected int getConfigWidth() {
        return this.configWidth;
    }

    public GuiConfigsBase setConfigWidth(int configWidth) {
        this.configWidth = configWidth;
        return this;
    }

    public GuiConfigsBase setHoverInfoProvider(IConfigInfoProvider provider) {
        this.hoverInfoProvider = provider;
        return this;
    }

    @Override
    @Nullable
    public IDialogHandler getDialogHandler() {
        return this.dialogHandler;
    }

    public void setDialogHandler(@Nullable IDialogHandler handler) {
        this.dialogHandler = handler;
    }

    @Override
    public String getModId() {
        return this.modId;
    }

    @Override
    @Nullable
    public IConfigInfoProvider getHoverInfoProvider() {
        return this.hoverInfoProvider;
    }

    @Override
    protected WidgetListConfigOptions createListWidget(int listX, int listY) {
        return new WidgetListConfigOptions(listX, listY, this.getBrowserWidth(), this.getBrowserHeight(), this.getConfigWidth(), 0.0f, this.useKeybindSearch(), this);
    }

    @Override
    public void m_7861_() {
        if (((WidgetListConfigOptions)this.getListWidget()).wereConfigsModified()) {
            ((WidgetListConfigOptions)this.getListWidget()).applyPendingModifications();
            this.onSettingsChanged();
            ((WidgetListConfigOptions)this.getListWidget()).clearConfigsModifiedFlag();
        }
    }

    protected void onSettingsChanged() {
        ConfigManager.getInstance().onConfigsChanged(this.modId);
        if (this.hotkeyChangeListeners.size() > 0) {
            InputEventHandler.getKeybindManager().updateUsedKeys();
        }
    }

    @Override
    public boolean onKeyTyped(int keyCode, int scanCode, int modifiers) {
        if (this.activeKeybindButton != null) {
            this.activeKeybindButton.onKeyPressed(keyCode);
            return true;
        }
        if (((WidgetListConfigOptions)this.getListWidget()).onKeyTyped(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (keyCode == 256 && this.getParent() != GuiUtils.getCurrentScreen()) {
            this.closeGui(true);
            return true;
        }
        return false;
    }

    @Override
    public boolean onCharTyped(char charIn, int modifiers) {
        if (this.activeKeybindButton != null) {
            return true;
        }
        if (((WidgetListConfigOptions)this.getListWidget()).onCharTyped(charIn, modifiers)) {
            return true;
        }
        return super.onCharTyped(charIn, modifiers);
    }

    @Override
    public boolean onMouseClicked(int mouseX, int mouseY, int mouseButton) {
        if (super.onMouseClicked(mouseX, mouseY, mouseButton)) {
            return true;
        }
        if (this.activeKeybindButton != null) {
            this.activeKeybindButton.onClearSelection();
            this.setActiveKeybindButton(null);
            return true;
        }
        return false;
    }

    @Override
    public void clearOptions() {
        this.setActiveKeybindButton(null);
        this.hotkeyChangeListeners.clear();
    }

    @Override
    public void addKeybindChangeListener(Runnable listener) {
        this.hotkeyChangeListeners.add(listener);
    }

    @Override
    public ButtonPressDirtyListenerSimple getButtonPressListener() {
        return this.dirtyListener;
    }

    @Override
    public void setActiveKeybindButton(@Nullable ConfigButtonKeybind button) {
        if (this.activeKeybindButton != null) {
            this.activeKeybindButton.onClearSelection();
            this.updateKeybindButtons();
        }
        this.activeKeybindButton = button;
        if (this.activeKeybindButton != null) {
            this.activeKeybindButton.onSelected();
        }
    }

    protected void updateKeybindButtons() {
        for (Runnable listener : this.hotkeyChangeListeners) {
            listener.run();
        }
    }

    public static class ConfigOptionWrapper {
        private final Type type;
        @Nullable
        private final IConfigBase config;
        @Nullable
        private final String label;

        public ConfigOptionWrapper(IConfigBase config) {
            this.type = Type.CONFIG;
            this.config = config;
            this.label = null;
        }

        public ConfigOptionWrapper(String label) {
            this.type = Type.LABEL;
            this.config = null;
            this.label = label;
        }

        public Type getType() {
            return this.type;
        }

        @Nullable
        public IConfigBase getConfig() {
            return this.config;
        }

        @Nullable
        public String getLabel() {
            return this.label;
        }

        public static List<ConfigOptionWrapper> createFor(Collection<? extends IConfigBase> configs) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (IConfigBase iConfigBase : configs) {
                builder.add((Object)new ConfigOptionWrapper(iConfigBase));
            }
            return builder.build();
        }

        public static enum Type {
            CONFIG,
            LABEL;

        }
    }
}

