/*
 * Decompiled with CFR 0.152.
 */
package mekanism.tools.common.config;

import mekanism.common.config.BaseMekanismConfig;
import mekanism.common.config.IMekanismConfig;
import mekanism.common.config.value.CachedBooleanValue;
import mekanism.common.config.value.CachedFloatValue;
import mekanism.tools.common.material.MaterialCreator;
import mekanism.tools.common.material.VanillaPaxelMaterialCreator;
import mekanism.tools.common.material.impl.BronzeMaterialDefaults;
import mekanism.tools.common.material.impl.LapisLazuliMaterialDefaults;
import mekanism.tools.common.material.impl.OsmiumMaterialDefaults;
import mekanism.tools.common.material.impl.RefinedGlowstoneMaterialDefaults;
import mekanism.tools.common.material.impl.RefinedObsidianMaterialDefaults;
import mekanism.tools.common.material.impl.SteelMaterialDefaults;
import mekanism.tools.common.material.impl.vanilla.DiamondPaxelMaterialDefaults;
import mekanism.tools.common.material.impl.vanilla.GoldPaxelMaterialDefaults;
import mekanism.tools.common.material.impl.vanilla.IronPaxelMaterialDefaults;
import mekanism.tools.common.material.impl.vanilla.NetheritePaxelMaterialDefaults;
import mekanism.tools.common.material.impl.vanilla.StonePaxelMaterialDefaults;
import mekanism.tools.common.material.impl.vanilla.WoodPaxelMaterialDefaults;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class ToolsConfig
extends BaseMekanismConfig {
    private final ForgeConfigSpec configSpec;
    public final CachedFloatValue armorSpawnChance;
    public final CachedFloatValue weaponSpawnChance;
    public final CachedFloatValue weaponSpawnChanceHard;
    public final ArmorSpawnChanceConfig bronzeSpawnRate;
    public final ArmorSpawnChanceConfig lapisLazuliSpawnRate;
    public final ArmorSpawnChanceConfig osmiumSpawnRate;
    public final ArmorSpawnChanceConfig refinedGlowstoneSpawnRate;
    public final ArmorSpawnChanceConfig refinedObsidianSpawnRate;
    public final ArmorSpawnChanceConfig steelSpawnRate;
    public final VanillaPaxelMaterialCreator wood;
    public final VanillaPaxelMaterialCreator stone;
    public final VanillaPaxelMaterialCreator iron;
    public final VanillaPaxelMaterialCreator diamond;
    public final VanillaPaxelMaterialCreator gold;
    public final VanillaPaxelMaterialCreator netherite;
    public final MaterialCreator bronze;
    public final MaterialCreator lapisLazuli;
    public final MaterialCreator osmium;
    public final MaterialCreator refinedGlowstone;
    public final MaterialCreator refinedObsidian;
    public final MaterialCreator steel;

    ToolsConfig() {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.comment("Mekanism Tools Config. This config is synced from server to client.").push("tools");
        builder.push("mobArmorSpawnRate");
        this.armorSpawnChance = CachedFloatValue.wrap((IMekanismConfig)this, (ForgeConfigSpec.ConfigValue)builder.comment("The chance that Mekanism Armor can spawn on mobs. This is multiplied modified by the chunk's difficulty modifier. Vanilla uses 0.15 for its armor spawns, we use 0.1 as default to lower chances of mobs getting some vanilla and some mek armor.").defineInRange("general", 0.1, 0.0, 1.0));
        this.weaponSpawnChance = CachedFloatValue.wrap((IMekanismConfig)this, (ForgeConfigSpec.ConfigValue)builder.comment("The chance that Mekanism Weapons can spawn in a zombie's hand.").defineInRange("weapon", 0.01, 0.0, 1.0));
        this.weaponSpawnChanceHard = CachedFloatValue.wrap((IMekanismConfig)this, (ForgeConfigSpec.ConfigValue)builder.comment("The chance that Mekanism Weapons can spawn in a zombie's hand when on hard difficulty.").defineInRange("weaponHard", (double)0.05f, 0.0, 1.0));
        this.bronzeSpawnRate = new ArmorSpawnChanceConfig((IMekanismConfig)this, builder, "bronze", "Bronze");
        this.lapisLazuliSpawnRate = new ArmorSpawnChanceConfig((IMekanismConfig)this, builder, "lapis_lazuli", "Lapis Lazuli");
        this.osmiumSpawnRate = new ArmorSpawnChanceConfig((IMekanismConfig)this, builder, "osmium", "Osmium");
        this.refinedGlowstoneSpawnRate = new ArmorSpawnChanceConfig((IMekanismConfig)this, builder, "refined_glowstone", "Refined Glowstone");
        this.refinedObsidianSpawnRate = new ArmorSpawnChanceConfig((IMekanismConfig)this, builder, "refined_obsidian", "Refined Obsidian");
        this.steelSpawnRate = new ArmorSpawnChanceConfig((IMekanismConfig)this, builder, "steel", "Steel");
        builder.pop();
        this.wood = new VanillaPaxelMaterialCreator((IMekanismConfig)this, builder, new WoodPaxelMaterialDefaults());
        this.stone = new VanillaPaxelMaterialCreator((IMekanismConfig)this, builder, new StonePaxelMaterialDefaults());
        this.iron = new VanillaPaxelMaterialCreator((IMekanismConfig)this, builder, new IronPaxelMaterialDefaults());
        this.diamond = new VanillaPaxelMaterialCreator((IMekanismConfig)this, builder, new DiamondPaxelMaterialDefaults());
        this.gold = new VanillaPaxelMaterialCreator((IMekanismConfig)this, builder, new GoldPaxelMaterialDefaults());
        this.netherite = new VanillaPaxelMaterialCreator((IMekanismConfig)this, builder, new NetheritePaxelMaterialDefaults());
        this.bronze = new MaterialCreator((IMekanismConfig)this, builder, new BronzeMaterialDefaults());
        this.lapisLazuli = new MaterialCreator((IMekanismConfig)this, builder, new LapisLazuliMaterialDefaults());
        this.osmium = new MaterialCreator((IMekanismConfig)this, builder, new OsmiumMaterialDefaults());
        this.refinedGlowstone = new MaterialCreator((IMekanismConfig)this, builder, new RefinedGlowstoneMaterialDefaults());
        this.refinedObsidian = new MaterialCreator((IMekanismConfig)this, builder, new RefinedObsidianMaterialDefaults());
        this.steel = new MaterialCreator((IMekanismConfig)this, builder, new SteelMaterialDefaults());
        builder.pop();
        this.configSpec = builder.build();
    }

    public String getFileName() {
        return "tools";
    }

    public ForgeConfigSpec getConfigSpec() {
        return this.configSpec;
    }

    public ModConfig.Type getConfigType() {
        return ModConfig.Type.SERVER;
    }

    public static class ArmorSpawnChanceConfig {
        public final CachedBooleanValue canSpawnWeapon;
        public final CachedFloatValue swordWeight;
        public final CachedFloatValue helmetChance;
        public final CachedFloatValue chestplateChance;
        public final CachedFloatValue leggingsChance;
        public final CachedFloatValue bootsChance;
        public final CachedFloatValue multiplePieceChance;
        public final CachedFloatValue multiplePieceChanceHard;
        public final CachedFloatValue weaponEnchantmentChance;
        public final CachedFloatValue armorEnchantmentChance;

        private ArmorSpawnChanceConfig(IMekanismConfig config, ForgeConfigSpec.Builder builder, String armorKey, String armor) {
            this(config, builder, armorKey, armor, 0.33, 1.0, 1.0, 1.0, 1.0, 0.25, 0.5);
        }

        private ArmorSpawnChanceConfig(IMekanismConfig config, ForgeConfigSpec.Builder builder, String armorKey, String armor, double swordChance, double helmetChance, double chestplateChance, double leggingsChance, double bootsChance, double weaponEnchantmentChance, double armorEnchantmentChance) {
            builder.comment("Spawn chances for pieces of " + armor + " gear. Note: These values are after the general mobArmorSpawnRate (or corresponding weapon rate) has been checked, and after an even split between material types has been done.").push(armorKey);
            this.canSpawnWeapon = CachedBooleanValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("Whether mobs can spawn with " + armor + " Weapons.").define("canSpawnWeapon", true));
            this.swordWeight = CachedFloatValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("The chance that mobs will spawn with " + armor + " Swords rather than " + armor + " Shovels.").defineInRange("swordWeight", swordChance, 0.0, 1.0));
            this.helmetChance = CachedFloatValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("The chance that mobs can spawn with " + armor + " Helmets.").defineInRange("helmetChance", helmetChance, 0.0, 1.0));
            this.chestplateChance = CachedFloatValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("The chance that mobs can spawn with " + armor + " Chestplates.").defineInRange("chestplateChance", chestplateChance, 0.0, 1.0));
            this.leggingsChance = CachedFloatValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("The chance that mobs can spawn with " + armor + " Leggings.").defineInRange("leggingsChance", leggingsChance, 0.0, 1.0));
            this.bootsChance = CachedFloatValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("The chance that mobs can spawn with " + armor + " Boots.").defineInRange("bootsChance", bootsChance, 0.0, 1.0));
            this.multiplePieceChance = CachedFloatValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("The chance that after each piece of " + armor + " Armor a mob spawns with that no more pieces will be added. Order of pieces tried is boots, leggings, chestplate, helmet.").defineInRange("multiplePieceChance", 0.25, 0.0, 1.0));
            this.multiplePieceChanceHard = CachedFloatValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("The chance on hard mode that after each piece of " + armor + " Armor a mob spawns with that no more pieces will be added. Order of pieces tried is boots, leggings, chestplate, helmet.").defineInRange("multiplePieceChanceHard", 0.1, 0.0, 1.0));
            this.weaponEnchantmentChance = CachedFloatValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("The chance that if a mob spawns with " + armor + " Weapons that it will be enchanted. This is multiplied modified by the chunk's difficulty modifier.").defineInRange("weaponEnchantmentChance", weaponEnchantmentChance, 0.0, 1.0));
            this.armorEnchantmentChance = CachedFloatValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("The chance that if a mob spawns with " + armor + " Armor that they will be enchanted. This is multiplied modified by the chunk's difficulty modifier.").defineInRange("armorEnchantmentChance", armorEnchantmentChance, 0.0, 1.0));
            builder.pop();
        }
    }
}

