/*
 * Decompiled with CFR 0.152.
 */
package com.focamacho.mysticaladaptations.augment;

import com.blakebr0.cucumber.helper.BlockHelper;
import com.blakebr0.mysticalagriculture.api.tinkering.Augment;
import com.blakebr0.mysticalagriculture.api.tinkering.AugmentType;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;

public class WoodcutterAugment
extends Augment {
    public WoodcutterAugment(ResourceLocation id) {
        super(id, 6, EnumSet.of(AugmentType.AXE), 0xEEE050, 2825844);
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, Player player) {
        Level world = player.m_20193_();
        return !this.harvest(stack, world, pos, player);
    }

    private boolean harvest(ItemStack stack, Level world, BlockPos pos, Player player) {
        if (world.f_46443_) {
            return false;
        }
        boolean woodcutter = !player.m_6047_();
        BlockPos blockPos = pos;
        ArrayList<BlockPos> toHarvest = new ArrayList<BlockPos>();
        if (woodcutter) {
            do {
                toHarvest.add(blockPos);
            } while (this.isWood(world.m_8055_(blockPos = blockPos.m_7494_()).m_60734_()));
        } else {
            toHarvest.add(pos);
        }
        BlockState state = world.m_8055_(pos);
        float hardness = state.m_60800_((BlockGetter)world, pos);
        if (!this.tryHarvest(world, pos, false, stack, player)) {
            return false;
        }
        if (woodcutter && hardness >= 0.2f && stack.m_41735_(state)) {
            toHarvest.forEach(woodPos -> {
                if (woodPos != pos) {
                    this.tryHarvest(world, (BlockPos)woodPos, true, stack, player);
                }
            });
        }
        return true;
    }

    private boolean tryHarvest(Level world, BlockPos pos, boolean extra, ItemStack stack, Player player) {
        BlockState state = world.m_8055_(pos);
        float hardness = state.m_60800_((BlockGetter)world, pos);
        Item item = stack.m_41720_();
        boolean harvest = !(!state.canHarvestBlock((BlockGetter)world, pos, player) && !item.isCorrectToolForDrops(stack, state) || extra && !(item.m_8102_(stack, world.m_8055_(pos)) > 1.0f));
        return !(hardness < 0.0f || extra && !harvest || !BlockHelper.harvestAOEBlock((ItemStack)stack, (Level)world, (ServerPlayer)((ServerPlayer)player), (BlockPos)pos));
    }

    private boolean isWood(Block block) {
        return Objects.requireNonNull(ForgeRegistries.BLOCKS.tags()).getTag(BlockTags.f_13106_).contains((Object)block);
    }
}

