/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.onlinedisplays;

import java.io.File;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.dedicated.Settings;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.zeith.hammerlib.core.adapter.LanguageAdapter;
import org.zeith.hammerlib.util.CommonMessages;
import org.zeith.onlinedisplays.CommandOnlineDisplay;
import org.zeith.onlinedisplays.OnlineDisplaysProperties;
import org.zeith.onlinedisplays.ext.gif.ExtGIF;
import org.zeith.onlinedisplays.ext.webp.ExtWebP;
import org.zeith.onlinedisplays.init.BlocksOD;
import org.zeith.onlinedisplays.proxy.ClientODProxy;
import org.zeith.onlinedisplays.proxy.CommonODProxy;
import org.zeith.onlinedisplays.util.ExtensionParser;

@Mod(value="onlinedisplays")
public class OnlineDisplays {
    public static final Logger LOG = LogManager.getLogger((String)"OnlineDisplays");
    public static final String MOD_ID = "onlinedisplays";
    private static final Map<String, ExtensionParser> EXTENSION_PARSERS = new HashMap<String, ExtensionParser>();
    public static final CommonODProxy PROXY = (CommonODProxy)DistExecutor.unsafeRunForDist(() -> ClientODProxy::new, () -> CommonODProxy::new);
    public static final Pattern URL_REGEX = Pattern.compile("https?:\\/\\/(www\\.)?[-a-zA-Z0-9@:%._\\+~#=]{1,256}\\.[a-zA-Z0-9()]{1,6}\\b([-a-zA-Z0-9()@:%_\\+.~#?&//=]*)");
    public static final Predicate<String> URL_TEST = URL_REGEX.asPredicate();
    private static OnlineDisplaysProperties modSettings;
    public static Component EMPTY_TXT;

    public OnlineDisplays() {
        CommonMessages.printMessageOnIllegalRedistribution(OnlineDisplays.class, (Logger)LOG, (String)"OnlineDisplays", (String)"https://www.curseforge.com/minecraft/mc-mods/online-displays");
        PROXY.construct();
        LanguageAdapter.registerMod((String)MOD_ID);
        IEventBus mbus = FMLJavaModLoadingContext.get().getModEventBus();
        mbus.addListener(this::processIMC);
        mbus.addListener(this::populateCreative);
        MinecraftForge.EVENT_BUS.addListener(this::registerCommands);
        OnlineDisplays.getModSettings();
        InterModComms.sendTo((String)MOD_ID, (String)"add_ext", ExtWebP::new);
        InterModComms.sendTo((String)MOD_ID, (String)"add_ext", ExtGIF::new);
    }

    public void populateCreative(BuildCreativeModeTabContentsEvent e) {
        if (e.getTabKey() == CreativeModeTabs.f_257028_) {
            e.m_246326_((ItemLike)BlocksOD.DISPLAY);
        }
    }

    private void registerCommands(RegisterCommandsEvent e) {
        e.getDispatcher().register(CommandOnlineDisplay.create());
    }

    public static OnlineDisplaysProperties getModSettings() {
        if (modSettings == null) {
            File props = new File(OnlineDisplays.getModConfigDir(), "main.properties");
            Properties prop = props.isFile() ? Settings.m_139839_((Path)props.toPath()) : new Properties();
            modSettings = new OnlineDisplaysProperties(prop);
            modSettings.m_139876_(props.toPath());
        }
        return modSettings;
    }

    private void processIMC(InterModProcessEvent e) {
        e.getIMCStream().forEach(msg -> {
            Object o;
            if (msg.getMethod().equalsIgnoreCase("add_ext") && (o = msg.getMessageSupplier().get()) instanceof ExtensionParser) {
                ExtensionParser parser = (ExtensionParser)o;
                LOG.info("Registering extension parser for ." + parser.extension + " files from " + msg.getSenderModId());
                EXTENSION_PARSERS.put(parser.extension, parser);
            }
        });
    }

    public static ResourceLocation id(String path) {
        return new ResourceLocation(MOD_ID, path);
    }

    public static MutableComponent gui(String path) {
        return Component.m_237115_((String)("gui.onlinedisplays." + path));
    }

    public static MutableComponent info(String path) {
        return Component.m_237115_((String)("info.onlinedisplays." + path));
    }

    public static File getModConfigDir() {
        File f = FMLPaths.CONFIGDIR.get().resolve(MOD_ID).toFile();
        if (!f.isDirectory()) {
            f.mkdirs();
        }
        return f;
    }

    public static File getModDir() {
        File f = FMLPaths.GAMEDIR.get().resolve("$onlinedisplays").toFile();
        if (!f.isDirectory()) {
            f.mkdirs();
        }
        return f;
    }

    public static ExtensionParser findExtensionParser(String fileName) {
        int lastDot = fileName.lastIndexOf(46);
        if (lastDot < 0) {
            return ExtensionParser.IDENTITY;
        }
        String ext = fileName.substring(lastDot + 1).toLowerCase(Locale.ROOT);
        return EXTENSION_PARSERS.getOrDefault(ext, ExtensionParser.IDENTITY);
    }

    static {
        EMPTY_TXT = Component.m_237113_((String)"");
    }
}

